/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.Function;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.blocks.devices.ChannelBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.MoldBlock;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.ClutchBlock;
import net.dries007.tfc.common.blocks.rotation.CrankshaftBlock;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public final class PatchouliIntegration {
    public static final ResourceLocation BOOK_ID = Helpers.identifier("field_guide");
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/gui/book/icons.png");
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ItemStack getFieldGuide(boolean useHotReloadedBook) {
        return PatchouliAPI.get().getBookStack(useHotReloadedBook ? Helpers.resourceLocation("patchouli", "field_guide") : BOOK_ID);
    }

    public static void ifEnabled(Runnable action) {
        if (TFCConfig.CLIENT.showGuideBookTabInInventory.get().booleanValue()) {
            action.run();
        }
    }

    public static void openGui(ServerPlayer player) {
        PatchouliAPI.get().openBookGUI(player, BOOK_ID);
    }

    public static void openGui(ServerPlayer player, ResourceLocation entry, int page) {
        PatchouliAPI.get().openBookEntry(player, BOOK_ID, entry, page);
    }

    public static void registerMultiBlocks() {
        PatchouliIntegration.registerMultiblock("bloomery", PatchouliIntegration::bloomery);
        PatchouliIntegration.registerMultiblock("blast_furnace", api -> PatchouliIntegration.blastFurnace(api, false));
        PatchouliIntegration.registerMultiblock("full_blast_furnace", api -> PatchouliIntegration.blastFurnace(api, true));
        PatchouliIntegration.registerMultiblock("rock_anvil", PatchouliIntegration::rockAnvil);
        PatchouliIntegration.registerMultiblock("charcoal_forge", PatchouliIntegration::charcoalForge);
        PatchouliIntegration.registerMultiblock("channel_casting", PatchouliIntegration::channelCasting);
        PatchouliIntegration.registerMultiblock("windmill", PatchouliIntegration::windmill);
        PatchouliIntegration.registerMultiblock("water_wheel", PatchouliIntegration::waterWheel);
        PatchouliIntegration.registerMultiblock("clutch_off", api -> PatchouliIntegration.clutch(api, false));
        PatchouliIntegration.registerMultiblock("clutch_on", api -> PatchouliIntegration.clutch(api, true));
        PatchouliIntegration.registerMultiblock("crankshaft", PatchouliIntegration::crankshaft);
        PatchouliIntegration.registerMultiblock("rotating_quern", PatchouliIntegration::rotatingQuern);
    }

    private static IMultiblock blastFurnace(PatchouliAPI.IPatchouliAPI api, boolean fullSize) {
        String[][] stringArray;
        if (fullSize) {
            String[][] stringArrayArray = new String[7][];
            stringArrayArray[0] = new String[]{"RRR", "R R", "RRR"};
            stringArrayArray[1] = new String[]{"RRR", "R R", "RRR"};
            stringArrayArray[2] = new String[]{"RRR", "R R", "RRR"};
            stringArrayArray[3] = new String[]{"RRR", "R R", "RRR"};
            stringArrayArray[4] = new String[]{"RRR", "R R", "RRR"};
            stringArrayArray[5] = new String[]{"   ", " 0B", "   "};
            stringArray = stringArrayArray;
            stringArrayArray[6] = new String[]{"   ", " C ", "   "};
        } else {
            String[][] stringArray2 = new String[2][];
            stringArray2[0] = new String[]{"RRR", "R R", "RRR"};
            stringArray = stringArray2;
            stringArray2[1] = new String[]{"   ", " 0 ", "   "};
        }
        String[][] pattern = stringArray;
        IMultiblock multiblock = api.makeMultiblock(pattern, new Object[]{Character.valueOf('0'), api.looseBlockMatcher((Block)TFCBlocks.BLAST_FURNACE.get()), Character.valueOf(' '), api.anyMatcher(), Character.valueOf('R'), api.predicateMatcher((Block)TFCBlocks.REINFORCED_FIRE_BRICKS.get(), BlastFurnaceBlock::isBlastFurnaceInsulationBlock), Character.valueOf('B'), api.looseBlockMatcher((Block)TFCBlocks.BELLOWS.get()), Character.valueOf('C'), api.looseBlockMatcher((Block)TFCBlocks.CRUCIBLE.get())});
        return multiblock;
    }

    private static IMultiblock bloomery(PatchouliAPI.IPatchouliAPI api) {
        IStateMatcher bloomeryInsulation = api.predicateMatcher((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.GRANITE).get((Object)Rock.BlockType.BRICKS).get(), BloomeryBlock::isBloomeryInsulationBlock);
        return api.makeMultiblock((String[][])new String[][]{{" S ", "SAS", " S "}, {"SBS", "SAS", " S "}, {" S ", " 0 ", "   "}}, new Object[]{Character.valueOf('0'), bloomeryInsulation, Character.valueOf('A'), api.airMatcher(), Character.valueOf('S'), bloomeryInsulation, Character.valueOf('B'), api.predicateMatcher((BlockState)((Block)TFCBlocks.BLOOMERY.get()).defaultBlockState().setValue((Property)BloomeryBlock.FACING, (Comparable)Direction.NORTH), state -> Helpers.isBlock(state, (Block)TFCBlocks.BLOOMERY.get())), Character.valueOf(' '), api.anyMatcher()});
    }

    private static IMultiblock charcoalForge(PatchouliAPI.IPatchouliAPI api) {
        IStateMatcher forgeInsulation = api.predicateMatcher((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.QUARTZITE).get((Object)Rock.BlockType.COBBLE).get(), CharcoalForgeBlock::isForgeInsulationBlock);
        BlockState charcoalPile = ((Block)TFCBlocks.CHARCOAL_PILE.get()).defaultBlockState();
        return api.makeMultiblock((String[][])new String[][]{{" S ", "S0S", " S "}, {"   ", " S ", "   "}}, new Object[]{Character.valueOf('0'), api.predicateMatcher((BlockState)charcoalPile.setValue((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf(7)), state -> Helpers.isBlock(state, (Block)TFCBlocks.CHARCOAL_PILE.get()) && (Integer)state.getValue((Property)CharcoalPileBlock.LAYERS) >= 7), Character.valueOf(' '), api.anyMatcher(), Character.valueOf('S'), forgeInsulation});
    }

    private static IMultiblock rockAnvil(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{" 0 "}, {"RAR"}}, new Object[]{Character.valueOf('0'), api.airMatcher(), Character.valueOf(' '), api.anyMatcher(), Character.valueOf('R'), api.strictBlockMatcher((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.GABBRO).get((Object)Rock.BlockType.RAW).get()), Character.valueOf('A'), api.strictBlockMatcher((Block)TFCBlocks.ROCK_ANVILS.get(Rock.GABBRO).get())});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).flatMap(access -> access.getBlockEntity(new BlockPos(0, 0, 1), (BlockEntityType)TFCBlockEntities.ANVIL.get())).ifPresent(anvil -> anvil.setInventoryFromOutsideWorld(new ItemStack((ItemLike)TFCItems.METAL_ITEMS.get(Metal.COPPER).get((Object)Metal.ItemType.INGOT).get()), new ItemStack((ItemLike)TFCItems.ROCK_TOOLS.get((Object)RockCategory.IGNEOUS_EXTRUSIVE).get((Object)RockCategory.ItemType.HAMMER).get()), new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.FLUX).get())));
        return multiblock;
    }

    private static IMultiblock channelCasting(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"     ", "   R ", "   | ", " S-+c", "     "}, {"  XXX", "  XFX", "  0XX", "CNXXX", "  XXX"}, {"     ", "     ", "XXX  ", "XXX  ", "XXX  "}}, new Object[]{Character.valueOf('R'), api.stateMatcher((BlockState)((Block)TFCBlocks.CRUCIBLE.get()).defaultBlockState().setValue((Property)PipeBlock.EAST, (Comparable)Boolean.valueOf(true))), Character.valueOf('F'), api.looseBlockMatcher((Block)TFCBlocks.CHARCOAL_FORGE.get()), Character.valueOf(' '), api.airMatcher(), Character.valueOf('X'), api.looseBlockMatcher((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.GRANITE).get((Object)Rock.BlockType.BRICKS).get()), Character.valueOf('0'), api.looseBlockMatcher((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.GRANITE).get((Object)Rock.BlockType.BRICKS).get()), Character.valueOf('|'), api.stateMatcher((BlockState)((BlockState)((Block)TFCBlocks.CHANNEL.get()).defaultBlockState().setValue((Property)ChannelBlock.WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)ChannelBlock.EAST, (Comparable)Boolean.valueOf(true))), Character.valueOf('-'), api.stateMatcher((BlockState)((BlockState)((Block)TFCBlocks.CHANNEL.get()).defaultBlockState().setValue((Property)ChannelBlock.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)ChannelBlock.NORTH, (Comparable)Boolean.valueOf(true))), Character.valueOf('+'), api.stateMatcher((BlockState)((BlockState)((BlockState)((Block)TFCBlocks.CHANNEL.get()).defaultBlockState().setValue((Property)ChannelBlock.SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)ChannelBlock.NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)ChannelBlock.WEST, (Comparable)Boolean.valueOf(true))), Character.valueOf('S'), api.stateMatcher((BlockState)((Block)TFCBlocks.CHANNEL.get()).defaultBlockState().setValue((Property)ChannelBlock.SOUTH, (Comparable)Boolean.valueOf(true))), Character.valueOf('N'), api.stateMatcher((BlockState)((Block)TFCBlocks.CHANNEL.get()).defaultBlockState().setValue((Property)ChannelBlock.NORTH, (Comparable)Boolean.valueOf(true))), Character.valueOf('C'), api.stateMatcher((BlockState)((Block)TFCBlocks.MOLD_TABLE.get()).defaultBlockState().setValue((Property)MoldBlock.SOUTH, (Comparable)Boolean.valueOf(true))), Character.valueOf('c'), api.stateMatcher((BlockState)((Block)TFCBlocks.MOLD_TABLE.get()).defaultBlockState().setValue((Property)MoldBlock.NORTH, (Comparable)Boolean.valueOf(true)))});
        return multiblock;
    }

    private static IMultiblock windmill(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"             "}, {"             "}, {"             "}, {"             "}, {"             "}, {"             "}, {"      0      "}, {"             "}, {"             "}, {"             "}, {"             "}, {"             "}, {"             "}}, new Object[]{Character.valueOf('0'), api.predicateMatcher((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.WINDMILL).get()).defaultBlockState().setValue((Property)WindmillBlock.COUNT, (Comparable)Integer.valueOf(5)), state -> state.getBlock() instanceof WindmillBlock), Character.valueOf(' '), api.airMatcher()});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).flatMap(access -> access.getBlockEntity(new BlockPos(0, 6, 6), (BlockEntityType)TFCBlockEntities.WINDMILL.get())).ifPresent(entity -> entity.getRotationNode().setRotationFromOutsideWorld());
        return multiblock;
    }

    private static IMultiblock waterWheel(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"     "}, {"     "}, {"  0  "}, {"WWWWW"}, {"WWWWW"}}, new Object[]{Character.valueOf('0'), api.stateMatcher(((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.WATER_WHEEL).get()).defaultBlockState()), Character.valueOf('W'), api.predicateMatcher(Blocks.WATER, state -> state.getFluidState().getType() == Fluids.WATER), Character.valueOf(' '), api.airMatcher()});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).flatMap(access -> access.getBlockEntity(new BlockPos(0, 2, 2), (BlockEntityType)TFCBlockEntities.WATER_WHEEL.get())).ifPresent(entity -> entity.getRotationNode().setRotationFromOutsideWorld());
        return multiblock;
    }

    private static IMultiblock clutch(PatchouliAPI.IPatchouliAPI api, boolean powered) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"     ", "     ", "     "}, {"  RL ", "  0  ", "AACAA"}}, new Object[]{Character.valueOf('L'), api.stateMatcher((BlockState)((BlockState)((BlockState)Blocks.LEVER.defaultBlockState().setValue((Property)LeverBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)LeverBlock.FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)LeverBlock.POWERED, (Comparable)Boolean.valueOf(powered))), Character.valueOf('R'), api.stateMatcher((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.REDSTONE_WIRE.defaultBlockState().setValue((Property)RedStoneWireBlock.EAST, (Comparable)RedstoneSide.SIDE)).setValue((Property)RedStoneWireBlock.NORTH, (Comparable)RedstoneSide.NONE)).setValue((Property)RedStoneWireBlock.SOUTH, (Comparable)RedstoneSide.SIDE)).setValue((Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.NONE)).setValue((Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(powered ? 15 : 0))), Character.valueOf('0'), api.stateMatcher((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.REDSTONE_WIRE.defaultBlockState().setValue((Property)RedStoneWireBlock.EAST, (Comparable)RedstoneSide.SIDE)).setValue((Property)RedStoneWireBlock.NORTH, (Comparable)RedstoneSide.NONE)).setValue((Property)RedStoneWireBlock.SOUTH, (Comparable)RedstoneSide.NONE)).setValue((Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE)).setValue((Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(powered ? 14 : 0))), Character.valueOf('C'), api.stateMatcher((BlockState)((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.CLUTCH).get()).defaultBlockState().setValue((Property)ClutchBlock.AXIS, (Comparable)Direction.Axis.Z)).setValue((Property)ClutchBlock.POWERED, (Comparable)Boolean.valueOf(powered))), Character.valueOf('A'), api.stateMatcher((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.AXLE).get()).defaultBlockState().setValue((Property)AxleBlock.AXIS, (Comparable)Direction.Axis.Z)), Character.valueOf(' '), api.airMatcher()});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).ifPresent(access -> {
            for (int z = 0; z < (powered ? 3 : 5); ++z) {
                access.getBlockEntity(new BlockPos(2, 0, z), (BlockEntityType)TFCBlockEntities.AXLE.get()).ifPresent(axle -> axle.getRotationNode().setRotationFromOutsideWorld());
            }
        });
        return multiblock;
    }

    private static IMultiblock crankshaft(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{" A ", "S0 ", "   "}}, new Object[]{Character.valueOf('A'), api.stateMatcher((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.AXLE).get()).defaultBlockState().setValue((Property)AxleBlock.AXIS, (Comparable)Direction.Axis.X)), Character.valueOf('0'), api.stateMatcher((BlockState)((BlockState)((Block)TFCBlocks.CRANKSHAFT.get()).defaultBlockState().setValue(CrankshaftBlock.PART, (Comparable)((Object)CrankshaftBlock.Part.BASE))).setValue(CrankshaftBlock.FACING, (Comparable)Direction.NORTH)), Character.valueOf('S'), api.stateMatcher((BlockState)((BlockState)((Block)TFCBlocks.CRANKSHAFT.get()).defaultBlockState().setValue(CrankshaftBlock.PART, (Comparable)((Object)CrankshaftBlock.Part.SHAFT))).setValue(CrankshaftBlock.FACING, (Comparable)Direction.NORTH)), Character.valueOf(' '), api.airMatcher()});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).ifPresent(access -> {
            access.getBlockEntity(new BlockPos(0, 0, 1), (BlockEntityType)TFCBlockEntities.AXLE.get()).ifPresent(axle -> axle.getRotationNode().setRotationFromOutsideWorld());
            access.getBlockEntity(new BlockPos(1, 0, 1), (BlockEntityType)TFCBlockEntities.CRANKSHAFT.get()).ifPresent(shaft -> shaft.getRotationNode().setRotationFromOutsideWorld());
            access.getBlockEntity(new BlockPos(1, 0, 0), (BlockEntityType)TFCBlockEntities.CRANKSHAFT.get()).ifPresent(shaft -> shaft.getRotationNode().setRotationFromOutsideWorld());
        });
        return multiblock;
    }

    private static IMultiblock rotatingQuern(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"T"}, {"0"}, {" "}}, new Object[]{Character.valueOf(' '), api.airMatcher(), Character.valueOf('0'), api.stateMatcher(((Block)TFCBlocks.QUERN.get()).defaultBlockState()), Character.valueOf('T'), api.stateMatcher((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.AXLE).get()).defaultBlockState().setValue((Property)AxleBlock.AXIS, (Comparable)Direction.Axis.Y))});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).ifPresent(access -> {
            access.getBlockEntity(new BlockPos(0, 1, 0), (BlockEntityType)TFCBlockEntities.QUERN.get()).ifPresent(quern -> {
                quern.getRotationNode().setRotationFromOutsideWorld();
                quern.setHandstoneFromOutsideWorld();
            });
            access.getBlockEntity(new BlockPos(0, 2, 0), (BlockEntityType)TFCBlockEntities.AXLE.get()).ifPresent(axle -> axle.getRotationNode().setRotationFromOutsideWorld());
        });
        return multiblock;
    }

    private static void registerMultiblock(String name, Function<PatchouliAPI.IPatchouliAPI, IMultiblock> factory) {
        PatchouliAPI.IPatchouliAPI api = PatchouliAPI.get();
        api.registerMultiblock(Helpers.identifier(name), factory.apply(api));
    }

    private static Optional<BlockGetter> sneakIntoMultiblock(IMultiblock multiblock) {
        if (multiblock instanceof BlockGetter) {
            BlockGetter access = (BlockGetter)multiblock;
            return Optional.of(access);
        }
        LOGGER.warn("Multiblock of concrete type {} is not a {}, multiblock will be disfigured!", (Object)multiblock.getClass().getName(), (Object)BlockGetter.class.getName());
        return Optional.empty();
    }
}

