/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli.component;

import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.compat.patchouli.component.InputOutputComponent;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import vazkii.patchouli.api.IComponentRenderContext;

public class HeatingComponent
extends InputOutputComponent<HeatingRecipe> {
    @Override
    public void render(GuiGraphics graphics, IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        if (this.recipe == null) {
            return;
        }
        this.renderSetup(graphics);
        int v = !((HeatingRecipe)this.recipe).getDisplayOutputFluid().isEmpty() ? 116 : 90;
        graphics.blit(PatchouliIntegration.TEXTURE, 9, 0, 0.0f, (float)v, 98, 26, 256, 256);
        context.renderIngredient(graphics, 14, 5, mouseX, mouseY, this.getIngredient((HeatingRecipe)this.recipe));
        context.renderItemStack(graphics, 86, 5, mouseX, mouseY, this.getOutput((HeatingRecipe)this.recipe));
        this.renderFluidStack(context, graphics, 64, 5, mouseX, mouseY, ((HeatingRecipe)this.recipe).getDisplayOutputFluid());
        MutableComponent tooltip = TFCConfig.CLIENT.heatTooltipStyle.get().format(((HeatingRecipe)this.recipe).getTemperature());
        if (tooltip != null) {
            Font font = Minecraft.getInstance().font;
            int centerX = 56 - font.width(tooltip.getString()) / 2;
            graphics.drawString(font, (Component)tooltip, centerX, 28, 0x404040, false);
        }
        graphics.pose().popPose();
    }

    @Override
    public Ingredient getIngredient(HeatingRecipe recipe) {
        return recipe.getIngredient();
    }

    @Override
    public ItemStack getOutput(HeatingRecipe recipe) {
        return recipe.getResultItem(null);
    }

    @Override
    protected RecipeType<HeatingRecipe> getRecipeType() {
        return (RecipeType)TFCRecipeTypes.HEATING.get();
    }
}

