/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli.component;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.compat.patchouli.component.RecipeComponent;
import net.dries007.tfc.util.data.KnappingPattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentRenderContext;

public class KnappingComponent
extends RecipeComponent<KnappingRecipe> {
    protected transient ItemStack @Nullable [] inputs;

    public static void render(GuiGraphics graphics, IComponentRenderContext context, int mouseX, int mouseY, KnappingRecipe recipe, ItemStack resultStack, @Nullable ResourceLocation highTexture, @Nullable ResourceLocation lowTexture, int x0, int y0) {
        graphics.blit(PatchouliIntegration.TEXTURE, x0, y0, 0.0f, 0.0f, 116, 90, 256, 256);
        KnappingPattern pattern = recipe.getPattern();
        int offsetY = (5 - pattern.getHeight()) / 2;
        int offsetX = (5 - pattern.getWidth()) / 2;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                if (0 <= y - offsetY && y - offsetY < pattern.getHeight() && 0 <= x - offsetX && x - offsetX < pattern.getWidth()) {
                    KnappingComponent.drawSquare(graphics, pattern.get(x - offsetX, y - offsetY) ? highTexture : lowTexture, x0, y0, x, y);
                    continue;
                }
                KnappingComponent.drawSquare(graphics, pattern.defaultIsOn() ? highTexture : lowTexture, x0, y0, x, y);
            }
        }
        context.renderItemStack(graphics, 95, 37, mouseX, mouseY, resultStack);
    }

    private static void drawSquare(GuiGraphics graphics, @Nullable ResourceLocation texture, int x0, int y0, int x, int y) {
        if (texture != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            graphics.blit(texture, x0 + 5 + x * 16, y0 + 5 + y * 16, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    @Override
    public void build(int componentX, int componentY, int pageNum) {
        super.build(componentX, componentY, pageNum);
        if (this.recipe != null) {
            this.inputs = (ItemStack[])Arrays.stream(((KnappingRecipe)this.recipe).knappingType().get().inputItem().ingredient().getItems()).filter(stack -> ((KnappingRecipe)this.recipe).matchesItem((ItemStack)stack)).toArray(ItemStack[]::new);
        }
    }

    @Override
    protected RecipeType<KnappingRecipe> getRecipeType() {
        return (RecipeType)TFCRecipeTypes.KNAPPING.get();
    }

    @Override
    public void render(GuiGraphics graphics, IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        if (this.recipe == null || this.inputs == null) {
            return;
        }
        ItemStack input = this.inputs[context.getTicksInBook() / 20 % this.inputs.length];
        ResourceLocation highTexture = KnappingScreen.getHighTexture(input);
        ResourceLocation lowTexture = KnappingScreen.getLowTexture(((KnappingRecipe)this.recipe).knappingType().get(), input);
        ItemStack resultStack = ((KnappingRecipe)this.recipe).getResultItem(null);
        this.renderSetup(graphics);
        KnappingComponent.render(graphics, context, mouseX, mouseY, (KnappingRecipe)this.recipe, resultStack, highTexture, lowTexture, this.x, this.y);
        graphics.pose().popPose();
    }
}

