/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.config;

import java.util.function.Supplier;
import net.dries007.tfc.config.BaseConfig;
import net.dries007.tfc.config.ConfigBuilder;
import net.neoforged.fml.loading.FMLEnvironment;

public class CommonConfig
extends BaseConfig {
    public final Supplier<String> defaultWorldPreset;
    public final Supplier<Integer> defaultMonthLength;
    public final Supplier<Integer> defaultCalendarStartDay;
    public final Supplier<Integer> defaultCalendarDayLength;
    public final Supplier<Boolean> enableDatapackTests;

    CommonConfig(ConfigBuilder builder) {
        builder.push("general");
        this.defaultWorldPreset = builder.comment("If the TFC world preset 'tfc:overworld' should be set as the default world generation when creating a new world.").define("defaultWorldPreset", "tfc:overworld");
        builder.swap("calendar");
        this.defaultMonthLength = builder.comment("The number of days in a month, for newly created worlds.", "", "This can be modified in existing worlds using the /time command").define("defaultMonthLength", 8, 1, Integer.MAX_VALUE);
        this.defaultCalendarStartDay = builder.comment("The start date for newly created worlds, in a number of ticks, for newly created worlds", "This represents a number of days offset from January 1, 1000", "The default is (5 * daysInMonth) = 40, which starts at June 1, 1000 (with the default daysInMonth = 8)").define("defaultCalendarStartDay", 40, -1, Integer.MAX_VALUE);
        this.defaultCalendarDayLength = builder.comment("The month length (in minutes) for newly created worlds", "The default (in TFC) is 24, which at 20 TPS makes one in-game hour equal to exactly one minute of real time.", "", "This can be modified in existing worlds using the /time command").define("defaultCalendarDayLength", 24);
        builder.swap("debug");
        this.enableDatapackTests = builder.comment("If enabled, TFC will validate that certain pieces of reloadable data fit the conditions we expect, for example heating recipes having heatable items. It will error or warn in the log if these conditions are not met.").define("enableDatapackTests", !FMLEnvironment.production);
    }
}

