/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.config;

import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public enum TemperatureDisplayStyle {
    COLOR(temperature -> {
        Heat heat = Heat.getHeat(temperature);
        if (heat != null) {
            MutableComponent base = Helpers.translateEnum(heat);
            if (heat != Heat.BRILLIANT_WHITE) {
                for (int i = 1; i <= 4; ++i) {
                    if (temperature <= heat.getMin() + (float)i * 0.2f * (heat.getMax() - heat.getMin())) continue;
                    base.append("\u066d");
                }
            }
            return base;
        }
        return null;
    }),
    CELSIUS(temperature -> Component.translatable((String)"tfc.tooltip.temperature_celsius", (Object[])new Object[]{String.format("%.0f", Float.valueOf(temperature))})),
    FAHRENHEIT(temperature -> Component.translatable((String)"tfc.tooltip.temperature_fahrenheit", (Object[])new Object[]{String.format("%.0f", Float.valueOf(temperature * 1.8f + 32.0f))})),
    RANKINE(temperature -> Component.translatable((String)"tfc.tooltip.temperature_rankine", (Object[])new Object[]{String.format("%.0f", Float.valueOf(temperature * 1.8f + 32.0f - 459.67f))})),
    KELVIN(temperature -> Component.translatable((String)"tfc.tooltip.temperature_kelvin", (Object[])new Object[]{String.format("%.0f", Float.valueOf(temperature + 273.15f))}));

    private final Function formatter;

    private TemperatureDisplayStyle(Function formatter) {
        this.formatter = formatter;
    }

    @Nullable
    public MutableComponent format(float temperature) {
        return temperature > 0.0f ? this.formatter.format(temperature) : null;
    }

    @Nullable
    public MutableComponent formatColored(float temperature) {
        Heat heat = Heat.getHeat(temperature);
        if (heat != null) {
            MutableComponent tooltip = this.formatter.format(temperature);
            if (tooltip != null) {
                tooltip.withStyle(heat.getColor());
            }
            return tooltip;
        }
        return null;
    }

    @Nullable
    public MutableComponent formatRange(float temperature) {
        return this.formatter.format(temperature);
    }

    @FunctionalInterface
    static interface Function {
        @Nullable
        public MutableComponent format(float var1);
    }
}

