/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.dries007.tfc.common.component.CachedMut;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.dries007.tfc.world.biome.BiomeBridge;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.TFCBiomes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Biome.class})
public abstract class BiomeMixin
implements BiomeBridge {
    @Unique
    private final CachedMut<BiomeExtension> tfc$cachedExtension = CachedMut.unloaded();

    @Override
    @Nullable
    public BiomeExtension tfc$getExtension(@NotNull CommonLevelAccessor level) {
        if (!this.tfc$cachedExtension.isLoaded()) {
            this.tfc$cachedExtension.load(TFCBiomes.findExtension(level, (Biome)this));
        }
        return this.tfc$cachedExtension.value();
    }

    @OnlyIn(value=Dist.CLIENT)
    @ModifyReturnValue(method={"getPrecipitationAt"}, at={@At(value="RETURN")})
    private Biome.Precipitation getPrecipitaitionFromClimate(Biome.Precipitation original, @Local BlockPos pos) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return original;
        }
        return WeatherHelpers.getPrecipitationAt((Level)level, pos, original);
    }
}

