/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin {
    @Inject(method={"getEquipmentForSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private static void inject$getEquipmentForSlot(EquipmentSlot slot, int multiplier, CallbackInfoReturnable<Item> cir) {
        if (!TFCConfig.SERVER.enableVanillaMobsSpawningWithVanillaEquipment.get().booleanValue()) {
            TagKey<Item> tag = switch (slot) {
                case EquipmentSlot.FEET -> TFCTags.Items.MOB_FEET_ARMOR;
                case EquipmentSlot.LEGS -> TFCTags.Items.MOB_LEG_ARMOR;
                case EquipmentSlot.CHEST -> TFCTags.Items.MOB_CHEST_ARMOR;
                case EquipmentSlot.HEAD -> TFCTags.Items.MOB_HEAD_ARMOR;
                default -> null;
            };
            cir.setReturnValue(tag == null ? null : (Item)Helpers.randomItem(tag, RandomSource.create()).orElse(null));
        }
    }

    @Inject(method={"populateDefaultEquipmentEnchantments"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject$populateDefaultEquipmentEnchantments(ServerLevelAccessor level, RandomSource random, DifficultyInstance difficulty, CallbackInfo ci) {
        if (!TFCConfig.SERVER.enableVanillaMobsSpawningWithEnchantments.get().booleanValue()) {
            ci.cancel();
        }
    }
}

