/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.util.calendar.CalendarEventHandler;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Inject(method={"tickChunk"}, at={@At(value="TAIL")})
    private void onEnvironmentTick(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci) {
        WeatherHelpers.onTickChunk((ServerLevel)this, (ChunkAccess)chunk);
    }

    @Inject(method={"tickPrecipitation"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventVanillaSnowAndIce(BlockPos blockPos, CallbackInfo ci) {
        if (Climate.get((Level)((ServerLevel)this)).supportsRain()) {
            ci.cancel();
        }
    }

    @Inject(method={"advanceWeatherCycle"}, at={@At(value="HEAD")}, cancellable=true)
    private void doClimateBasedWeatherCycle(CallbackInfo ci) {
        if (WeatherHelpers.advanceWeatherCycle((ServerLevel)this)) {
            ci.cancel();
        }
    }

    @Inject(method={"wakeUpAllPlayers"}, at={@At(value="HEAD")})
    private void onWakeUpAllPlayers(CallbackInfo ci) {
        CalendarEventHandler.onPlayersFinishedSleeping((ServerLevel)this);
    }
}

