/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.common.entities.TFCEntities;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Tadpole.class})
public class TadpoleMixin {
    @Inject(method={"isFood"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject$spawnTadpoles(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"ageUp()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject$ageUp(CallbackInfo ci) {
        Tadpole pole = (Tadpole)this;
        Level level = pole.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Frog frog = (Frog)((EntityType)TFCEntities.FROG.get()).create((Level)server);
            if (frog != null) {
                frog.moveTo(pole.getX(), pole.getY(), pole.getZ(), pole.getYRot(), pole.getXRot());
                frog.finalizeSpawn((ServerLevelAccessor)server, server.getCurrentDifficultyAt(frog.blockPosition()), MobSpawnType.CONVERSION, null);
                frog.setNoAi(pole.isNoAi());
                if (pole.hasCustomName()) {
                    frog.setCustomName(pole.getCustomName());
                    frog.setCustomNameVisible(pole.isCustomNameVisible());
                }
                frog.setPersistenceRequired();
                pole.playSound(SoundEvents.TADPOLE_GROW_UP, 0.15f, 1.0f);
                server.addFreshEntityWithPassengers((Entity)frog);
                pole.discard();
                ci.cancel();
            }
        }
    }
}

