/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.PlacedItemBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.PacketHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public enum PlaceBlockSpecialPacket implements CustomPacketPayload
{
    PACKET;

    public static final CustomPacketPayload.Type<PlaceBlockSpecialPacket> TYPE;
    public static final StreamCodec<ByteBuf, PlaceBlockSpecialPacket> CODEC;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle(@Nullable ServerPlayer player) {
        if (player != null && TFCConfig.SERVER.enablePlacingItems.get().booleanValue() && player.mayBuild()) {
            BlockHitResult blockResult;
            Level level = player.level();
            HitResult rayTrace = player.pick(5.0, 1.0f, false);
            if (rayTrace instanceof BlockHitResult && (blockResult = (BlockHitResult)rayTrace).getDirection() == Direction.UP) {
                BlockState toPlace;
                BlockPos pos = blockResult.getBlockPos();
                BlockPos above = pos.above();
                ItemStack stack = player.getMainHandItem();
                @Nullable PlacedItemBlockEntity placedItem = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).or(() -> blockResult.getLocation().y() - (double)blockResult.getBlockPos().getY() < 0.5 ? level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.SHELF.get()) : Optional.empty()).orElse(null);
                if (placedItem != null) {
                    placedItem.onRightClick((Player)player, stack, blockResult);
                } else if (!stack.isEmpty() && level.isEmptyBlock(above) && PlacedItemBlock.isSlotSupported(toPlace = PlacedItemBlock.updateStateValues((LevelAccessor)level, pos, ((Block)TFCBlocks.PLACED_ITEM.get()).defaultBlockState()), blockResult)) {
                    level.setBlockAndUpdate(above, toPlace);
                    level.getBlockEntity(above, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).ifPresent(e -> e.insertItem((Player)player, stack, blockResult));
                }
            }
        }
    }

    static {
        TYPE = PacketHandler.type("place_block");
        CODEC = StreamCodec.unit((Object)((Object)PACKET));
    }
}

