/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.util.data.Drinkable;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public enum PlayerDrinkPacket implements CustomPacketPayload
{
    PACKET;

    public static final CustomPacketPayload.Type<PlayerDrinkPacket> TYPE;
    public static final StreamCodec<ByteBuf, PlayerDrinkPacket> CODEC;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle(@Nullable ServerPlayer player) {
        InteractionResult result;
        if (player != null && (result = Drinkable.attemptDrink(player.level(), (Player)player, true)).shouldSwing()) {
            player.swing(InteractionHand.MAIN_HAND);
        }
    }

    static {
        TYPE = PacketHandler.type("player_drink");
        CODEC = StreamCodec.unit((Object)((Object)PACKET));
    }
}

