/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.player.ChiselMode;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.network.PacketHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public record PlayerInfoPacket(long lastDrinkTick, float thirst, ChiselMode chiselMode, long intoxication, float[] nutrients) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerInfoPacket> TYPE = PacketHandler.type("player_info");
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerInfoPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.lastDrinkTick, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.thirst), (StreamCodec)ByteBufCodecs.registry(ChiselMode.KEY), c -> c.chiselMode, (StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.intoxication, FoodData.NUTRITION_STREAM_CODEC, c -> c.nutrients, PlayerInfoPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle() {
        Player player = ClientHelpers.getPlayer();
        if (player != null) {
            IPlayerInfo.get(player).onClientUpdate(this);
        }
    }
}

