/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.items.ProspectResult;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.util.events.ProspectedEvent;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public record ProspectedPacket(Block block, ProspectResult result) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ProspectedPacket> TYPE = PacketHandler.type("prospected");
    public static final StreamCodec<RegistryFriendlyByteBuf, ProspectedPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), c -> c.block, ProspectResult.STREAM, c -> c.result, ProspectedPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle() {
        Player player = ClientHelpers.getPlayer();
        if (player != null) {
            NeoForge.EVENT_BUS.post((Event)new ProspectedEvent(player, this.result, this.block));
            player.displayClientMessage(this.result.getText(this.block), TFCConfig.CLIENT.sendProspectResultsToActionbar.get().booleanValue());
        }
    }
}

