/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.network.PacketHandler;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record StackFoodPacket(int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StackFoodPacket> TYPE = PacketHandler.type("stack_food");
    public static final StreamCodec<ByteBuf, StackFoodPacket> CODEC = ByteBufCodecs.VAR_INT.map(StackFoodPacket::new, StackFoodPacket::index);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle(@Nullable ServerPlayer player) {
        block8: {
            InventoryMenu menu;
            block10: {
                block9: {
                    if (player == null) break block8;
                    AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                    if (!(abstractContainerMenu instanceof InventoryMenu)) break block9;
                    menu = (InventoryMenu)abstractContainerMenu;
                    if (this.index >= 0 && this.index < menu.slots.size()) break block10;
                }
                return;
            }
            Slot targetSlot = menu.getSlot(this.index);
            if (targetSlot instanceof ResultSlot) {
                return;
            }
            ItemStack targetStack = targetSlot.getItem();
            @Nullable IFood targetCap = FoodCapability.get(targetStack);
            if (targetCap == null || targetStack.getMaxStackSize() == targetStack.getCount() || targetCap.isRotten()) {
                return;
            }
            List<Slot> stackableSlots = this.getStackableSlots(targetSlot, (List<Slot>)menu.slots);
            int currentAmount = targetStack.getCount();
            int remaining = targetStack.getMaxStackSize() - currentAmount;
            long minCreationDate = targetCap.getCreationDate();
            Iterator<Slot> slotIterator = stackableSlots.iterator();
            while (remaining > 0 && slotIterator.hasNext()) {
                Slot slot = slotIterator.next();
                ItemStack stack = slot.getItem();
                @Nullable IFood cap = FoodCapability.get(stack);
                if (cap == null || cap.isRotten()) continue;
                if (cap.getCreationDate() < minCreationDate) {
                    minCreationDate = cap.getCreationDate();
                }
                if (remaining < stack.getCount()) {
                    currentAmount += remaining;
                    stack.shrink(remaining);
                    remaining = 0;
                    continue;
                }
                currentAmount += stack.getCount();
                remaining -= stack.getCount();
                stack.shrink(stack.getCount());
            }
            targetStack.setCount(currentAmount);
            FoodCapability.setCreationDate(targetStack, minCreationDate);
            menu.slotsChanged((Container)menu.getCraftSlots());
        }
    }

    private List<Slot> getStackableSlots(Slot targetSlot, List<Slot> inventorySlots) {
        ArrayList<Slot> stackableSlots = new ArrayList<Slot>();
        for (Slot slot2 : inventorySlots) {
            if (slot2.getSlotIndex() == targetSlot.getSlotIndex() || slot2 instanceof ResultSlot) continue;
            ItemStack stack = slot2.getItem();
            if (!FoodCapability.areStacksStackableExceptCreationDate(targetSlot.getItem(), stack)) continue;
            stackableSlots.add(slot2);
        }
        stackableSlots.sort(Comparator.comparingInt(slot -> slot.getItem().getCount()));
        return stackableSlots;
    }
}

