/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.network.PacketHandler;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public record SwitchInventoryTabPacket(Tab tab) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SwitchInventoryTabPacket> TYPE = PacketHandler.type("switch_inventory_tab");
    public static final StreamCodec<ByteBuf, SwitchInventoryTabPacket> CODEC = Tab.STREAM.map(SwitchInventoryTabPacket::new, c -> c.tab);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle(@Nullable ServerPlayer player) {
        if (player != null) {
            player.doCloseContainer();
            switch (this.tab.ordinal()) {
                case 0: {
                    player.containerMenu = player.inventoryMenu;
                    break;
                }
                case 1: {
                    player.openMenu(TFCContainerProviders.CALENDAR);
                    break;
                }
                case 2: {
                    player.openMenu(TFCContainerProviders.NUTRITION);
                    break;
                }
                case 3: {
                    player.openMenu(TFCContainerProviders.CLIMATE);
                    break;
                }
                case 4: {
                    PatchouliIntegration.openGui(player);
                }
            }
        }
    }

    public static enum Tab {
        INVENTORY,
        CALENDAR,
        NUTRITION,
        CLIMATE,
        BOOK;

        public static final Tab[] VALUES;
        public static final StreamCodec<ByteBuf, Tab> STREAM;

        static {
            VALUES = Tab.values();
            STREAM = ByteBufCodecs.BYTE.map(c -> VALUES[c], c -> (byte)c.ordinal());
        }
    }
}

