/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.climate.ClimateModelType;
import net.dries007.tfc.util.climate.ClimateModels;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record UpdateClimateModelPacket(ClimateModel model) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateClimateModelPacket> TYPE = PacketHandler.type("update_climate_model");
    public static final StreamCodec<ByteBuf, UpdateClimateModelPacket> CODEC = ResourceLocation.STREAM_CODEC.dispatch(c -> ClimateModels.REGISTRY.getKey(c.type()), id -> ((ClimateModelType)((Object)ClimateModels.REGISTRY.getOptional(id).orElseGet(ClimateModels.BIOME_BASED))).codec()).map(UpdateClimateModelPacket::new, c -> c.model);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle() {
        Level level = ClientHelpers.getLevel();
        if (level != null) {
            WorldTracker.get(level).setClimateModel(this.model);
        }
    }
}

