/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.wood.BranchDirection;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public class AxeLoggingHelper {
    private static final EnumProperty<BranchDirection> BRANCH_DIRECTION = TFCBlockStateProperties.BRANCH_DIRECTION;

    public static boolean shouldLog(LevelAccessor level, BlockPos pos, BlockState state, ItemStack stack) {
        return AxeLoggingHelper.isLoggingAxe(stack) && AxeLoggingHelper.isLoggingBlock(state) && !AxeLoggingHelper.isPartOfLargerTrunk(level, pos, state);
    }

    public static void doLogging(LevelAccessor level, BlockPos pos, Player player, ItemStack axe) {
        boolean inefficient = AxeLoggingHelper.isInefficientAxe(axe);
        for (BlockPos log : AxeLoggingHelper.findLogs(level, pos)) {
            level.destroyBlock(log, !inefficient || level.getRandom().nextFloat() < 0.6f, (Entity)player);
            Helpers.damageItem(axe, (LivingEntity)player, InteractionHand.MAIN_HAND);
            if (!axe.isEmpty()) continue;
            return;
        }
    }

    public static List<BlockPos> findLogs(LevelAccessor level, BlockPos pos) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>(64);
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>(16);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        logs.add(pos);
        for (int i = 0; i < logs.size(); ++i) {
            BlockPos log = (BlockPos)logs.get(i);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        cursor.setWithOffset((Vec3i)log, dx, dy, dz);
                        if (seen.contains(cursor)) continue;
                        BlockPos cursorPos = cursor.immutable();
                        BlockState cursorState = level.getBlockState(cursorPos);
                        if (AxeLoggingHelper.isLoggingBlock(cursorState)) {
                            if (!AxeLoggingHelper.isConnected(log, cursorPos, cursorState)) continue;
                            logs.add(cursorPos);
                            seen.add(cursorPos);
                            continue;
                        }
                        seen.add(cursorPos);
                    }
                }
            }
        }
        Collections.reverse(logs);
        return logs;
    }

    public static boolean isLoggingAxe(ItemStack stack) {
        return Helpers.isItem(stack, (TagKey<Item>)ItemTags.AXES);
    }

    public static boolean isInefficientAxe(ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.INEFFICIENT_LOGGING_AXES);
    }

    public static boolean isLoggingBlock(BlockState state) {
        return Helpers.isBlock(state.getBlock(), TFCTags.Blocks.LOGS_THAT_LOG) && state.hasProperty(BRANCH_DIRECTION) && ((BranchDirection)((Object)state.getValue(BRANCH_DIRECTION))).natural();
    }

    public static boolean isLoggingTrunk(BlockState state) {
        return AxeLoggingHelper.isLoggingBlock(state) && ((BranchDirection)((Object)state.getValue(BRANCH_DIRECTION))).trunk();
    }

    public static boolean isPartOfLargerTrunk(LevelAccessor level, BlockPos pos, BlockState state) {
        return switch ((BranchDirection)((Object)state.getValue(BRANCH_DIRECTION))) {
            case BranchDirection.TRUNK_NORTH_EAST -> AxeLoggingHelper.isPartOfLargerTrunk(level, pos, Direction.NORTH, Direction.EAST);
            case BranchDirection.TRUNK_NORTH_WEST -> AxeLoggingHelper.isPartOfLargerTrunk(level, pos, Direction.NORTH, Direction.WEST);
            case BranchDirection.TRUNK_SOUTH_EAST -> AxeLoggingHelper.isPartOfLargerTrunk(level, pos, Direction.SOUTH, Direction.EAST);
            case BranchDirection.TRUNK_SOUTH_WEST -> AxeLoggingHelper.isPartOfLargerTrunk(level, pos, Direction.SOUTH, Direction.WEST);
            default -> false;
        };
    }

    private static boolean isPartOfLargerTrunk(LevelAccessor level, BlockPos pos, Direction first, Direction second) {
        return AxeLoggingHelper.isLoggingTrunk(level.getBlockState(pos.relative(first))) || AxeLoggingHelper.isLoggingTrunk(level.getBlockState(pos.relative(second)));
    }

    private static boolean isConnected(BlockPos rootPos, BlockPos branchPos, BlockState branchState) {
        if (branchState.hasProperty(BRANCH_DIRECTION)) {
            BranchDirection branch = (BranchDirection)((Object)branchState.getValue(BRANCH_DIRECTION));
            return branch.connected(rootPos, branchPos);
        }
        return false;
    }
}

