/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.dries007.tfc.common.component.food.FoodTrait;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.AdvancedShapedRecipe;
import net.dries007.tfc.common.recipes.AdvancedShapelessRecipe;
import net.dries007.tfc.common.recipes.outputs.AddBaitToRodModifier;
import net.dries007.tfc.common.recipes.outputs.AddGlassModifier;
import net.dries007.tfc.common.recipes.outputs.AddPowderModifier;
import net.dries007.tfc.common.recipes.outputs.AddTraitModifier;
import net.dries007.tfc.common.recipes.outputs.CopyFoodModifier;
import net.dries007.tfc.common.recipes.outputs.CopyForgingBonusModifier;
import net.dries007.tfc.common.recipes.outputs.CopyInputModifier;
import net.dries007.tfc.common.recipes.outputs.CopyOldestFoodModifier;
import net.dries007.tfc.common.recipes.outputs.DamageCraftingRemainderModifier;
import net.dries007.tfc.common.recipes.outputs.ExtraProductModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public interface DataGenerationHelpers {

    public static class Builder {
        final BiConsumer<String, Recipe<?>> onFinish;
        @Nullable
        String name = null;
        final List<ItemStackModifier> remainder = new ArrayList<ItemStackModifier>();
        final List<ItemStackModifier> outputs = new ArrayList<ItemStackModifier>();
        final NonNullList<Ingredient> ingredients = NonNullList.create();
        final List<String> pattern = new ArrayList<String>();
        final ImmutableMap.Builder<Character, Ingredient> keys = ImmutableMap.builder();
        int inputRow = 0;
        int inputCol = 0;
        @Nullable
        Ingredient primaryInput = null;
        boolean needsAdvInput = false;
        boolean hasAdvInputShaped = false;
        boolean hasAdvInputShapeless = false;

        public Builder(BiConsumer<String, Recipe<?>> onFinish) {
            this.onFinish = onFinish;
        }

        public void useTool(TagKey<Item> tool, ItemLike input, ItemLike output) {
            this.input(input).inputIsPrimary(tool).damageInputs().shapeless(output);
        }

        public void useTool(TagKey<Item> tool, Ingredient input, ItemLike output, int count) {
            this.input(input).inputIsPrimary(tool).damageInputs().shapeless(output, count);
        }

        public void bricksWithMortar(ItemLike brick, ItemLike bricks, int count) {
            this.input('Y', TFCItems.MORTAR).input('X', brick).pattern("XYX", "YXY", "XYX").shaped(bricks, count);
        }

        public void to3x3(Ingredient input, ItemLike storage) {
            this.input('X', input).pattern("XXX", "XXX", "XXX").shaped(storage);
        }

        public void from3x3(Ingredient input, ItemLike item) {
            this.input(input).shapeless(item, 9);
        }

        public void to2x2(ItemLike input, ItemLike output, int count) {
            this.input('X', input).pattern("XX", "XX").shaped(output, count);
        }

        public Builder damageInputs() {
            this.remainder.add(DamageCraftingRemainderModifier.INSTANCE);
            return this;
        }

        public Builder copyOldestFood() {
            this.outputs.add(CopyOldestFoodModifier.INSTANCE);
            return this;
        }

        public Builder copyFood() {
            this.outputs.add(CopyFoodModifier.INSTANCE);
            return this;
        }

        public Builder copyForging() {
            this.needsAdvInput = true;
            return this.addOutputModifier(CopyForgingBonusModifier.INSTANCE);
        }

        public Builder copyInput() {
            this.needsAdvInput = true;
            return this.addOutputModifier(CopyInputModifier.INSTANCE);
        }

        public Builder addGlass() {
            this.needsAdvInput = true;
            return this.addOutputModifier(AddGlassModifier.INSTANCE);
        }

        public Builder addPowder() {
            return this.addOutputModifier(AddPowderModifier.INSTANCE);
        }

        public Builder addBait() {
            return this.addOutputModifier(AddBaitToRodModifier.INSTANCE);
        }

        public Builder extraProduct(ItemLike item) {
            return this.extraProduct(item, 1);
        }

        public Builder extraProduct(ItemLike item, int count) {
            this.remainder.add(new ExtraProductModifier(new ItemStack(item, count)));
            return this;
        }

        public Builder addTrait(Holder<FoodTrait> trait) {
            return this.addOutputModifier(AddTraitModifier.of(trait));
        }

        public Builder addOutputModifier(ItemStackModifier modifier) {
            this.outputs.add(modifier);
            return this;
        }

        public Builder input(ItemLike item) {
            return this.input(item, 1);
        }

        public Builder input(ItemLike item, int count) {
            return this.input(Ingredient.of((ItemLike[])new ItemLike[]{item}), count);
        }

        public Builder input(TagKey<Item> item) {
            return this.input(item, 1);
        }

        public Builder input(TagKey<Item> item, int count) {
            return this.input(Ingredient.of(item), count);
        }

        public Builder input(Ingredient item) {
            return this.input(item, 1);
        }

        public Builder input(Ingredient item, int count) {
            for (int n = 0; n < count; ++n) {
                this.ingredients.add((Object)item);
            }
            return this;
        }

        public Builder inputIsPrimary(ItemLike item) {
            return this.inputIsPrimary(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }

        public Builder inputIsPrimary(TagKey<Item> item) {
            return this.inputIsPrimary(Ingredient.of(item));
        }

        public Builder inputIsPrimary(Ingredient item) {
            this.primaryInput = item;
            this.hasAdvInputShapeless = true;
            return this.input(item);
        }

        public Builder input(char key, TagKey<Item> input) {
            return this.input(key, Ingredient.of(input));
        }

        public Builder input(char key, ItemLike input) {
            return this.input(key, Ingredient.of((ItemLike[])new ItemLike[]{input}));
        }

        public Builder input(char key, Ingredient input) {
            this.keys.put((Object)Character.valueOf(key), (Object)input);
            return this;
        }

        public Builder source(int row, int col) {
            this.inputRow = row;
            this.inputCol = col;
            this.hasAdvInputShaped = true;
            return this;
        }

        public Builder pattern(String ... pattern) {
            this.pattern.addAll(List.of(pattern));
            return this;
        }

        public void shapeless(String name) {
            this.name = name;
            this.shapeless(ItemStack.EMPTY);
        }

        public void shapeless(ItemLike output) {
            this.shapeless(output, 1);
        }

        public void shapeless(ItemLike output, int count) {
            this.shapeless(new ItemStack(output, count));
        }

        public void shapeless(ItemStack output) {
            assert (this.pattern.isEmpty() && this.keys.build().isEmpty()) : "Mixing shaped and shapeless recipes";
            assert (this.hasAdvInputShapeless || !this.needsAdvInput) : "Missing a .inputIsPrimary(Ingredient) for a recipe which depends on input";
            assert (!this.outputs.isEmpty() || !output.isEmpty()) : "Either non-empty output, or output modifiers must be present";
            this.onFinish.accept(this.name, (Recipe<?>)(this.isAdvanced() ? new AdvancedShapelessRecipe(this.ingredients, ItemStackProvider.of(output, this.outputs), this.remainder(), Optional.ofNullable(this.primaryInput)) : new ShapelessRecipe("", CraftingBookCategory.MISC, output, this.ingredients)));
        }

        public void shaped(String name) {
            this.name = name;
            this.shaped(ItemStack.EMPTY);
        }

        public void shaped(ItemLike output) {
            this.shaped(output, 1);
        }

        public void shaped(ItemLike output, int count) {
            this.shaped(new ItemStack(output, count));
        }

        public void shaped(ItemStack output) {
            assert (this.ingredients.isEmpty()) : "Mixing shaped and shapeless recipes";
            assert (this.hasAdvInputShaped || !this.needsAdvInput) : "Missing a .source(int, int) for a recipe which depends on input";
            assert (!this.outputs.isEmpty() || !output.isEmpty()) : "Either non-empty output, or output modifiers must be present";
            ShapedRecipePattern pattern = ShapedRecipePattern.of((Map)this.keys.build(), this.pattern);
            this.onFinish.accept(this.name, (Recipe<?>)(this.isAdvanced() ? new AdvancedShapedRecipe(pattern, true, ItemStackProvider.of(output, this.outputs), this.remainder(), this.inputRow, this.inputCol) : new ShapedRecipe("", CraftingBookCategory.MISC, pattern, output)));
        }

        private Optional<ItemStackProvider> remainder() {
            return this.remainder.isEmpty() ? Optional.empty() : Optional.of(ItemStackProvider.of(ItemStack.EMPTY, this.remainder));
        }

        private boolean isAdvanced() {
            return !this.remainder.isEmpty() || !this.outputs.isEmpty();
        }
    }
}

