/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.machinezoo.noexception.throwing.ThrowingRunnable;
import com.machinezoo.noexception.throwing.ThrowingSupplier;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blocks.ISlowEntities;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.size.IItemSize;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.component.size.Size;
import net.dries007.tfc.common.component.size.Weight;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.entities.ai.prey.PestAi;
import net.dries007.tfc.common.entities.prey.Pest;
import net.dries007.tfc.mixin.accessor.RecipeManagerAccessor;
import net.dries007.tfc.util.SelfTests;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.FluidHeat;
import net.dries007.tfc.util.data.Support;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class Helpers {
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final DyeColor[] DYE_COLORS = DyeColor.values();
    public static final DyeColor[] DYE_COLORS_NOT_WHITE = (DyeColor[])Arrays.stream(DYE_COLORS).filter(e -> e != DyeColor.WHITE).toArray(DyeColor[]::new);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int PRIME_X = 501125321;
    private static final int PRIME_Y = 1136930381;
    @Nullable
    private static RecipeManager CACHED_RECIPE_MANAGER = null;

    public static ResourceLocation identifier(String name) {
        return Helpers.resourceLocation("tfc", name);
    }

    public static ResourceLocation identifierMC(String name) {
        return Helpers.resourceLocation("minecraft", name);
    }

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.parse((String)name);
    }

    public static ResourceLocation resourceLocation(String domain, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)domain, (String)path);
    }

    public static Vec3 getRandomSpeedRanges(RandomSource random) {
        return new Vec3(Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5), Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5), Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5));
    }

    @Nullable
    public static <T, C> T getCapability(BlockCapability<T, @Nullable C> capability, Level level, BlockPos pos) {
        return (T)level.getCapability(capability, pos, null);
    }

    @Nullable
    public static <T, C> T getCapability(BlockCapability<T, C> capability, BlockEntity entity) {
        return Helpers.getCapability(capability, entity, null);
    }

    @Nullable
    public static <T, C> T getCapability(BlockCapability<T, @Nullable C> capability, BlockEntity entity, @Nullable C context) {
        return (T)entity.getLevel().getCapability(capability, entity.getBlockPos(), entity.getBlockState(), entity, context);
    }

    public static <T> boolean mightHaveCapability(ItemStack stack, ItemCapability<T, Void> capability) {
        return stack.copyWithCount(1).getCapability(capability) != null;
    }

    public static <E extends Enum<E>, V> Map<E, V> mapOf(Class<E> enumClass, Function<E, V> valueMapper) {
        return Helpers.mapOf(enumClass, key -> true, valueMapper);
    }

    public static <E extends Enum<E>, V> Map<E, V> mapOf(Class<E> enumClass, Predicate<E> keyPredicate, Function<E, V> valueMapper) {
        return Arrays.stream((Enum[])enumClass.getEnumConstants()).filter(keyPredicate).collect(Collectors.toMap(Function.identity(), valueMapper, (v, v2) -> Helpers.throwAsUnchecked((Throwable)((Object)new AssertionError((Object)"Merging elements not allowed!"))), () -> new EnumMap(enumClass)));
    }

    public static <K, V1, V2> Map<K, V2> mapValue(Map<K, V1> map, Function<V1, V2> func) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)map.size());
        for (Map.Entry<K, V1> entry : map.entrySet()) {
            builder.put(entry.getKey(), func.apply(entry.getValue()));
        }
        return builder.build();
    }

    public static <K, V> V getRandomValue(Map<K, V> map, RandomSource random) {
        return (V)Iterators.get(map.values().iterator(), (int)random.nextInt(map.size()));
    }

    public static MutableComponent translateEnum(Enum<?> anEnum) {
        return Component.translatable((String)Helpers.getEnumTranslationKey(anEnum));
    }

    public static MutableComponent translateEnum(Enum<?> anEnum, String enumName) {
        return Component.translatable((String)Helpers.getEnumTranslationKey(anEnum, enumName));
    }

    public static String getEnumTranslationKey(Enum<?> anEnum) {
        return Helpers.getEnumTranslationKey(anEnum, anEnum.getDeclaringClass().getSimpleName());
    }

    public static String getEnumTranslationKey(Enum<?> anEnum, String enumName) {
        return String.join((CharSequence)".", "tfc", "enum", enumName, anEnum.name()).toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static Level getUnsafeLevel(Object maybeLevel) {
        if (maybeLevel instanceof Level) {
            Level level = (Level)maybeLevel;
            return level;
        }
        if (maybeLevel instanceof WorldGenRegion) {
            WorldGenRegion level = (WorldGenRegion)maybeLevel;
            return level.getLevel();
        }
        return null;
    }

    public static void slowEntityInsideBlocks(Entity entity) {
        Level level = entity.level();
        AABB box = entity.getBoundingBox();
        BlockPos minPos = BlockPos.containing((double)(box.minX + 1.0E-7), (double)(box.minY + 1.0E-7), (double)(box.minZ + 1.0E-7));
        BlockPos maxPos = BlockPos.containing((double)(box.maxX - 1.0E-7), (double)(box.maxY - 1.0E-7), (double)(box.maxZ - 1.0E-7));
        float factor = 1.0f;
        if (level.hasChunksAt(minPos, maxPos)) {
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            for (int x = minPos.getX(); x <= maxPos.getX(); ++x) {
                for (int y = minPos.getY(); y <= maxPos.getY(); ++y) {
                    for (int z = minPos.getZ(); z <= maxPos.getZ(); ++z) {
                        cursor.set(x, y, z);
                        BlockState state = level.getBlockState((BlockPos)cursor);
                        Block block = state.getBlock();
                        if (!(block instanceof ISlowEntities)) continue;
                        ISlowEntities slow = (ISlowEntities)block;
                        factor = Math.min(factor, slow.slowEntityFactor(state));
                    }
                }
            }
        }
        if (factor < 1.0f) {
            Helpers.slowEntityInBlock(entity, factor);
        }
    }

    private static void slowEntityInBlock(Entity entity, float factor) {
        float fallDamageReduction = 5.0f;
        Vec3 motion = entity.getDeltaMovement();
        entity.setDeltaMovement(motion.multiply((double)factor, motion.y < 0.0 ? (double)(1.0f - 0.2f * (1.0f - factor)) : 1.0, (double)factor));
        if (entity.fallDistance > 5.0f) {
            entity.causeFallDamage(entity.fallDistance - 5.0f, 1.0f, entity.damageSources().fall());
        }
        entity.fallDistance = 0.0f;
    }

    public static boolean hasMoved(Entity entity) {
        return entity.xOld != entity.getX() && entity.zOld != entity.getZ();
    }

    public static void rotateEntity(Level level, Entity entity, Vec3 origin, float speed) {
        if (!entity.onGround() || entity.getDeltaMovement().y > 0.0 || speed == 0.0f) {
            return;
        }
        float rot = (entity.getYHeadRot() + speed) % 360.0f;
        entity.setYRot(rot);
        if (level.isClientSide && entity instanceof Player) {
            Vec3 offset = entity.position().subtract(origin).normalize();
            Vec3 movement = new Vec3(-offset.z, 0.0, offset.x).scale((double)(speed / 48.0f));
            entity.setDeltaMovement(entity.getDeltaMovement().add(movement));
            entity.hurtMarked = true;
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity.setYHeadRot(rot);
            entity.setYBodyRot(rot);
            entity.setOnGround(false);
            living.setNoActionTime(20);
            living.hurtMarked = true;
        }
    }

    public static BlockState copyProperties(BlockState copyTo, BlockState copyFrom) {
        for (Property property : copyFrom.getProperties()) {
            copyTo = Helpers.copyProperty(copyTo, copyFrom, property);
        }
        return copyTo;
    }

    public static <T extends Comparable<T>> BlockState copyProperty(BlockState copyTo, BlockState copyFrom, Property<T> property) {
        return copyTo.hasProperty(property) ? (BlockState)copyTo.setValue(property, copyFrom.getValue(property)) : copyTo;
    }

    public static <T extends Comparable<T>> BlockState setProperty(BlockState state, Property<T> property, T value) {
        return state.hasProperty(property) ? (BlockState)state.setValue(property, value) : state;
    }

    public static RecipeManager getUnsafeRecipeManager() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.getRecipeManager();
        }
        try {
            RecipeManager client = ClientHelpers.tryGetSafeRecipeManager();
            if (client != null) {
                return client;
            }
        }
        catch (Throwable t) {
            LOGGER.info("^ This is fine - No client or server recipe manager present upon initial resource reload on physical server");
        }
        if (CACHED_RECIPE_MANAGER != null) {
            return CACHED_RECIPE_MANAGER;
        }
        throw new IllegalStateException("No recipe manager was present - tried server, client, and captured value. This will cause problems!");
    }

    public static void setCachedRecipeManager(RecipeManager manager) {
        CACHED_RECIPE_MANAGER = manager;
    }

    public static void updateReloadableData(RegistryAccess access, RecipeManager manager) {
        IndirectHashCollection.reloadAllCaches(manager);
        Support.updateMaximumSupportRange();
        FluidHeat.updateCache();
        TFCComponents.onModifyDefaultComponentsAfterResourceReload();
        FoodCapability.markRecipeOutputsAsNonDecaying(access, manager);
        SelfTests.runDataPackTests(manager);
        RecipeManagerAccessor accessor = (RecipeManagerAccessor)manager;
        for (RecipeType type : BuiltInRegistries.RECIPE_TYPE) {
            LOGGER.debug("Loaded {} recipes of type {}", (Object)accessor.invoke$byType(type).size(), (Object)BuiltInRegistries.RECIPE_TYPE.getKey((Object)type));
        }
    }

    public static void damageItem(ItemStack stack, LivingEntity entity, EquipmentSlot slot) {
        stack.hurtAndBreak(1, entity, slot);
    }

    public static void damageItem(ItemStack stack, int amount, LivingEntity entity, InteractionHand hand) {
        stack.hurtAndBreak(amount, entity, LivingEntity.getSlotForHand((InteractionHand)hand));
    }

    public static void damageItem(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        stack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)hand));
    }

    public static void damageItem(ItemStack stack, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            stack.hurtAndBreak(1, serverLevel, null, item -> {});
        }
    }

    @Deprecated
    public static ItemStack damageItem(ItemStack stack) {
        if (stack.isDamageableItem()) {
            int amount = stack.getItem().damageItem(stack, 1, null, (T item) -> {});
            int damage = stack.getDamageValue() + amount;
            stack.setDamageValue(damage);
            if (damage >= stack.getMaxDamage()) {
                stack.shrink(1);
            }
        }
        return stack;
    }

    public static void removeBlock(LevelAccessor level, BlockPos pos, int flags) {
        level.setBlock(pos, level.getFluidState(pos).createLegacyBlock(), flags);
    }

    public static void tickInfestation(Level level, BlockPos pos, int infestation, @Nullable Player player) {
        if ((infestation = Mth.clamp((int)infestation, (int)0, (int)5)) == 0) {
            return;
        }
        if (level.random.nextInt(120 - 20 * infestation) == 0) {
            float chanceBasedOnCurrentPests = 1.0f - Mth.clampedMap((float)level.getEntitiesOfClass(Pest.class, new AABB(pos).inflate(40.0)).size(), (float)0.0f, (float)8.0f, (float)0.0f, (float)1.0f);
            if (level.random.nextFloat() > chanceBasedOnCurrentPests) {
                return;
            }
            Helpers.choosePest(level, pos).ifPresent(type -> {
                Entity entity = type.create(level);
                if (entity instanceof PathfinderMob) {
                    PathfinderMob mob = (PathfinderMob)entity;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        mob.moveTo(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
                        Vec3 checkPos = LandRandomPos.getPos((PathfinderMob)mob, (int)15, (int)5);
                        if (checkPos != null) {
                            mob.moveTo(checkPos);
                            EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.getCurrentDifficultyAt(BlockPos.containing((Position)checkPos)), (MobSpawnType)MobSpawnType.EVENT, null);
                            serverLevel.addFreshEntity((Entity)mob);
                            if (mob instanceof Pest) {
                                Pest pest = (Pest)mob;
                                PestAi.setSmelledPos(pest, pos);
                            }
                            if (player != null) {
                                player.displayClientMessage((Component)Component.translatable((String)"tfc.tooltip.infestation"), true);
                            }
                        }
                    }
                }
            });
        }
    }

    public static Optional<EntityType<?>> choosePest(Level level, BlockPos pos) {
        ChunkData data = ChunkData.get((LevelReader)level, pos);
        float temperature = data.getAverageSeaLevelTemp(pos);
        if (temperature <= -12.0f) {
            return Optional.empty();
        }
        if (temperature < -3.0f) {
            return Helpers.randomEntity(TFCTags.Entities.COLD_PESTS, level.random);
        }
        if ((double)level.random.nextFloat() <= 0.7) {
            float rainfall = data.getRainfall(pos);
            if (rainfall < 160.0f) {
                return Helpers.randomEntity(TFCTags.Entities.DESERT_PESTS, level.random);
            }
            if (temperature > 12.0f) {
                return Helpers.randomEntity(TFCTags.Entities.TROPICAL_PESTS, level.random);
            }
        }
        return Helpers.randomEntity(TFCTags.Entities.UNIVERSAL_PESTS, level.random);
    }

    public static CarryCount getCarryCount(Container container) {
        IItemSize size;
        ItemStack stack;
        int count = 0;
        for (int i = 0; i < container.getContainerSize() && ((stack = container.getItem(i)).isEmpty() || (size = ItemSizeManager.get(stack)).getWeight(stack) != Weight.VERY_HEAVY || size.getSize(stack) != Size.HUGE || ++count != 2); ++i) {
        }
        return switch (count) {
            case 0 -> CarryCount.NONE;
            case 1 -> CarryCount.ONE;
            default -> CarryCount.MORE_THAN_ONE;
        };
    }

    public static MobEffectInstance getOverburdened(boolean visible) {
        return new MobEffectInstance(TFCEffects.OVERBURDENED.holder(), 25, 0, false, visible);
    }

    public static MobEffectInstance getExhausted(boolean visible) {
        return new MobEffectInstance(TFCEffects.EXHAUSTED.holder(), 25, 0, false, visible);
    }

    public static Iterable<ItemStack> iterate(IItemHandler inventory) {
        return Helpers.iterate(inventory, 0, inventory.getSlots());
    }

    public static Iterable<ItemStack> iterate(final RecipeInput inventory) {
        return () -> new Iterator<ItemStack>(){
            private int slot = 0;

            @Override
            public boolean hasNext() {
                return this.slot < inventory.size();
            }

            @Override
            public ItemStack next() {
                return inventory.getItem(this.slot++);
            }
        };
    }

    public static Iterable<ItemStack> iterate(final IItemHandler inventory, final int startSlotInclusive, final int endSlotExclusive) {
        return () -> new Iterator<ItemStack>(){
            private int slot;
            {
                this.slot = startSlotInclusive;
            }

            @Override
            public boolean hasNext() {
                return this.slot < endSlotExclusive;
            }

            @Override
            public ItemStack next() {
                return inventory.getStackInSlot(this.slot++);
            }

            @Override
            public void remove() {
                Helpers.removeStack(inventory, this.slot - 1);
            }
        };
    }

    public static ListTag writeItemStacksToNbt(HolderLookup.Provider provider, List<ItemStack> stacks) {
        ListTag list = new ListTag();
        for (ItemStack stack : stacks) {
            list.add((Object)stack.saveOptional(provider));
        }
        return list;
    }

    public static void readItemStacksFromNbt(HolderLookup.Provider provider, List<ItemStack> stacks, ListTag list) {
        stacks.clear();
        for (int i = 0; i < list.size(); ++i) {
            stacks.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)list.getCompound(i)));
        }
    }

    public static void readFixedSizeItemStacksFromNbt(HolderLookup.Provider provider, List<ItemStack> stacks, ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            stacks.set(i, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)list.getCompound(i)));
        }
    }

    public static void consumeInStackSizeIncrements(ItemStack stack, int totalCount, Consumer<ItemStack> consumer) {
        while (totalCount > 0) {
            ItemStack splitStack = stack.copy();
            int splitCount = Math.min(splitStack.getMaxStackSize(), totalCount);
            splitStack.setCount(splitCount);
            totalCount -= splitCount;
            consumer.accept(splitStack);
        }
    }

    public static void gatherAndConsumeItems(Level level, AABB bounds, IItemHandler inventory, int minSlotInclusive, int maxSlotInclusive) {
        Helpers.gatherAndConsumeItems(level.getEntitiesOfClass(ItemEntity.class, bounds, EntitySelector.ENTITY_STILL_ALIVE), inventory, minSlotInclusive, maxSlotInclusive, Integer.MAX_VALUE);
    }

    public static void gatherAndConsumeItems(Level level, AABB bounds, IItemHandler inventory, int minSlotInclusive, int maxSlotInclusive, int maxItemsOverride) {
        Helpers.gatherAndConsumeItems(level.getEntitiesOfClass(ItemEntity.class, bounds, EntitySelector.ENTITY_STILL_ALIVE), inventory, minSlotInclusive, maxSlotInclusive, maxItemsOverride);
    }

    public static void gatherAndConsumeItems(Collection<ItemEntity> items, IItemHandler inventory, int minSlotInclusive, int maxSlotInclusive, int maxItemsOverride) {
        ArrayList<ItemEntity> availableItemEntities = new ArrayList<ItemEntity>();
        int availableItems = 0;
        for (ItemEntity entity : items) {
            if (!inventory.isItemValid(maxSlotInclusive, entity.getItem())) continue;
            availableItems += entity.getItem().getCount();
            availableItemEntities.add(entity);
        }
        if (availableItems > maxItemsOverride) {
            availableItems = maxItemsOverride;
        }
        Helpers.safelyConsumeItemsFromEntitiesIndividually(availableItemEntities, availableItems, item -> Helpers.insertSlots(inventory, item, minSlotInclusive, 1 + maxSlotInclusive).isEmpty());
    }

    public static void consumeItemsFromEntitiesIndividually(Collection<ItemEntity> entities, int maximum, Consumer<ItemStack> consumer) {
        int consumed = 0;
        for (ItemEntity entity : entities) {
            ItemStack stack = entity.getItem();
            while (consumed < maximum && !stack.isEmpty()) {
                consumer.accept(stack.split(1));
                ++consumed;
                if (!stack.isEmpty()) continue;
                entity.discard();
            }
        }
    }

    public static void alternatingConsumeItemsFromEntitiesIndividually(Collection<ItemEntity> set1, Collection<ItemEntity> set2, int maximum, Consumer<ItemStack> consumer) {
        ItemEntity fromSet2;
        int consumed = 0;
        Iterator<ItemEntity> iter1 = set1.iterator();
        Iterator<ItemEntity> iter2 = set2.iterator();
        ItemEntity fromSet1 = iter1.hasNext() ? iter1.next() : null;
        ItemEntity itemEntity = fromSet2 = iter2.hasNext() ? iter2.next() : null;
        while (consumed < maximum && (fromSet1 != null || fromSet2 != null)) {
            if (fromSet1 != null) {
                consumer.accept(fromSet1.getItem().split(1));
                ++consumed;
                if (fromSet1.getItem().isEmpty()) {
                    fromSet1.discard();
                    ItemEntity itemEntity2 = fromSet1 = iter1.hasNext() ? iter1.next() : null;
                }
                if (consumed == maximum) break;
            }
            if (fromSet2 == null) continue;
            consumer.accept(fromSet2.getItem().split(1));
            ++consumed;
            if (!fromSet2.getItem().isEmpty()) continue;
            fromSet2.discard();
            fromSet2 = iter2.hasNext() ? iter2.next() : null;
        }
    }

    public static void safelyConsumeItemsFromEntitiesIndividually(Collection<ItemEntity> entities, int maximum, Predicate<ItemStack> consumer) {
        int consumed = 0;
        for (ItemEntity entity : entities) {
            ItemStack stack = entity.getItem();
            while (consumed < maximum && !stack.isEmpty()) {
                ItemStack offer = stack.copyWithCount(1);
                if (!consumer.test(offer)) {
                    return;
                }
                ++consumed;
                stack.shrink(1);
                if (!stack.isEmpty()) continue;
                entity.discard();
            }
        }
    }

    public static ItemStack removeStack(IItemHandler inventory, int slot) {
        return inventory.extractItem(slot, Integer.MAX_VALUE, false);
    }

    public static ItemStack mergeInsertStack(IItemHandler inventory, int slot, ItemStack stack) {
        ItemStack existing = Helpers.removeStack(inventory, slot);
        ItemStack remainder = stack.copy();
        ItemStack merged = FoodCapability.mergeItemStacks(existing, remainder);
        inventory.insertItem(slot, merged, false);
        return remainder;
    }

    public static ItemStack insertAllSlots(IItemHandler inventory, ItemStack stack) {
        return Helpers.insertSlots(inventory, stack, 0, inventory.getSlots());
    }

    public static ItemStack insertSlots(IItemHandler inventory, ItemStack stack, int slotStartInclusive, int slotEndExclusive) {
        for (int slot = slotStartInclusive; slot < slotEndExclusive; ++slot) {
            if (!(stack = inventory.insertItem(slot, stack, false)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public static boolean insertOne(Level level, BlockPos pos, Supplier<? extends BlockEntityType<? extends InventoryBlockEntity<?>>> type, ItemStack stack) {
        return level.getBlockEntity(pos, type.get()).map(entity -> Helpers.insertOne(entity, stack)).orElse(false);
    }

    public static boolean insertOne(InventoryBlockEntity<?> entity, ItemStack stack) {
        return Helpers.insertAllSlots(entity.getInventory(), stack.copyWithCount(1)).isEmpty();
    }

    public static boolean isEmpty(Iterable<ItemStack> inventory) {
        for (ItemStack stack : inventory) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void fireSpreaderTick(ServerLevel level, BlockPos pos, RandomSource random, int radius) {
        if (level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            for (int i = 0; i < radius; ++i) {
                BlockState state;
                pos = pos.relative(Direction.Plane.HORIZONTAL.getRandomDirection(random));
                if (level.getRandom().nextFloat() < 0.25f) {
                    pos = pos.above();
                }
                if (!(state = level.getBlockState(pos)).isAir()) {
                    return;
                }
                if (!Helpers.hasFlammableNeighbours((LevelReader)level, pos)) continue;
                level.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                return;
            }
        }
    }

    private static boolean hasFlammableNeighbours(LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : DIRECTIONS) {
            mutable.setWithOffset((Vec3i)pos, direction);
            if (!level.getBlockState((BlockPos)mutable).isFlammable((BlockGetter)level, (BlockPos)mutable, direction.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public static void destroyBlockAndDropBlocksManually(ServerLevel level, BlockPos pos, Consumer<LootParams.Builder> builder) {
        BlockState state = level.getBlockState(pos);
        if (!state.isAir()) {
            FluidState fluidstate = level.getFluidState(pos);
            if (!(state.getBlock() instanceof BaseFireBlock)) {
                level.levelEvent(2001, pos, Block.getId((BlockState)state));
            }
            Helpers.dropWithContext(level, state, pos, builder, true);
            level.setBlock(pos, fluidstate.createLegacyBlock(), 3, 512);
        }
    }

    public static void dropWithContext(ServerLevel level, BlockState state, BlockPos pos, Consumer<LootParams.Builder> consumer, boolean randomized) {
        BlockEntity tileEntity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        LootParams.Builder params = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.THIS_ENTITY, null).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)tileEntity);
        consumer.accept(params);
        state.getDrops(params).forEach(stackToSpawn -> {
            if (randomized) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stackToSpawn);
            } else {
                Helpers.spawnDropsAtExactCenter((Level)level, pos, stackToSpawn);
            }
        });
        state.spawnAfterBreak(level, pos, ItemStack.EMPTY, false);
    }

    public static void spawnDropsAtExactCenter(Level level, BlockPos pos, ItemStack stack) {
        if (!level.isClientSide && !stack.isEmpty() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !level.restoringBlockSnapshots) {
            ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack, 0.0, 0.0, 0.0);
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
        }
    }

    public static void playPlaceSound(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        Helpers.playPlaceSound(player, level, pos, state.getSoundType((LevelReader)level, pos, (Entity)player));
    }

    public static void playPlaceSound(@Nullable Player player, LevelAccessor level, BlockPos pos, SoundType sound) {
        level.playSound(player, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
    }

    public static void playSound(Level level, BlockPos pos, SoundEvent sound) {
        level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f + level.getRandom().nextFloat(), level.getRandom().nextFloat() + 0.7f + 0.3f);
    }

    public static boolean spawnItem(Level level, Vec3 pos, ItemStack stack) {
        return level.addFreshEntity((Entity)new ItemEntity(level, pos.x(), pos.y(), pos.z(), stack));
    }

    public static boolean spawnItem(Level level, BlockPos pos, ItemStack stack, double yOffset) {
        return level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + yOffset, (double)pos.getZ() + 0.5, stack));
    }

    public static boolean spawnItem(Level level, BlockPos pos, ItemStack stack, double yOffset, double xd, double yd, double zd) {
        return level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + yOffset, (double)pos.getZ() + 0.5, stack, xd, yd, zd));
    }

    public static boolean spawnItem(Level level, BlockPos pos, ItemStack stack) {
        return Helpers.spawnItem(level, pos, stack, 0.5);
    }

    public static FluidStack mergeOutputFluidIntoSlot(IItemHandlerModifiable inventory, FluidStack fluidStack, float temperature, int slot) {
        if (!fluidStack.isEmpty()) {
            ItemStack mergeStack = inventory.getStackInSlot(slot);
            @Nullable IFluidHandlerItem fluidHandler = (IFluidHandlerItem)mergeStack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler != null) {
                IHeat mergeHeat;
                int filled = fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (filled > 0 && (mergeHeat = HeatCapability.get(mergeStack)) != null) {
                    FluidHeat heat = FluidHeat.getOrUnknown(fluidStack);
                    float heatCapacity = heat.heatCapacity(filled);
                    mergeHeat.addTemperatureFromSourceWithHeatCapacity(temperature, heatCapacity);
                }
                FluidStack remainder = fluidStack.copy();
                remainder.shrink(filled);
                return remainder;
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public static BlockPos quartToBlock(int x, int y, int z) {
        return new BlockPos(x << 2, y << 2, z << 2);
    }

    public static VoxelShape rotateShape(Direction direction, double x1, double y1, double z1, double x2, double y2, double z2) {
        return switch (direction) {
            case Direction.NORTH -> Block.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            case Direction.EAST -> Block.box((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            case Direction.SOUTH -> Block.box((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            case Direction.WEST -> Block.box((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            default -> throw new IllegalArgumentException("Not horizontal!");
        };
    }

    public static VoxelShape[] computeHorizontalShapes(Function<Direction, VoxelShape> shapeGetter) {
        return new VoxelShape[]{shapeGetter.apply(Direction.SOUTH), shapeGetter.apply(Direction.WEST), shapeGetter.apply(Direction.NORTH), shapeGetter.apply(Direction.EAST)};
    }

    public static <T> List<T> uniqueRandomSample(List<T> list, int n, RandomSource r) {
        int length = list.size();
        if (length < n) {
            throw new IllegalArgumentException("Cannot select n=" + n + " from a list of size = " + length);
        }
        for (int i = length - 1; i >= length - n; --i) {
            Collections.swap(list, i, r.nextInt(i + 1));
        }
        return list.subList(length - n, length);
    }

    public static <T> void shuffleArray(T[] array, RandomSource r) {
        for (int i = array.length; i > 1; --i) {
            Helpers.swap(array, i - 1, r.nextInt(i));
        }
    }

    private static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static <T> List<T> immutableAdd(List<T> list, T element) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + 1)).addAll(list).add(element).build();
    }

    public static <T> List<T> immutableAddAll(List<T> list, List<T> others) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + others.size())).addAll(list).addAll(others).build();
    }

    public static <T> List<T> immutableRemove(List<T> list, T element) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(list.size() - 1));
        for (T t : list) {
            if (t == element) continue;
            builder.add(t);
        }
        return builder.build();
    }

    public static <T> List<T> immutableSwap(List<T> list, T element, int index) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            builder.add(i == index ? element : list.get(i));
        }
        return builder.build();
    }

    public static <T> List<T> immutableCopies(int n, Supplier<T> factory) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)n);
        for (int i = 0; i < n; ++i) {
            builder.add(factory.get());
        }
        return builder.build();
    }

    public static void copyTo(ImmutableList.Builder<ItemStack> builder, IItemHandler inventory) {
        Helpers.copyTo(builder, Helpers.iterate(inventory));
    }

    public static void copyTo(ImmutableList.Builder<ItemStack> builder, Iterable<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            builder.add((Object)stack.copy());
        }
    }

    public static List<ItemStack> copyToAndClear(IItemHandlerModifiable inventory) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            builder.add((Object)inventory.getStackInSlot(slot).copy());
            inventory.setStackInSlot(slot, ItemStack.EMPTY);
        }
        return builder.build();
    }

    public static void copyFrom(List<ItemStack> list, IItemHandlerModifiable inventory) {
        for (int i = 0; i < Math.min(list.size(), inventory.getSlots()); ++i) {
            inventory.setStackInSlot(i, list.get(i).copy());
        }
    }

    public static <T> T uncheck(ThrowingSupplier<?> action) {
        try {
            return (T)action.get();
        }
        catch (Throwable e) {
            return Helpers.throwAsUnchecked(e);
        }
    }

    public static void uncheck(ThrowingRunnable action) {
        try {
            action.run();
        }
        catch (Throwable e) {
            Helpers.throwAsUnchecked(e);
        }
    }

    public static float lerp(float delta, float min, float max) {
        return min + (max - min) * delta;
    }

    public static double lerp(double delta, double min, double max) {
        return min + (max - min) * delta;
    }

    public static float lerp4(float value00, float value01, float value10, float value11, float delta0, float delta1) {
        float value0 = Helpers.lerp(delta1, value00, value01);
        float value1 = Helpers.lerp(delta1, value10, value11);
        return Helpers.lerp(delta0, value0, value1);
    }

    public static float inverseLerp(float value, float min, float max) {
        return (value - min) / (max - min);
    }

    public static int hash(long salt, BlockPos pos) {
        return Helpers.hash(salt, pos.getX(), pos.getY(), pos.getZ());
    }

    public static int hash(long salt, int x, int y, int z) {
        long hash = salt ^ (long)x * 501125321L ^ (long)y * 1136930381L ^ (long)z;
        return (int)(hash *= 668265261L);
    }

    public static RandomSource fork(RandomSource random) {
        return new XoroshiroRandomSource(random.nextLong(), random.nextLong());
    }

    public static float triangle(float amplitude, float midpoint, float frequency, float value) {
        return midpoint + amplitude * (Math.abs(4.0f * frequency * value + 1.0f - 4.0f * (float)Mth.floor((float)(frequency * value + 0.75f))) - 1.0f);
    }

    public static double triangle(double amplitude, double midpoint, double frequency, double value) {
        return midpoint + amplitude * (Math.abs(4.0 * frequency * value + 1.0 - 4.0 * (double)Mth.floor((double)(frequency * value + 0.75))) - 1.0);
    }

    public static int uniform(RandomSource random, int min, int max) {
        return min == max ? min : min + random.nextInt(max - min);
    }

    public static int uniform(Random random, int min, int max) {
        return min == max ? min : min + random.nextInt(max - min);
    }

    public static float uniform(RandomSource random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double uniform(RandomSource random, double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static float triangle(RandomSource random) {
        return random.nextFloat() - random.nextFloat() * 0.5f;
    }

    public static int triangle(RandomSource random, int range) {
        return random.nextInt(range) - random.nextInt(range);
    }

    public static float triangle(RandomSource random, float delta) {
        return (random.nextFloat() - random.nextFloat()) * delta;
    }

    public static double triangle(RandomSource random, double delta) {
        return (random.nextDouble() - random.nextDouble()) * delta;
    }

    public static float easeInOutCubic(float x) {
        return x < 0.5f ? 4.0f * x * x * x : 1.0f - Helpers.cube(-2.0f * x + 2.0f) / 2.0f;
    }

    private static float cube(float x) {
        return x * x * x;
    }

    public static int ceilDiv(int num, int div) {
        return (num + div - 1) / div;
    }

    public static <T> boolean perfectMatchExists(List<T> inputs, List<? extends Predicate<T>> tests) {
        if (inputs.size() != tests.size()) {
            return false;
        }
        int size = inputs.size();
        boolean[][] matrices = new boolean[size][];
        for (int i = 0; i < size; ++i) {
            matrices[i] = new boolean[(size + 1) * (size + 1)];
        }
        boolean[] matrix = matrices[size - 1];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                matrix[i + size * j] = tests.get(i).test(inputs.get(j));
            }
        }
        return Helpers.perfectMatchDet(matrices, size);
    }

    private static boolean perfectMatchDet(boolean[][] matrices, int size) {
        boolean[] matrix = matrices[size - 1];
        return switch (size) {
            case 1 -> matrix[0];
            case 2 -> {
                if (matrix[0] && matrix[3] || matrix[1] && matrix[2]) {
                    yield true;
                }
                yield false;
            }
            default -> {
                for (int c = 0; c < size; ++c) {
                    if (!matrix[c]) continue;
                    Helpers.perfectMatchSub(matrices, size, c);
                    if (!Helpers.perfectMatchDet(matrices, size - 1)) continue;
                    yield true;
                }
                yield false;
            }
        };
    }

    private static void perfectMatchSub(boolean[][] matrices, int size, int dc) {
        int subSize = size - 1;
        boolean[] matrix = matrices[subSize];
        boolean[] sub = matrices[subSize - 1];
        for (int c = 0; c < subSize; ++c) {
            int c0 = c + (c >= dc ? 1 : 0);
            for (int r = 0; r < subSize; ++r) {
                sub[c + subSize * r] = matrix[c0 + size * (r + 1)];
            }
        }
    }

    public static float adjustAverageTemperatureByElevation(int y, float averageTemperature, float seaLevel) {
        return averageTemperature - Mth.clamp((float)(((float)y - seaLevel) * 0.16225f), (float)0.0f, (float)17.822f);
    }

    public static void addInventoryTooltipInfo(Iterable<ItemStack> inventory, List<Component> tooltips) {
        int maximumItems = 0;
        int totalItems = 0;
        for (ItemStack stack : inventory) {
            if (stack.isEmpty()) continue;
            ++totalItems;
            if (maximumItems > 4) continue;
            ++maximumItems;
            tooltips.add((Component)Tooltips.countOfItem(stack));
        }
        if (totalItems - maximumItems > 0) {
            tooltips.add((Component)Component.translatable((String)"container.shulkerBox.more", (Object[])new Object[]{totalItems - maximumItems}).withStyle(ChatFormatting.ITALIC));
        }
    }

    @Nullable
    public static BlockState getSupportedDirectionalStateForPlacement(Block block, BlockPlaceContext context, boolean horizontal) {
        Direction[] looking;
        BlockState blockstate = block.defaultBlockState();
        Level levelreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        for (Direction direction : looking = context.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() && horizontal || !(blockstate = (BlockState)blockstate.setValue((Property)BlockStateProperties.FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public static boolean isItem(ItemStack stack, ItemLike item) {
        return stack.is(item.asItem());
    }

    public static boolean isItem(ItemStack stack, TagKey<Item> tag) {
        return stack.is(tag);
    }

    public static boolean isItem(Item item, TagKey<Item> tag) {
        return item.builtInRegistryHolder().is(tag);
    }

    public static Optional<Item> randomItem(TagKey<Item> tag, RandomSource random) {
        return Helpers.getRandomElement(BuiltInRegistries.ITEM, tag, random);
    }

    public static Stream<Item> allItems(TagKey<Item> tag) {
        return BuiltInRegistries.ITEM.getOrCreateTag(tag).stream().map(Holder::value);
    }

    public static boolean isBlock(BlockState block, Block other) {
        return block.is(other);
    }

    public static boolean isBlock(BlockState state, TagKey<Block> tag) {
        return state.is(tag);
    }

    public static boolean isBlock(Block block, TagKey<Block> tag) {
        return block.builtInRegistryHolder().is(tag);
    }

    public static Optional<Block> randomBlock(TagKey<Block> tag, RandomSource random) {
        return Helpers.getRandomElement(BuiltInRegistries.BLOCK, tag, random);
    }

    public static Stream<Block> allBlocks(TagKey<Block> tag) {
        return BuiltInRegistries.BLOCK.getOrCreateTag(tag).stream().map(Holder::value);
    }

    public static boolean isFluid(FluidState state, TagKey<Fluid> tag) {
        return state.is(tag);
    }

    public static boolean isFluid(Fluid fluid, TagKey<Fluid> tag) {
        return fluid.is(tag);
    }

    public static boolean isFluid(FluidState fluid, Fluid other) {
        return fluid.is(other);
    }

    public static Stream<Fluid> allFluids(TagKey<Fluid> tag) {
        return BuiltInRegistries.FLUID.getOrCreateTag(tag).stream().map(Holder::value);
    }

    public static boolean isEntity(Entity entity, TagKey<EntityType<?>> tag) {
        return Helpers.isEntity(entity.getType(), tag);
    }

    public static boolean isEntity(EntityType<?> entity, TagKey<EntityType<?>> tag) {
        return entity.is(tag);
    }

    public static Optional<EntityType<?>> randomEntity(TagKey<EntityType<?>> tag, RandomSource random) {
        return Helpers.getRandomElement(BuiltInRegistries.ENTITY_TYPE, tag, random);
    }

    public static boolean isDamageSource(DamageSource source, TagKey<DamageType> tag) {
        return source.is(tag);
    }

    private static <T> Optional<T> getRandomElement(Registry<T> registry, TagKey<T> tag, RandomSource random) {
        return registry.getTag(tag).flatMap(set -> set.getRandomElement(random)).map(Holder::value);
    }

    public static void seedLargeFeatures(RandomSource random, long baseSeed, int index, int decoration) {
        random.setSeed(baseSeed);
        long seed = (long)index * random.nextLong() * 203704237L ^ (long)decoration * random.nextLong() * 758031792L ^ baseSeed;
        random.setSeed(seed);
    }

    public static <E extends Throwable, T> T throwAsUnchecked(Throwable exception) throws E {
        throw exception;
    }

    public static enum CarryCount {
        NONE,
        ONE,
        MORE_THAN_ONE;


        public boolean isNonZero() {
            return this != NONE;
        }
    }
}

