/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.List;
import java.util.Locale;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.EntityDamageResistance;
import net.dries007.tfc.util.data.ItemDamageResistance;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum PhysicalDamageType implements StringRepresentable
{
    CRUSHING,
    SLASHING,
    PIERCING;

    public static final TagKey<DamageType> BYPASSES_DAMAGE_RESISTANCES;
    public static final TagKey<DamageType> IS_PIERCING;
    public static final TagKey<DamageType> IS_CRUSHING;
    public static final TagKey<DamageType> IS_SLASHING;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);

    public static void addTooltipInfo(ItemStack stack, List<Component> tooltips) {
        Multiplier resistanceType;
        PhysicalDamageType damageType = PhysicalDamageType.getTypeForItem(stack);
        if (damageType != null) {
            tooltips.add((Component)Component.translatable((String)("tfc.tooltip.deals_damage." + damageType.getSerializedName())));
        }
        if ((resistanceType = PhysicalDamageType.getResistanceForItem(stack)) != null) {
            tooltips.add((Component)Component.translatable((String)"tfc.tooltip.resists_damage", (Object[])new Object[]{PhysicalDamageType.calculatePercentageForDisplay(resistanceType.slashing()), PhysicalDamageType.calculatePercentageForDisplay(resistanceType.piercing()), PhysicalDamageType.calculatePercentageForDisplay(resistanceType.crushing())}));
        }
    }

    public static float calculateMultiplier(DamageSource source, Entity entityUnderAttack) {
        EntityDamageResistance entityResistance;
        PhysicalDamageType type = PhysicalDamageType.getTypeForSource(source);
        float resistance = 0.0f;
        if (type != null && (entityResistance = EntityDamageResistance.get(entityUnderAttack)) != null) {
            resistance += entityResistance.damages().value(type);
        }
        if (entityUnderAttack instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityUnderAttack;
            for (ItemStack stack : livingEntity.getArmorSlots()) {
                Multiplier armorMultiplier = PhysicalDamageType.getResistanceForItem(stack);
                if (armorMultiplier == null) continue;
                resistance += armorMultiplier.value(type);
            }
        }
        return (float)Math.pow(Math.E, -0.01 * (double)resistance);
    }

    @Nullable
    public static PhysicalDamageType getTypeForSource(DamageSource source) {
        if (source.is(BYPASSES_DAMAGE_RESISTANCES)) {
            return null;
        }
        if (source.is(IS_PIERCING)) {
            return PIERCING;
        }
        if (source.is(IS_CRUSHING)) {
            return CRUSHING;
        }
        if (source.is(IS_SLASHING)) {
            return CRUSHING;
        }
        Entity entity = source.getEntity();
        if (entity != null) {
            PhysicalDamageType weaponDamageType;
            LivingEntity livingEntity;
            ItemStack heldItem;
            if (entity instanceof LivingEntity && !(heldItem = (livingEntity = (LivingEntity)entity).getMainHandItem()).isEmpty() && (weaponDamageType = PhysicalDamageType.getTypeForItem(heldItem)) != null) {
                return weaponDamageType;
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.DEALS_PIERCING_DAMAGE)) {
                return PIERCING;
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.DEALS_SLASHING_DAMAGE)) {
                return SLASHING;
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.DEALS_CRUSHING_DAMAGE)) {
                return CRUSHING;
            }
        }
        return null;
    }

    @Nullable
    public static PhysicalDamageType getTypeForItem(ItemStack stack) {
        if (Helpers.isItem(stack, TFCTags.Items.DEALS_PIERCING_DAMAGE)) {
            return PIERCING;
        }
        if (Helpers.isItem(stack, TFCTags.Items.DEALS_SLASHING_DAMAGE)) {
            return SLASHING;
        }
        if (Helpers.isItem(stack, TFCTags.Items.DEALS_CRUSHING_DAMAGE)) {
            return CRUSHING;
        }
        return null;
    }

    @Nullable
    public static Multiplier getResistanceForItem(ItemStack stack) {
        ItemDamageResistance itemResistance = ItemDamageResistance.get(stack);
        if (itemResistance != null) {
            return itemResistance.damages();
        }
        return null;
    }

    private static Component calculatePercentageForDisplay(float resistance) {
        float multiplier = 1.0f - (float)Math.pow(Math.E, -0.01 * (double)resistance);
        if ((double)multiplier >= 0.999999) {
            return Component.translatable((String)"tfc.tooltip.immune_to_damage");
        }
        return Component.literal((String)String.format("%.0f%%", Float.valueOf(multiplier * 100.0f)));
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    static {
        BYPASSES_DAMAGE_RESISTANCES = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Helpers.identifier("bypasses_damage_resistances"));
        IS_PIERCING = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Helpers.identifier("is_piercing"));
        IS_CRUSHING = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Helpers.identifier("is_crushing"));
        IS_SLASHING = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Helpers.identifier("is_slashing"));
    }

    public static interface Multiplier {
        public float crushing();

        public float piercing();

        public float slashing();

        default public float value(@Nullable PhysicalDamageType type) {
            if (type == null) {
                return Math.max(this.crushing(), Math.max(this.piercing(), this.slashing()));
            }
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.crushing();
                case 1 -> this.slashing();
                case 2 -> this.piercing();
            };
        }
    }
}

