/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.TFCCreativeTabs;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.PouredGlassBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.IngotPileBlock;
import net.dries007.tfc.common.blocks.devices.ScrapingBlock;
import net.dries007.tfc.common.blocks.plant.BodyPlantBlock;
import net.dries007.tfc.common.blocks.plant.BranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.GrowingBranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.TopPlantBlock;
import net.dries007.tfc.common.blocks.plant.fruit.GrowingFruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.rock.RockDisplayCategory;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.common.component.forge.ForgeStep;
import net.dries007.tfc.common.component.forge.ForgingBonus;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.component.size.Size;
import net.dries007.tfc.common.component.size.Weight;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Day;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.KoppenClimateClassification;
import net.dries007.tfc.util.data.Drinkable;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.slf4j.Logger;

public final class SelfTests {
    public static final boolean THROW_ON_FAIL = true;
    public static final boolean ENABLED = Boolean.getBoolean("tfc.enableDebugSelfTests");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean EXTERNAL_ERROR = false;

    public static void runWorldVersionTest() {
    }

    public static void runClientSelfTests() {
        if (ENABLED) {
            NeoForge.EVENT_BUS.post((Event)new ClientSelfTestEvent());
            Stopwatch tick = Stopwatch.createStarted();
            SelfTests.throwIfAny(SelfTests.validateModels(), SelfTests.validateTranslationsAndCreativeTabs());
            LOGGER.info("Client self tests passed in {}", (Object)tick.stop());
        }
    }

    public static void runServerSelfTests(MinecraftServer server) {
        if (ENABLED) {
            Stopwatch tick = Stopwatch.createStarted();
            SelfTests.throwIfAny(SelfTests.validateOwnBlockLootTables(server), EXTERNAL_ERROR);
            LOGGER.info("Server self tests passed in {}", (Object)tick.stop());
        }
    }

    public static void runDataPackTests(RecipeManager manager) {
        if (TFCConfig.COMMON.enableDatapackTests.get().booleanValue()) {
            Stopwatch tick = Stopwatch.createStarted();
            if (!(SelfTests.validateJugDrinkable() | SelfTests.validatePotFluidUsability(manager) | SelfTests.validateBarrelFluidUsability(manager) | SelfTests.validateUniqueBloomeryRecipes(manager) | SelfTests.validateUniqueLoomRecipes(manager) | SelfTests.validateMoldsCanContainCastingIngredients(manager) | SelfTests.validateHeatingRecipeIngredientsAreHeatable(manager))) {
                LOGGER.info("Data pack self tests passed in {}", (Object)tick.stop());
            }
        }
    }

    public static Function<Holder<? extends Block>, Stream<BlockState>> states(Predicate<BlockState> filter) {
        return block -> ((Block)block.value()).getStateDefinition().getPossibleStates().stream().filter(filter);
    }

    public static boolean validateTranslation(Logger logger, Set<String> missingTranslations, Component component) {
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            if (!Language.getInstance().has(translatable.getKey())) {
                missingTranslations.add(translatable.getKey());
            }
        } else {
            logger.error("Tried to check the translation key of a non-translatable-component, this is almost certainly a bug, {}", (Object)component);
            return true;
        }
        return false;
    }

    public static boolean validateBlockLootTables(MinecraftServer server, List<Block> blocks, Logger logger) {
        Set lootTables = server.reloadableRegistries().get().registryOrThrow(Registries.LOOT_TABLE).keySet();
        List<Block> missingLootTables = blocks.stream().filter(b -> !lootTables.contains(b.getLootTable().location())).filter(b -> !b.defaultBlockState().isAir()).toList();
        return SelfTests.logRegistryErrors("{} blocks found with a non-existent loot table:", missingLootTables, logger);
    }

    public static <T> boolean logErrors(String error, Collection<T> errors, Logger logger) {
        if (!errors.isEmpty()) {
            logger.error(error, (Object)errors.size());
            errors.forEach(e -> logger.error("  {}", e));
            return true;
        }
        return false;
    }

    public static <T> boolean logWarnings(String error, Collection<T> errors, Logger logger) {
        if (!errors.isEmpty()) {
            logger.warn(error, (Object)errors.size());
            errors.forEach(e -> logger.warn("  {}", e));
            return true;
        }
        return false;
    }

    public static <T> boolean logRegistryErrors(String error, Collection<T> errors, Logger logger) {
        if (!errors.isEmpty()) {
            logger.error(error, (Object)errors.size());
            errors.forEach(e -> logger.error("  {} of {}", (Object)e.toString(), (Object)e.getClass().getSimpleName()));
            return true;
        }
        return false;
    }

    public static void throwIfAny(boolean ... errors) {
        for (boolean error : errors) {
            if (error) {
                throw new AssertionError((Object)"Self Tests Failed! Fix the above errors!");
            }
        }
    }

    public static void reportExternalError() {
        EXTERNAL_ERROR = true;
    }

    public static void warnWhenCalledFromClientThread() {
        if (ENABLED && EffectiveSide.get().isClient()) {
            LOGGER.warn("This method should not be called from client thread, this is a bug!", (Throwable)new RuntimeException("Stacktrace"));
        }
    }

    private static boolean validateOwnBlockLootTables(MinecraftServer server) {
        Set expectedNoLootTableBlocks = Stream.of(TFCBlocks.PLACED_ITEM, TFCBlocks.PIT_KILN, TFCBlocks.LOG_PILE, TFCBlocks.BURNING_LOG_PILE, TFCBlocks.BLOOM, TFCBlocks.MOLTEN, TFCBlocks.SCRAPING, TFCBlocks.THATCH_BED, TFCBlocks.INGOT_PILE, TFCBlocks.DOUBLE_INGOT_PILE, TFCBlocks.PLANTS.get(Plant.GIANT_KELP_PLANT), TFCBlocks.PUMPKIN, TFCBlocks.MELON, TFCBlocks.CAKE, TFCBlocks.CALCITE, TFCBlocks.ICICLE, TFCBlocks.RIVER_WATER, TFCBlocks.SPRING_WATER, TFCBlocks.LIGHT, TFCBlocks.SALTWATER_BUBBLE_COLUMN, TFCBlocks.FRESHWATER_BUBBLE_COLUMN, TFCBlocks.HOT_POURED_GLASS, TFCBlocks.GLASS_BASIN).map(Supplier::get).collect(Collectors.toSet());
        ImmutableSet expectedNoLootTableClasses = ImmutableSet.of(BodyPlantBlock.class, GrowingFruitTreeBranchBlock.class, LiquidBlock.class, BranchingCactusBlock.class, GrowingBranchingCactusBlock.class, PouredGlassBlock.class, (Object[])new Class[0]);
        return SelfTests.validateBlockLootTables(server, TFCBlocks.BLOCKS.getEntries().stream().map(Holder::value).filter(arg_0 -> SelfTests.lambda$validateOwnBlockLootTables$6(expectedNoLootTableBlocks, (Set)expectedNoLootTableClasses, arg_0)).toList(), LOGGER);
    }

    private static boolean validateModels() {
        BlockModelShaper shaper = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
        BakedModel missingModel = shaper.getModelManager().getMissingModel();
        TextureAtlasSprite missingParticle = missingModel.getParticleIcon();
        List<BlockState> missingModelErrors = TFCBlocks.BLOCKS.getEntries().stream().flatMap(SelfTests.states(s -> s.getRenderShape() == RenderShape.MODEL && shaper.getBlockModel(s) == missingModel)).toList();
        List<BlockState> missingParticleErrors = TFCBlocks.BLOCKS.getEntries().stream().flatMap(SelfTests.states(s -> !s.isAir() && !(s.getBlock() instanceof IngotPileBlock) && !(s.getBlock() instanceof PlantBlock) && !(s.getBlock() instanceof BodyPlantBlock) && !(s.getBlock() instanceof TopPlantBlock) && !(s.getBlock() instanceof ScrapingBlock) && shaper.getParticleIcon(s) == missingParticle)).toList();
        return SelfTests.logErrors("{} block states with missing models:", missingModelErrors, LOGGER) | SelfTests.logErrors("{} block states with missing particles:", missingParticleErrors, LOGGER);
    }

    private static boolean validateTranslationsAndCreativeTabs() {
        Set missingTranslations = Bootstrap.getMissingTranslations();
        ArrayList stacks = new ArrayList();
        HashSet items = new HashSet();
        boolean error = false;
        TFCCreativeTabs.generators().forEach(gen -> gen.accept(null, (stack, visibility) -> {
            stacks.add(stack);
            items.add(stack.getItem());
        }));
        Set technicalItemsWithNoTab = Stream.of(List.of(TFCBlocks.SNOW_PILE, TFCBlocks.ICE_PILE, TFCBlocks.BLOOM, TFCBlocks.MOLTEN, TFCBlocks.LIGHT, TFCBlocks.POURED_GLASS, TFCItems.FILLED_PAN), TFCBlocks.COLORED_POURED_GLASS.values(), TFCBlocks.ROCK_ANVILS.values()).flatMap(Collection::stream).map(ItemLike::asItem).collect(Collectors.toSet());
        List<Item> missingItems = TFCItems.ITEMS.getEntries().stream().map(Holder::value).filter(item -> !items.contains(item) && !technicalItemsWithNoTab.contains(item)).toList();
        error |= SelfTests.logErrors("{} items were not found in any TFC creative tab", missingItems, LOGGER);
        for (ItemStack stack : stacks) {
            error |= SelfTests.validateTranslation(LOGGER, missingTranslations, stack.getHoverName());
        }
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
        BuiltInRegistries.SOUND_EVENT.forEach(sound -> Optional.ofNullable(soundManager.getSoundEvent(sound.getLocation())).map(WeighedSoundEvents::getSubtitle).ifPresent(subtitle -> SelfTests.validateTranslation(LOGGER, missingTranslations, subtitle)));
        for (DeferredHolder holder : TFCCreativeTabs.CREATIVE_TABS.getEntries()) {
            error |= SelfTests.validateTranslation(LOGGER, missingTranslations, ((CreativeModeTab)holder.value()).getDisplayName());
        }
        for (Class clazz : List.of(ForgeStep.class, ForgingBonus.class, Heat.class, Nutrient.class, Size.class, Weight.class, Day.class, Month.class, KoppenClimateClassification.class, ForestType.class, RockDisplayCategory.class)) {
            for (Enum enumConstant : (Enum[])clazz.getEnumConstants()) {
                error |= SelfTests.validateTranslation(LOGGER, missingTranslations, (Component)Helpers.translateEnum(enumConstant));
            }
        }
        return (error |= TFCBlockEntities.BLOCK_ENTITIES.getEntries().stream().anyMatch(type -> {
            Block block = (Block)((BlockEntityType)type.value()).getValidBlocks().stream().findFirst().orElseThrow();
            BlockEntity entity = ((BlockEntityType)type.value()).create(BlockPos.ZERO, block.defaultBlockState());
            if (entity instanceof InventoryBlockEntity) {
                InventoryBlockEntity inv = (InventoryBlockEntity)entity;
                return SelfTests.validateTranslation(LOGGER, missingTranslations, inv.getDisplayName());
            }
            return false;
        })) | SelfTests.logErrors("{} missing translation keys:", missingTranslations, LOGGER);
    }

    private static boolean validateJugDrinkable() {
        List<Fluid> errors = Helpers.allFluids(TFCTags.Fluids.USABLE_IN_JUG).filter(fluid -> Drinkable.get(fluid) == null).toList();
        return SelfTests.logWarnings("{} fluids were in the tfc:usable_in_jug tag but lack a Drinkable json entry", errors, LOGGER);
    }

    private static boolean validatePotFluidUsability(RecipeManager manager) {
        Set errors = manager.getAllRecipesFor((RecipeType)TFCRecipeTypes.POT.get()).stream().flatMap(recipe -> RecipeHelpers.stream(((PotRecipe)recipe.value()).getFluidIngredient())).filter(fluid -> !Helpers.isFluid(fluid, TFCTags.Fluids.USABLE_IN_POT)).collect(Collectors.toSet());
        return SelfTests.logErrors("{} fluids are listed in pot recipes that are not tagged as tfc:usable_in_pot", errors, LOGGER);
    }

    private static boolean validateBarrelFluidUsability(RecipeManager manager) {
        Set errors = manager.getRecipes().stream().filter(recipe -> recipe.value() instanceof BarrelRecipe).map(recipe -> (BarrelRecipe)recipe.value()).flatMap(recipe -> Stream.concat(RecipeHelpers.stream(recipe.getInputFluid()), Stream.of(recipe.getOutputFluid().getFluid()))).filter(fluid -> !fluid.isSame(Fluids.EMPTY) && !Helpers.isFluid(fluid, TFCTags.Fluids.USABLE_IN_BARREL)).collect(Collectors.toSet());
        return SelfTests.logErrors("{} fluids are listed in barrel recipes that are not tagged as tfc:usable_in_barrel", errors, LOGGER);
    }

    private static boolean validateUniqueBloomeryRecipes(RecipeManager manager) {
        List<Fluid> errors = manager.getAllRecipesFor((RecipeType)TFCRecipeTypes.BLOOMERY.get()).stream().flatMap(recipe -> RecipeHelpers.stream(((BloomeryRecipe)recipe.value()).getInputFluid())).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(m -> (Long)m.getValue() > 1L).map(Map.Entry::getKey).toList();
        return SelfTests.logErrors("{} fluids appeared in multiple bloomery recipes. Currently, every bloomery recipe must have a unique fluid input in order to work", errors, LOGGER);
    }

    private static boolean validateUniqueLoomRecipes(RecipeManager manager) {
        List<Item> errors = manager.getAllRecipesFor((RecipeType)TFCRecipeTypes.LOOM.get()).stream().flatMap(recipe -> Arrays.stream(((LoomRecipe)recipe.value()).getItemStackIngredient().ingredient().getItems())).map(ItemStack::getItem).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(m -> (Long)m.getValue() > 1L).map(Map.Entry::getKey).toList();
        return SelfTests.logErrors("{} items appeared in multiple loom recipes. Currently, every loom recipe must have a unique item input in order to work", errors, LOGGER);
    }

    private static boolean validateMoldsCanContainCastingIngredients(RecipeManager manager) {
        List<String> errors = manager.getAllRecipesFor((RecipeType)TFCRecipeTypes.CASTING.get()).stream().map(holder -> {
            for (ItemStack stack : ((CastingRecipe)holder.value()).getIngredient().getItems()) {
                IMold mold = IMold.get(stack);
                if (mold == null) {
                    return "Item is not a mold: " + String.valueOf(stack);
                }
                for (FluidStack fluid : ((CastingRecipe)holder.value()).getFluidIngredient().getFluids()) {
                    if (mold.isFluidValid(0, fluid)) continue;
                    return "Mold " + String.valueOf(stack) + " cannot contain " + String.valueOf(fluid);
                }
            }
            return null;
        }).filter(Objects::nonNull).toList();
        return SelfTests.logErrors("{} mold recipes were invalid", errors, LOGGER);
    }

    private static boolean validateHeatingRecipeIngredientsAreHeatable(RecipeManager manager) {
        List<ItemStack> errors = manager.getAllRecipesFor((RecipeType)TFCRecipeTypes.HEATING.get()).stream().flatMap(recipe -> Arrays.stream(((HeatingRecipe)recipe.value()).getIngredient().getItems())).filter(stack -> HeatCapability.getDefinition(stack) == null).toList();
        return SelfTests.logErrors("{} items found as ingredients to heating recipes without a heat definition!", errors, LOGGER);
    }

    private static /* synthetic */ boolean lambda$validateOwnBlockLootTables$6(Set expectedNoLootTableBlocks, Set expectedNoLootTableClasses, Block b) {
        return !expectedNoLootTableBlocks.contains(b) && !expectedNoLootTableClasses.contains(b.getClass());
    }

    public static class ClientSelfTestEvent
    extends Event {
    }
}

