/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.slf4j.Logger;

public class CalendarEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float SLEEP_TIME = 0.8333333f;
    private static final float WAKE_TIME = 0.20833333f;

    public static void init() {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(CalendarEventHandler::onServerStart);
        bus.addListener(CalendarEventHandler::onServerStop);
        bus.addListener(CalendarEventHandler::onServerTick);
        bus.addListener(CalendarEventHandler::onOverworldTick);
        bus.addListener(CalendarEventHandler::onPlayerStartSleeping);
        bus.addListener(CalendarEventHandler::onPlayerLoggedOut);
        bus.addListener(CalendarEventHandler::onPlayerLoggedIn);
    }

    public static void onServerStart(ServerStartingEvent event) {
        Calendars.SERVER.onServerStart(event.getServer());
    }

    public static void onServerStop(ServerStoppedEvent event) {
        Calendars.SERVER.onServerStop();
    }

    public static void onServerTick(ServerTickEvent.Pre event) {
        Calendars.SERVER.onServerTick();
    }

    public static void onOverworldTick(LevelTickEvent.Post event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).dimension() == Level.OVERWORLD) {
            Calendars.SERVER.onOverworldTick(level);
        }
    }

    public static void onPlayerStartSleeping(CanPlayerSleepEvent event) {
        if (event.getVanillaProblem() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW || event.getVanillaProblem() == null) {
            float time = Calendars.SERVER.getCalendarFractionOfDay();
            event.setProblem(time >= 0.8333333f || time <= 0.20833333f ? null : Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
        }
    }

    public static void onPlayersFinishedSleeping(ServerLevel level) {
        float currentFractionOfDay = Calendars.SERVER.getCalendarFractionOfDay();
        float wakeUpTime = 0.20833333f;
        float targetFraction = 0.20833333f > currentFractionOfDay ? 0.20833333f : 1.2083334f;
        int calendarTicksSlept = (int)((targetFraction - currentFractionOfDay) * 24000.0f);
        Calendars.SERVER.skipForwardBy(calendarTicksSlept);
        float exhaustion = (float)Calendars.SERVER.getFixedCalendarTicksFromTick(calendarTicksSlept) * 0.0033333334f * TFCConfig.SERVER.passiveExhaustionModifier.get().floatValue();
        for (ServerPlayer player : level.players()) {
            player.causeFoodExhaustion(exhaustion);
        }
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        MinecraftServer server;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (server = (player = (ServerPlayer)player2).getServer()) != null) {
            LOGGER.info("Player Logged Out - Checking for Calendar Updates.");
            List players = server.getPlayerList().getPlayers();
            int playerCount = players.size();
            if (players.contains(player)) {
                --playerCount;
            }
            Calendars.SERVER.setPlayersLoggedOn(playerCount > 0);
        }
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        MinecraftServer server;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (server = (player = (ServerPlayer)player2).getServer()) != null) {
            LOGGER.info("Player Logged In - Checking for Calendar Updates.");
            Calendars.SERVER.setPlayersLoggedOn(server.getPlayerList().getPlayerCount() > 0);
        }
    }
}

