/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TimeDeltaTooltipStyle;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTransaction;
import net.dries007.tfc.util.calendar.Day;
import net.dries007.tfc.util.calendar.Month;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface ICalendar {
    public static final int HOURS_IN_DAY = 24;
    public static final int MONTHS_IN_YEAR = 12;
    @Deprecated
    public static final int TICKS_IN_DAY = 24000;
    public static final int CALENDAR_TICKS_IN_HOUR = 1000;
    public static final int CALENDAR_TICKS_IN_DAY = 24000;

    public static MutableComponent getTimeAndDate(long calendarTick, long daysInMonth) {
        return Component.translatable((String)"tfc.tooltip.calendar_hour_minute_month_day_year", (Object[])new Object[]{String.format("%d:%02d", ICalendar.getHourOfDay(calendarTick), ICalendar.getMinuteOfHour(calendarTick)), Helpers.translateEnum(ICalendar.getMonthOfYear(calendarTick, daysInMonth)), ICalendar.getDayOfMonth(calendarTick, daysInMonth), ICalendar.getCalendarYear(calendarTick, daysInMonth)});
    }

    public static MutableComponent getDayTime(long calendarTick) {
        return Component.literal((String)String.format("%d:%02d", ICalendar.getHourOfDay(calendarTick), ICalendar.getMinuteOfHour(calendarTick)));
    }

    public static MutableComponent getTimeDelta(long calendarTick, int daysInMonth) {
        long hours = ICalendar.getTotalCalendarHours(calendarTick);
        if (hours < 1L) {
            return Component.translatable((String)"tfc.tooltip.time_delta_hours_minutes", (Object[])new Object[]{"00", String.format("%02d", ICalendar.getMinuteOfHour(calendarTick))});
        }
        long days = ICalendar.getTotalCalendarDays(calendarTick);
        if (days < 1L) {
            return Component.translatable((String)"tfc.tooltip.time_delta_hours_minutes", (Object[])new Object[]{hours, String.format("%02d", ICalendar.getMinuteOfHour(calendarTick))});
        }
        long months = ICalendar.getTotalMonths(calendarTick, daysInMonth);
        TimeDeltaTooltipStyle style = TFCConfig.CLIENT.timeDeltaTooltipStyle.get();
        if (months < 1L || style == TimeDeltaTooltipStyle.DAYS) {
            return Component.translatable((String)"tfc.tooltip.time_delta_days", (Object[])new Object[]{days});
        }
        long years = ICalendar.getCalendarYear(calendarTick, daysInMonth) - 1000L;
        if (years < 1L || style == TimeDeltaTooltipStyle.DAYS_MONTHS) {
            return Component.translatable((String)"tfc.tooltip.time_delta_months_days", (Object[])new Object[]{months, days % (long)daysInMonth});
        }
        return Component.translatable((String)"tfc.tooltip.time_delta_years_months_days", (Object[])new Object[]{years, months % 12L, days % (long)daysInMonth});
    }

    private static int getMinuteOfHour(long calendarTick) {
        return (int)(60.0f * (float)(calendarTick % 1000L) / 1000.0f);
    }

    public static int getHourOfDay(long calendarTick) {
        return (int)(calendarTick / 1000L % 24L);
    }

    private static int getDayOfMonth(long calendarTick, long daysInMonth) {
        return 1 + (int)(calendarTick / 24000L % daysInMonth);
    }

    private static long getTotalCalendarHours(long calendarTick) {
        return calendarTick / 1000L;
    }

    private static long getTotalMonths(long calendarTick, long daysInMonth) {
        return calendarTick / (daysInMonth * 24000L);
    }

    private static long getCalendarYear(long calendarTick, long daysInMonth) {
        return 1000L + calendarTick / (12L * daysInMonth * 24000L);
    }

    public static long getTotalCalendarDays(long calendarTick) {
        return calendarTick / 24000L;
    }

    public static float getFractionOfHour(long calendarTick) {
        return (float)(calendarTick % 1000L) / 1000.0f;
    }

    public static float getFractionOfDay(long calendarTick) {
        return (float)(calendarTick % 24000L) / 24000.0f;
    }

    public static float getFractionOfMonth(long calendarTick, long daysInMonth) {
        long ticksInMonth = daysInMonth * 24000L;
        return (float)(calendarTick % ticksInMonth) / (float)ticksInMonth;
    }

    public static float getFractionOfYear(long calendarTick, long daysInMonth) {
        long ticksInYear = 12L * daysInMonth * 24000L;
        return (float)(calendarTick % ticksInYear) / (float)ticksInYear;
    }

    public static Month getMonthOfYear(long calendarTick, long daysInMonth) {
        long ticksInMonth = daysInMonth * 24000L;
        return Month.valueOf((int)(calendarTick / ticksInMonth % 12L));
    }

    public CalendarTransaction transaction();

    public long getTicks();

    default public long getTicksInHour() {
        return this.getFixedCalendarTicksFromTick(1000L);
    }

    public long getCalendarTicks();

    public int getCalendarDaysInMonth();

    public long getCalendarTickFromOffset(long var1);

    public long getFixedCalendarTicksFromTick(long var1);

    @Deprecated
    default public long getTotalDays() {
        return ICalendar.getTotalCalendarDays(this.getTicks());
    }

    default public long getTotalCalendarDays() {
        return ICalendar.getTotalCalendarDays(this.getCalendarTicks());
    }

    default public long getCalendarYear() {
        return ICalendar.getCalendarYear(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public int getCalendarDayOfMonth() {
        return ICalendar.getDayOfMonth(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public float getCalendarFractionOfHour() {
        return ICalendar.getFractionOfHour(this.getCalendarTicks());
    }

    default public float getCalendarFractionOfDay() {
        return ICalendar.getFractionOfDay(this.getCalendarTicks());
    }

    default public float getCalendarFractionOfMonth() {
        return ICalendar.getFractionOfMonth(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public float getCalendarFractionOfYear() {
        return ICalendar.getFractionOfYear(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public MutableComponent getCalendarDayOfYear() {
        return Day.getDayName(this.getTotalCalendarDays(), this.getAbsoluteCalendarMonthOfYear(), this.getCalendarDayOfMonth());
    }

    default public MutableComponent getBirthday() {
        return Day.getBirthday(this.getTotalCalendarDays(), this.getAbsoluteCalendarMonthOfYear(), this.getCalendarDayOfMonth()).orElse(Component.empty());
    }

    default public Month getHemispheralCalendarMonthOfYear(boolean northernHemisphere) {
        if (northernHemisphere) {
            return ICalendar.getMonthOfYear(this.getCalendarTicks(), this.getCalendarDaysInMonth());
        }
        return ICalendar.getMonthOfYear(this.getCalendarTicks(), this.getCalendarDaysInMonth()).opposite();
    }

    default public Month getAbsoluteCalendarMonthOfYear() {
        return ICalendar.getMonthOfYear(this.getCalendarTicks(), this.getCalendarDaysInMonth());
    }

    default public long getCalendarTicksInMonth() {
        return 24000L * (long)this.getCalendarDaysInMonth();
    }

    default public long getCalendarTicksInYear() {
        return 12L * this.getCalendarTicksInMonth();
    }

    default public MutableComponent getTimeAndDate() {
        return this.getOffsetTimeAndDate(0L);
    }

    default public MutableComponent getDayTime() {
        return ICalendar.getDayTime(this.getCalendarTicks());
    }

    default public int getHourOfDay() {
        return ICalendar.getHourOfDay(this.getCalendarTicks());
    }

    default public int getMinuteOfHour() {
        return ICalendar.getMinuteOfHour(this.getCalendarTicks());
    }

    default public MutableComponent getExactTimeAndDate(long playerTick) {
        return this.getOffsetTimeAndDate(playerTick - this.getTicks());
    }

    default public MutableComponent getOffsetTimeAndDate(long offsetTick) {
        return ICalendar.getTimeAndDate(this.getCalendarTickFromOffset(offsetTick), this.getCalendarDaysInMonth());
    }

    default public MutableComponent getTimeDelta(long playerTick) {
        return ICalendar.getTimeDelta(this.getFixedCalendarTicksFromTick(playerTick), this.getCalendarDaysInMonth());
    }

    default public MutableComponent getCalendarTimeDelta(long offsetTick) {
        return ICalendar.getTimeDelta(this.getCalendarTickFromOffset(offsetTick), this.getCalendarDaysInMonth());
    }
}

