/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.mixin.accessor.BiomeAccessor;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.climate.ClimateModelType;
import net.dries007.tfc.util.climate.ClimateModels;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;

public enum BiomeBasedClimateModel implements ClimateModel
{
    INSTANCE;

    public static final StreamCodec<ByteBuf, BiomeBasedClimateModel> STREAM_CODEC;

    @Override
    public ClimateModelType<?> type() {
        return (ClimateModelType)ClimateModels.BIOME_BASED.get();
    }

    @Override
    public float getAverageTemperature(LevelReader level, BlockPos pos) {
        return Climate.fromVanilla(((BiomeAccessor)level.getBiome(pos).value()).invoke$getTemperature(pos));
    }

    @Override
    public float getAverageRainfall(LevelReader level, BlockPos pos) {
        return ((Biome)level.getBiome(pos).value()).getPrecipitationAt(pos) != Biome.Precipitation.NONE ? 300.0f : 0.0f;
    }

    static {
        STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    }
}

