/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.BiomeBasedClimateModel;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.climate.ClimateModelType;
import net.dries007.tfc.util.climate.OverworldClimateModel;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.Registry;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;

public final class ClimateModels {
    public static final ResourceKey<Registry<ClimateModelType<?>>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Helpers.identifier("climate_model"));
    public static final Registry<ClimateModelType<?>> REGISTRY = new RegistryBuilder(KEY).sync(true).create();
    public static final DeferredRegister<ClimateModelType<?>> TYPES = DeferredRegister.create(KEY, (String)"tfc");
    public static final Id<OverworldClimateModel> OVERWORLD = ClimateModels.register("overworld", OverworldClimateModel.STREAM_CODEC);
    public static final Id<BiomeBasedClimateModel> BIOME_BASED = ClimateModels.register("biome_based", BiomeBasedClimateModel.STREAM_CODEC);

    private static <T extends ClimateModel> Id<T> register(String id, StreamCodec<ByteBuf, T> codec) {
        return new Id(TYPES.register(id, () -> new ClimateModelType(codec)));
    }

    public record Id<T extends ClimateModel>(DeferredHolder<ClimateModelType<?>, ClimateModelType<T>> holder) implements RegistryHolder<ClimateModelType<?>, ClimateModelType<T>>
    {
    }
}

