/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public record ClimateRange(int minHydration, int maxHydration, int hydrationWiggleRange, float minTemperature, float maxTemperature, float temperatureWiggleRange) {
    public static final Codec<ClimateRange> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("min_hydration", (Object)0).forGetter(c -> c.minHydration), (App)Codec.INT.optionalFieldOf("max_hydration", (Object)100).forGetter(c -> c.maxHydration), (App)Codec.INT.optionalFieldOf("hydration_wiggle_range", (Object)0).forGetter(c -> c.hydrationWiggleRange), (App)Codec.FLOAT.optionalFieldOf("min_temperature", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(c -> Float.valueOf(c.minTemperature)), (App)Codec.FLOAT.optionalFieldOf("max_temperature", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(c -> Float.valueOf(c.maxTemperature)), (App)Codec.FLOAT.optionalFieldOf("temperature_wiggle_range", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.temperatureWiggleRange))).apply((Applicative)i, ClimateRange::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClimateRange> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, c -> c.minHydration, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.maxHydration, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.hydrationWiggleRange, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.minTemperature), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.maxTemperature), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.temperatureWiggleRange), ClimateRange::new);
    public static final DataManager<ClimateRange> MANAGER = new DataManager<ClimateRange>(Helpers.identifier("climate_range"), CODEC, STREAM_CODEC);
    public static final ClimateRange NOOP = new ClimateRange(0, 100, 0, -100.0f, 100.0f, 0.0f);

    public int getMinHydration(boolean allowWiggle) {
        return allowWiggle ? this.minHydration - this.hydrationWiggleRange : this.minHydration;
    }

    public int getMaxHydration(boolean allowWiggle) {
        return allowWiggle ? this.maxHydration + this.hydrationWiggleRange : this.maxHydration;
    }

    public float getMinTemperature(boolean allowWiggle) {
        return allowWiggle ? this.minTemperature - this.temperatureWiggleRange : this.minTemperature;
    }

    public float getMaxTemperature(boolean allowWiggle) {
        return allowWiggle ? this.maxTemperature + this.temperatureWiggleRange : this.maxTemperature;
    }

    public Result checkHydration(int hydration, boolean allowWiggle) {
        Result result = this.check(hydration, this.minHydration, this.maxHydration, this.hydrationWiggleRange, allowWiggle);
        return this.check(hydration, this.minHydration, this.maxHydration, this.hydrationWiggleRange, allowWiggle);
    }

    public Result checkTemperature(float temperature, boolean allowWiggle) {
        Result result = this.check(temperature, this.minTemperature, this.maxTemperature, this.temperatureWiggleRange, allowWiggle);
        return this.check(temperature, this.minTemperature, this.maxTemperature, this.temperatureWiggleRange, allowWiggle);
    }

    public boolean checkBoth(int hydration, float temperature, boolean allowWiggle) {
        return this.checkHydration(hydration, allowWiggle) == Result.VALID && this.checkTemperature(temperature, allowWiggle) == Result.VALID;
    }

    @NotNull
    private Result check(float value, float min, float max, float range, boolean allowRange) {
        if (allowRange) {
            min -= range;
            max += range;
        }
        if (value < min) {
            return Result.LOW;
        }
        if (value > max) {
            return Result.HIGH;
        }
        return Result.VALID;
    }

    public static enum Result {
        LOW,
        VALID,
        HIGH;

    }

    public static final class Builder {
        int minHydration = 0;
        int maxHydration = 100;
        int hydrationWiggleRange = 0;
        float minTemperature = Float.NEGATIVE_INFINITY;
        float maxTemperature = Float.POSITIVE_INFINITY;
        float temperatureWiggleRange = 0.0f;

        public Builder minHydration(int min) {
            return this.hydration(min, 100);
        }

        public Builder maxHydration(int max) {
            return this.hydration(0, max);
        }

        public Builder hydration(int min, int max) {
            return this.hydration(min, max, 0);
        }

        public Builder hydration(int min, int max, int range) {
            this.minHydration = min;
            this.maxHydration = max;
            this.hydrationWiggleRange = range;
            return this;
        }

        public Builder minTemperature(float min) {
            return this.temperature(min, Float.POSITIVE_INFINITY);
        }

        public Builder maxTemperature(float max) {
            return this.temperature(Float.NEGATIVE_INFINITY, max);
        }

        public Builder temperature(float min, float max) {
            return this.temperature(min, max, 0.0f);
        }

        public Builder temperature(float min, float max, float range) {
            this.minTemperature = min;
            this.maxTemperature = max;
            this.temperatureWiggleRange = range;
            return this;
        }

        public ClimateRange build() {
            return new ClimateRange(this.minHydration, this.maxHydration, this.hydrationWiggleRange, this.minTemperature, this.maxTemperature, this.temperatureWiggleRange);
        }
    }
}

