/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.climate.ClimateModelType;
import net.dries007.tfc.util.climate.ClimateModels;
import net.dries007.tfc.util.tracker.WeatherHelpers;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class OverworldClimateModel
implements ClimateModel {
    public static final float LAVA_LEVEL_TEMPERATURE = 15.0f;
    public static final float SEA_LEVEL = 63.0f;
    public static final float DEPTH_LEVEL = -64.0f;
    public static final int FOGGY_DAY_RARITY = 10;
    public static final float FOGGY_RAINFALL_MINIMUM = 150.0f;
    public static final float FOGGY_RAINFALL_PEAK = 300.0f;
    public static final StreamCodec<ByteBuf, OverworldClimateModel> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, c -> c.climateSeed, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.temperatureScale), OverworldClimateModel::new);
    private static final long RAIN_LENGTH_SALT = 8917234598231321L;
    private static final long RAIN_INTENSITY_SALT = 9797234798136713L;
    private static final long RAIN_SEGMENT_LENGTH = 66000L;
    private static final float AVERAGE_RAINFALL_INTENSITY = 0.27272728f;
    private static final float MILLIMETERS_RAIN_EVAPORATED_PER_TICK = 2.5E-4f;
    protected final long climateSeed;
    protected final float temperatureScale;

    @Deprecated
    @Nullable
    public static OverworldClimateModel getIfPresent(Object maybeLevel) {
        ClimateModel model;
        Level unsafeLevel = Helpers.getUnsafeLevel(maybeLevel);
        if (unsafeLevel != null && (model = Climate.get(unsafeLevel)) instanceof OverworldClimateModel) {
            OverworldClimateModel overworldClimateModel = (OverworldClimateModel)model;
            return overworldClimateModel;
        }
        return null;
    }

    public OverworldClimateModel(ServerLevel level, ChunkGeneratorExtension extension) {
        this(LinearCongruentialGenerator.next((long)level.getSeed(), (long)719283741234L), extension.settings().temperatureScale());
    }

    protected OverworldClimateModel(long climateSeed, float temperatureScale) {
        this.climateSeed = climateSeed;
        this.temperatureScale = temperatureScale;
    }

    @Override
    public ClimateModelType<?> type() {
        return (ClimateModelType)ClimateModels.OVERWORLD.get();
    }

    @Override
    public float hemisphereScale() {
        return this.temperatureScale;
    }

    @Override
    public float getAverageTemperature(LevelReader level, BlockPos pos) {
        return Helpers.adjustAverageTemperatureByElevation(pos.getY(), ChunkData.get(level, pos).getAverageSeaLevelTemp(pos), 63.0f);
    }

    @Override
    public float getTemperature(LevelReader level, BlockPos pos, long calendarTicks, int daysInMonth) {
        ChunkData data = ChunkData.get(level, pos);
        Month currentMonth = ICalendar.getMonthOfYear(calendarTicks, daysInMonth);
        float delta = ICalendar.getFractionOfMonth(calendarTicks, daysInMonth);
        float monthFactor = Mth.lerp((float)delta, (float)currentMonth.getTemperatureModifier(), (float)currentMonth.next().getTemperatureModifier());
        float monthTemperature = this.calculateMonthlyTemperature(pos.getZ(), monthFactor);
        float dailyTemperature = this.calculateDailyTemperature(calendarTicks, daysInMonth, pos.getZ());
        return this.adjustTemperatureByElevation(pos.getY(), data.getAverageSeaLevelTemp(pos), monthTemperature, dailyTemperature);
    }

    @Override
    public float getAverageRainfall(LevelReader level, BlockPos pos) {
        return ChunkData.get(level, pos).getRainfall(pos);
    }

    @Override
    public float getRainfallVariance(LevelReader level, BlockPos pos) {
        return ChunkData.get(level, pos).getRainVariance(pos);
    }

    @Override
    public float getRainfall(LevelReader level, BlockPos pos, long calendarTicks, int daysInMonth) {
        ChunkData data = ChunkData.get(level, pos);
        float rainVariance = data.getRainVariance(pos);
        float rainAverage = data.getRainfall(pos);
        float fractionOfYear = ICalendar.getFractionOfYear(calendarTicks, daysInMonth);
        return rainVariance == 0.0f ? rainAverage : Helpers.triangle(rainVariance * rainAverage, rainAverage, 1.0f, fractionOfYear + 0.75f);
    }

    @Override
    public float getBaseGroundwater(LevelReader level, BlockPos pos) {
        return ChunkData.get(level, pos).getBaseGroundwater(pos);
    }

    @Override
    public float getAverageGroundwater(LevelReader level, BlockPos pos) {
        ChunkData data = ChunkData.get(level, pos);
        return Math.clamp(data.getBaseGroundwater(pos) + data.getRainfall(pos), 0.0f, 500.0f);
    }

    @Override
    public float getGroundwater(LevelReader level, BlockPos pos, long calendarTicks, int daysInMonth) {
        float baseGroundwater = this.getBaseGroundwater(level, pos);
        float monthlyRainfall = this.getRainfall(level, pos, calendarTicks, daysInMonth);
        return Math.clamp(baseGroundwater + monthlyRainfall, 0.0f, 1000.0f);
    }

    @Override
    public float getRain(long calendarTicks) {
        long segmentId = Math.floorDiv(calendarTicks, 66000L);
        long segmentLeft = segmentId * 66000L;
        RandomSource nextSegment = this.seededRandom(segmentId + 1L, 8917234598231321L);
        int nextLength = nextSegment.nextIntBetweenInclusive(12000, 24000);
        int nextLeft = (int)(nextSegment.nextFloat() * (float)(54000L - (long)nextLength));
        int boundaryRight = Math.min(0, 12000 - nextLeft);
        RandomSource segment = this.seededRandom(segmentId, 8917234598231321L);
        int length = segment.nextIntBetweenInclusive(12000, 24000);
        int left = (int)(segment.nextFloat() * (float)(66000L - (long)boundaryRight - (long)nextLength));
        if (calendarTicks < segmentLeft + (long)left || calendarTicks > segmentLeft + (long)left + (long)length) {
            return -1.0f;
        }
        RandomSource intensity = this.seededRandom(segmentId, 9797234798136713L);
        int halfLength = length / 2;
        float rainIntensity = intensity.nextFloat();
        float timeIntensity = 1.0f - (float)Math.abs(segmentLeft + (long)left + (long)halfLength - calendarTicks) / (float)halfLength;
        return 0.5f * (rainIntensity + timeIntensity);
    }

    private Pair<Long, Long> getDeltaRainInMillimeters(Level level, BlockPos pos, long fromTick, long toTick, float rainfall, int calendarDaysInMonth) {
        long toTickInRain;
        int segmentId = (int)Math.floorDiv(fromTick, 66000L);
        long segmentLeft = (long)segmentId * 66000L;
        RandomSource nextSegment = this.seededRandom(segmentId + 1, 8917234598231321L);
        int nextLength = nextSegment.nextIntBetweenInclusive(12000, 24000);
        int nextLeft = (int)(nextSegment.nextFloat() * (float)(54000L - (long)nextLength));
        int boundaryRight = Math.min(0, 12000 - nextLeft);
        RandomSource segment = this.seededRandom(segmentId, 8917234598231321L);
        int length = segment.nextIntBetweenInclusive(12000, 24000);
        int left = (int)(segment.nextFloat() * (float)(66000L - (long)boundaryRight - (long)nextLength));
        if (toTick < segmentLeft + (long)left || fromTick > segmentLeft + (long)left + (long)length) {
            return new Pair((Object)0L, (Object)(toTick - fromTick));
        }
        RandomSource intensity = this.seededRandom(segmentId, 9797234798136713L);
        int halfLength = length / 2;
        float rainIntensity = intensity.nextFloat();
        float rainfallFactor = Mth.clampedMap((float)rainfall, (float)0.0f, (float)500.0f, (float)1.0f, (float)0.0f);
        float requiredTimeIntensity = (rainfallFactor - rainIntensity * 0.5f) * 2.0f;
        if (requiredTimeIntensity < 0.0f) {
            requiredTimeIntensity = 0.0f;
        }
        long trueLeft = (long)((float)(segmentLeft + (long)left + (long)halfLength) - (1.0f - requiredTimeIntensity) * (float)halfLength);
        long trueRight = (long)((float)(segmentLeft + (long)left + (long)halfLength) + (1.0f - requiredTimeIntensity) * (float)halfLength);
        if (toTick < trueLeft || fromTick > trueRight) {
            return new Pair((Object)0L, (Object)(toTick - fromTick));
        }
        long fromTickInRain = Math.max(fromTick, trueLeft);
        if (this.getTemperature((LevelReader)level, pos, fromTickInRain, toTickInRain = Math.min(toTick, trueRight), calendarDaysInMonth) < 0.0f) {
            return new Pair((Object)0L, (Object)(toTick - fromTick));
        }
        return new Pair((Object)(toTickInRain - fromTickInRain), (Object)(toTick - fromTick - (toTickInRain - fromTickInRain)));
    }

    @Override
    public float getDeltaRainInMillimeters(Level level, BlockPos pos, long fromTick, long toTick, float rainfall, long calendarTicksInYear, int calendarDaysInMonth) {
        int segmentStart = (int)Math.floorDiv(fromTick, 66000L);
        int segmentEnd = (int)Math.floorDiv(toTick, 66000L);
        long totalTicks = toTick - fromTick;
        long calendarTicksInMonth = calendarTicksInYear / 12L;
        if (totalTicks > calendarTicksInMonth) {
            toTick = fromTick - calendarTicksInMonth;
        }
        long ticksRainingSum = 0L;
        long ticksNotRainingSum = 0L;
        for (int segmentId = segmentStart; segmentId < segmentEnd - 1; ++segmentId) {
            Pair<Long, Long> result = this.getDeltaRainInMillimeters(level, pos, (long)segmentId * 66000L, (long)(segmentId + 1) * 66000L, rainfall, calendarDaysInMonth);
            ticksRainingSum += ((Long)result.getFirst()).longValue();
            ticksNotRainingSum += ((Long)result.getSecond()).longValue();
        }
        long finalPartialRainSegmentStart = Math.max((long)segmentEnd * 66000L, fromTick);
        Pair<Long, Long> result = this.getDeltaRainInMillimeters(level, pos, finalPartialRainSegmentStart, toTick, rainfall, calendarDaysInMonth);
        double rainPerRainTickInMillimeters = 500.0f / (0.27272728f * (float)calendarTicksInYear);
        float deltaHydration = (float)(rainPerRainTickInMillimeters * (double)(ticksRainingSum += ((Long)result.getFirst()).longValue()));
        float dehydrationFactor = Mth.clampedMap((float)rainfall, (float)0.0f, (float)500.0f, (float)2.0f, (float)0.5f);
        float deltaDehydration = (float)(ticksNotRainingSum += ((Long)result.getSecond()).longValue()) * 2.5E-4f * dehydrationFactor;
        return deltaHydration - deltaDehydration;
    }

    @Override
    public boolean getThunder(long calendarTicks) {
        int length;
        RandomSource segment;
        int left;
        long salt = 9871293851234123L;
        int segmentLength = 105600;
        long segmentId = Math.floorDiv(calendarTicks, 105600);
        long segmentLeft = segmentId * 105600L;
        return calendarTicks >= segmentLeft + (long)(left = (segment = this.seededRandom(segmentId, 9871293851234123L)).nextInt(105600 - (length = segment.nextIntBetweenInclusive(3600, 15600)))) && calendarTicks <= segmentLeft + (long)left + (long)length;
    }

    @Override
    public boolean supportsRain() {
        return true;
    }

    @Override
    public float getFog(LevelReader level, BlockPos pos) {
        ICalendar calendar = Calendars.get(level);
        RandomSource random = this.seededRandom(calendar.getTotalDays(), 129341623413L);
        if (random.nextInt(10) != 0) {
            return 0.0f;
        }
        float fogModifier = random.nextFloat();
        float hourOfDay = 24.0f * calendar.getCalendarFractionOfDay();
        float scaledTime = 4.0f <= hourOfDay && hourOfDay < 6.0f ? Mth.map((float)hourOfDay, (float)4.0f, (float)6.0f, (float)0.0f, (float)1.0f) : (6.0f <= hourOfDay && hourOfDay < 10.0f ? 1.0f : (10.0f <= hourOfDay && hourOfDay < 12.0f ? Mth.map((float)hourOfDay, (float)10.0f, (float)12.0f, (float)1.0f, (float)0.0f) : 0.0f));
        float rainfall = this.getRainfall(level, pos);
        float rainfallModifier = Mth.clampedMap((float)rainfall, (float)150.0f, (float)300.0f, (float)0.0f, (float)1.0f);
        float skylightModifier = Mth.clampedMap((float)level.getBrightness(LightLayer.SKY, pos), (float)0.0f, (float)10.0f, (float)0.0f, (float)1.0f);
        return Helpers.easeInOutCubic(scaledTime) * fogModifier * rainfallModifier * skylightModifier;
    }

    @Override
    public Vec2 getWind(Level level, BlockPos pos, long calendarTicks, int daysInMonth) {
        int y = pos.getY();
        if ((float)y < 57.0f) {
            return Vec2.ZERO;
        }
        RandomSource random = this.seededRandom(ICalendar.getTotalCalendarDays(calendarTicks), 129341623413L);
        boolean isRaining = WeatherHelpers.isPrecipitating(this.getRain(calendarTicks), this.getRainfall((LevelReader)level, pos, calendarTicks, daysInMonth));
        Holder biome = level.getBiome(pos);
        float intensity = (float)random.nextGaussian() * 0.3f + 0.45f;
        if ((intensity *= isRaining ? 0.35f : 0.25f) > 0.23f) {
            intensity = random.nextFloat() * 0.75f + 0.25f;
        }
        intensity += Mth.clamp((float)Mth.clampedMap((float)y, (float)63.0f, (float)191.0f, (float)0.0f, (float)0.25f), (float)0.0f, (float)1.0f);
        intensity = Mth.clamp((float)intensity, (float)0.0f, (float)1.0f);
        if (biome.is(TFCTags.Biomes.HAS_PREDICTABLE_WINDS)) {
            boolean oddBand;
            boolean isDay = level.getDayTime() % 24000L < 12000L;
            int windScale = TFCConfig.SERVER.oceanWindScale.get();
            boolean bl = pos.getZ() < 0 ? pos.getZ() % (windScale * 2) < windScale : (oddBand = pos.getZ() % (windScale * 2) > windScale);
            float angle = isDay && oddBand ? 0.7853982f : (isDay ? 5.4977875f : (oddBand ? 3.926991f : 2.3561945f));
            intensity = Math.max(intensity, 0.08f);
            return new Vec2(Mth.cos((float)(angle += random.nextFloat() * 0.2f - 0.1f)), Mth.sin((float)angle)).scale(intensity);
        }
        float angle = random.nextFloat() * ((float)Math.PI * 2);
        return new Vec2(Mth.cos((float)angle) * intensity, Mth.sin((float)angle) * intensity);
    }

    public float getAverageMonthlyTemperature(int z, int y, float averageTemperature, float monthFactor, boolean ignoreHemispheres) {
        if (ignoreHemispheres && !SolarCalculator.getInNorthernHemisphere(z, this.hemisphereScale())) {
            monthFactor = -monthFactor;
        }
        float monthlyTemperature = this.calculateMonthlyTemperature(z, monthFactor);
        return this.adjustTemperatureByElevation(y, averageTemperature, monthlyTemperature, 0.0f);
    }

    protected float adjustTemperatureByElevation(int y, float averageTemperature, float monthTemperature, float dailyTemperature) {
        if ((float)y > 63.0f) {
            float averageElevationTemperature = Helpers.adjustAverageTemperatureByElevation(y, averageTemperature, 63.0f);
            return averageElevationTemperature + monthTemperature + dailyTemperature;
        }
        if (y > 0) {
            float monthInfluence = Helpers.inverseLerp(y, 0.0f, 63.0f);
            float dailyInfluence = Mth.clamp((float)(monthInfluence * 3.0f - 2.0f), (float)0.0f, (float)1.0f);
            return averageTemperature + Mth.lerp((float)monthInfluence, (float)0.0f, (float)monthTemperature) + Mth.lerp((float)dailyInfluence, (float)0.0f, (float)dailyTemperature);
        }
        float depthInfluence = Helpers.inverseLerp(y, -64.0f, 0.0f);
        return Mth.lerp((float)depthInfluence, (float)15.0f, (float)averageTemperature);
    }

    protected float calculateMonthlyTemperature(int z, float monthTemperatureModifier) {
        return monthTemperatureModifier * (this.temperatureScale == 0.0f ? 0.0f : Helpers.triangle(-18.0f, 0.0f, 1.0f / (4.0f * this.temperatureScale), (float)z - this.temperatureScale / 2.0f));
    }

    protected float calculateDailyTemperature(long calendarTime, long daysInMonth, int z) {
        int sunBasedDayTime = SolarCalculator.getSunBasedDayTime(z, this.hemisphereScale(), ICalendar.getFractionOfYear(calendarTime, daysInMonth), ICalendar.getFractionOfDay(calendarTime));
        float fractionOfDay = (float)sunBasedDayTime / 24000.0f;
        float hourModifier = fractionOfDay < 0.5f ? Mth.map((float)fractionOfDay, (float)0.0f, (float)0.5f, (float)-1.0f, (float)1.0f) : Mth.map((float)fractionOfDay, (float)0.5f, (float)1.0f, (float)1.0f, (float)-1.0f);
        long day = ICalendar.getTotalCalendarDays(calendarTime);
        RandomSource random = this.seededRandom(day, 1986239412341L);
        return (random.nextFloat() - random.nextFloat() + 0.3f * hourModifier) * 3.0f;
    }

    protected RandomSource seededRandom(long day, long salt) {
        return new XoroshiroRandomSource(LinearCongruentialGenerator.next((long)day, (long)this.climateSeed), salt);
    }
}

