/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public record Deposit(Ingredient ingredient, ResourceKey<LootTable> lootTable, List<ResourceLocation> modelStages) implements IRecipePredicate<ItemStack>
{
    public static final Codec<Deposit> CODEC = RecordCodecBuilder.create(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(c -> c.lootTable), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("model_stages", List.of()).forGetter(c -> c.modelStages)).apply((Applicative)i, Deposit::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Deposit> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE), c -> c.lootTable, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), c -> c.modelStages, Deposit::new);
    public static final DataManager<Deposit> MANAGER = new DataManager<Deposit>(Helpers.identifier("deposit"), CODEC, STREAM_CODEC);
    public static final IndirectHashCollection<Item, Deposit> CACHE = IndirectHashCollection.create(r -> RecipeHelpers.itemKeys(r.ingredient), MANAGER::getValues);

    @Nullable
    public static Deposit get(@Nullable ItemStack stack) {
        return stack == null ? null : RecipeHelpers.getRecipe(CACHE, stack, stack.getItem());
    }

    @Override
    public boolean matches(ItemStack input) {
        return this.ingredient.test(input);
    }
}

