/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public record Drinkable(FluidIngredient ingredient, float consumeChance, boolean mayDrinkWhenFull, FoodData food, List<Effect> effects) {
    public static final Codec<Drinkable> CODEC = RecordCodecBuilder.create(i -> i.group((App)FluidIngredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)Codec.FLOAT.optionalFieldOf("consume_chance", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.consumeChance)), (App)Codec.BOOL.optionalFieldOf("may_drink_when_full", (Object)false).forGetter(c -> c.mayDrinkWhenFull), (App)FoodData.MAP_CODEC.forGetter(c -> c.food), (App)RecordCodecBuilder.create(j -> j.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(c -> c.type), (App)Codec.INT.fieldOf("duration").forGetter(c -> c.duration), (App)Codec.INT.fieldOf("amplifier").forGetter(c -> c.amplifier), (App)Codec.FLOAT.fieldOf("chance").forGetter(c -> Float.valueOf(c.chance))).apply((Applicative)j, Effect::new)).listOf().optionalFieldOf("effects", List.of()).forGetter(c -> c.effects)).apply((Applicative)i, Drinkable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Drinkable> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidIngredient.STREAM_CODEC, c -> c.ingredient, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.consumeChance), (StreamCodec)ByteBufCodecs.BOOL, c -> c.mayDrinkWhenFull, FoodData.STREAM_CODEC, c -> c.food, (StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), c -> c.type, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.duration, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.amplifier, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.chance), Effect::new).apply(ByteBufCodecs.list()), c -> c.effects, Drinkable::new);
    public static final DataManager<Drinkable> MANAGER = new DataManager<Drinkable>(Helpers.identifier("drinkable"), CODEC, STREAM_CODEC);
    public static final IndirectHashCollection<Fluid, Drinkable> CACHE = IndirectHashCollection.create(c -> RecipeHelpers.fluidKeys(c.ingredient), MANAGER::getValues);
    private static final int HAND_DRINK_MB = 25;

    @Nullable
    public static Drinkable get(Fluid fluid) {
        for (Drinkable drinkable : CACHE.getAll(fluid)) {
            if (!drinkable.ingredient.test(new FluidStack(fluid, 1))) continue;
            return drinkable;
        }
        return null;
    }

    public static InteractionResult attemptDrink(Level level, Player player, boolean doDrink) {
        BlockHitResult hit = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hit.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = hit.getBlockPos();
            BlockState state = level.getBlockState(pos);
            Fluid fluid = state.getFluidState().getType();
            IPlayerInfo info = IPlayerInfo.get(player);
            if (info.canDrink()) {
                Drinkable drinkable = Drinkable.get(fluid);
                if (drinkable != null && (info.getThirst() < 100.0f || drinkable.food.water() == 0.0f || drinkable.mayDrinkWhenFull)) {
                    if (!level.isClientSide && doDrink) {
                        Drinkable.doDrink(level, player, state, pos, info, drinkable);
                    }
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else {
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    private static void doDrink(Level level, Player player, BlockState state, BlockPos pos, IPlayerInfo info, Drinkable drinkable) {
        assert (!level.isClientSide);
        info.onDrink();
        level.playSound(null, pos, SoundEvents.GENERIC_DRINK, SoundSource.PLAYERS, 1.0f, 1.0f);
        drinkable.onDrink(player, 25);
        if (drinkable.consumeChance > 0.0f && drinkable.consumeChance > level.getRandom().nextFloat()) {
            BlockState emptyState;
            BlockState blockState = emptyState = FluidHelpers.isAirOrEmptyFluid(state) ? Blocks.AIR.defaultBlockState() : FluidHelpers.fillWithFluid(state, Fluids.EMPTY);
            if (emptyState != null) {
                level.setBlock(pos, emptyState, 3);
            }
        }
    }

    public void onDrink(Player player, int mB) {
        assert (!player.level().isClientSide);
        float multiplier = (float)mB / 25.0f;
        RandomSource random = player.getRandom();
        IPlayerInfo info = IPlayerInfo.get(player);
        info.eat(this.food.mul(multiplier));
        for (Effect effect : this.effects) {
            if (!(1.0 - Math.pow(1.0f - effect.chance(), multiplier) > (double)random.nextFloat())) continue;
            player.addEffect(new MobEffectInstance(effect.type(), effect.duration(), effect.amplifier(), false, false, true));
        }
        player.setSprinting(false);
    }

    public record Effect(Holder<MobEffect> type, int duration, int amplifier, float chance) {
    }
}

