/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.IdentityHashMap;
import java.util.Map;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.DataManager;
import net.dries007.tfc.world.Codecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public record FluidHeat(Fluid fluid, float meltTemperature, float specificHeatCapacity) {
    public static final Codec<FluidHeat> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codecs.FLUID.fieldOf("fluid").forGetter(c -> c.fluid), (App)Codec.FLOAT.fieldOf("melt_temperature").forGetter(c -> Float.valueOf(c.meltTemperature)), (App)Codec.FLOAT.fieldOf("specific_heat_capacity").forGetter(c -> Float.valueOf(c.specificHeatCapacity))).apply((Applicative)i, FluidHeat::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidHeat> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.FLUID), c -> c.fluid, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.meltTemperature), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.specificHeatCapacity), FluidHeat::new);
    public static final ResourceLocation UNKNOWN_ID = Helpers.identifier("unknown");
    public static final DataManager<FluidHeat> MANAGER = new DataManager<FluidHeat>(Helpers.identifier("fluid_heat"), CODEC, STREAM_CODEC);
    private static final Map<Fluid, FluidHeat> BY_FLUID = new IdentityHashMap<Fluid, FluidHeat>();

    public FluidHeat(Fluid fluid) {
        this(fluid, 0.0f, 0.0f);
    }

    @Nullable
    public static FluidHeat get(Fluid fluid) {
        return BY_FLUID.get(fluid);
    }

    public static FluidHeat getOrUnknown(FluidStack fluid) {
        return BY_FLUID.getOrDefault(fluid.getFluid(), FluidHeat.unknown());
    }

    public static FluidHeat unknown() {
        return MANAGER.getOrThrow(UNKNOWN_ID);
    }

    public static void updateCache() {
        FluidHeat.unknown();
        BY_FLUID.clear();
        for (FluidHeat heat : MANAGER.getValues()) {
            BY_FLUID.put(heat.fluid(), heat);
        }
    }

    public float heatCapacity(float mB) {
        return this.specificHeatCapacity() * mB;
    }
}

