/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public record LampFuel(FluidIngredient fluid, BlockIngredient lamps, int burnRate) {
    public static final Codec<LampFuel> CODEC = RecordCodecBuilder.create(i -> i.group((App)FluidIngredient.CODEC.fieldOf("fluid").forGetter(c -> c.fluid), (App)BlockIngredient.CODEC.fieldOf("lamps").forGetter(c -> c.lamps), (App)Codec.INT.fieldOf("burn_rate").forGetter(c -> c.burnRate)).apply((Applicative)i, LampFuel::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LampFuel> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidIngredient.STREAM_CODEC, c -> c.fluid, BlockIngredient.STREAM_CODEC, c -> c.lamps, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.burnRate, LampFuel::new);
    public static final DataManager<LampFuel> MANAGER = new DataManager<LampFuel>(Helpers.identifier("lamp_fuel"), CODEC, STREAM_CODEC);
    public static final IndirectHashCollection<Fluid, LampFuel> CACHE = IndirectHashCollection.create(r -> RecipeHelpers.fluidKeys(r.fluid), MANAGER::getValues);

    @Nullable
    public static LampFuel get(Fluid fluid, BlockState state) {
        for (LampFuel fuel : CACHE.getAll(fluid)) {
            if (!fuel.fluid.test(new FluidStack(fluid, 1)) || !fuel.lamps.test(state)) continue;
            return fuel;
        }
        return null;
    }
}

