/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.events;

import com.mojang.datafixers.util.Either;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public final class AnimalProductEvent
extends Event
implements ICancellableEvent {
    private final Level level;
    private final BlockPos pos;
    private final TFCAnimalProperties animalProperties;
    @Nullable
    private final Player player;
    private final ItemStack tool;
    private Either<ItemStack, FluidStack> product;
    private int uses;

    public static boolean produce(Level level, BlockPos pos, TFCAnimalProperties entity, ItemStack product, ItemStack tool, int uses) {
        return AnimalProductEvent.produce(level, pos, null, entity, product, tool, uses);
    }

    public static boolean produce(Level level, BlockPos pos, @Nullable Player player, TFCAnimalProperties entity, ItemStack product, ItemStack tool, int uses) {
        AnimalProductEvent event = new AnimalProductEvent(level, pos, player, entity, product, tool, uses);
        if (!((AnimalProductEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            if (!level.isClientSide) {
                if (player != null) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)event.getProduct());
                } else {
                    Helpers.spawnItem(level, pos, event.getProduct());
                }
            }
            entity.addUses(event.getUses());
            return true;
        }
        return false;
    }

    public AnimalProductEvent(Level level, BlockPos pos, @Nullable Player player, TFCAnimalProperties entity, ItemStack product, ItemStack tool, int uses) {
        this(level, pos, player, entity, (Either<ItemStack, FluidStack>)Either.left((Object)product), tool, uses);
    }

    public AnimalProductEvent(Level level, BlockPos pos, @Nullable Player player, TFCAnimalProperties entity, FluidStack fluidProduct, ItemStack tool, int uses) {
        this(level, pos, player, entity, (Either<ItemStack, FluidStack>)Either.right((Object)fluidProduct), tool, uses);
    }

    private AnimalProductEvent(Level level, BlockPos pos, @Nullable Player player, TFCAnimalProperties entity, Either<ItemStack, FluidStack> product, ItemStack tool, int uses) {
        this.level = level;
        this.pos = pos;
        this.animalProperties = entity;
        this.player = player;
        this.tool = tool;
        this.product = product;
        this.uses = uses;
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public TFCAnimalProperties getAnimalProperties() {
        return this.animalProperties;
    }

    public Entity getEntity() {
        return this.getAnimalProperties().getEntity();
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getTool() {
        return this.tool;
    }

    public ItemStack getProduct() {
        return this.product.left().orElse(ItemStack.EMPTY);
    }

    public FluidStack getFluidProduct() {
        return this.product.right().orElse(FluidStack.EMPTY);
    }

    public void setProduct(ItemStack product) {
        this.product = Either.left((Object)product);
    }

    public void setProduct(FluidStack product) {
        this.product = Either.right((Object)product);
    }

    public int getUses() {
        return this.uses;
    }

    public void setUses(int uses) {
        this.uses = uses;
    }
}

