/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.loot;

import java.util.Set;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.loot.TFCLoot;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public enum NotPredatedCondition implements LootItemCondition
{
    INSTANCE;


    public LootItemConditionType getType() {
        return (LootItemConditionType)TFCLoot.NOT_PREDATED.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.ATTACKING_ENTITY);
    }

    public boolean test(LootContext context) {
        if (!context.hasParam(LootContextParams.ATTACKING_ENTITY)) {
            return true;
        }
        Entity killer = (Entity)context.getParam(LootContextParams.ATTACKING_ENTITY);
        return killer instanceof Player || !Helpers.isEntity(killer, TFCTags.Entities.HUNTS_LAND_PREY) && !Helpers.isEntity(killer, TFCTags.Entities.OCEAN_PREDATORS);
    }
}

