/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.loot;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.loot.AlwaysTrueCondition;
import net.dries007.tfc.util.loot.AnimalYieldProvider;
import net.dries007.tfc.util.loot.ApplyStackSizeFunction;
import net.dries007.tfc.util.loot.CopyFluidFunction;
import net.dries007.tfc.util.loot.CropYieldProvider;
import net.dries007.tfc.util.loot.IsBurntOutCondition;
import net.dries007.tfc.util.loot.IsIsolatedCondition;
import net.dries007.tfc.util.loot.IsMaleCondition;
import net.dries007.tfc.util.loot.IsSluiceCondition;
import net.dries007.tfc.util.loot.MinMaxProvider;
import net.dries007.tfc.util.loot.NotPredatedCondition;
import net.dries007.tfc.util.loot.RottenFunction;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TFCLoot {
    public static final DeferredRegister<LootItemConditionType> CONDITIONS = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"tfc");
    public static final DeferredRegister<LootNumberProviderType> NUMBER_PROVIDERS = DeferredRegister.create((ResourceKey)Registries.LOOT_NUMBER_PROVIDER_TYPE, (String)"tfc");
    public static final DeferredRegister<LootItemFunctionType<?>> LOOT_FUNCTIONS = DeferredRegister.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (String)"tfc");
    public static final LootContextParam<Boolean> ISOLATED = new LootContextParam(Helpers.identifier("isolated"));
    public static final LootContextParam<Boolean> BURNT_OUT = new LootContextParam(Helpers.identifier("burnt_out"));
    public static final LootContextParam<Boolean> SLUICE = new LootContextParam(Helpers.identifier("sluice"));
    public static final Id<LootItemConditionType> IS_ISOLATED = TFCLoot.lootCondition("is_isolated", (MapCodec<? extends LootItemCondition>)MapCodec.unit((Object)((Object)IsIsolatedCondition.INSTANCE)));
    public static final Id<LootItemConditionType> IS_BURNT_OUT = TFCLoot.lootCondition("is_burnt_out", (MapCodec<? extends LootItemCondition>)MapCodec.unit((Object)((Object)IsBurntOutCondition.INSTANCE)));
    public static final Id<LootItemConditionType> IS_SLUICE = TFCLoot.lootCondition("is_sluice", (MapCodec<? extends LootItemCondition>)MapCodec.unit((Object)((Object)IsSluiceCondition.INSTANCE)));
    public static final Id<LootItemConditionType> IS_MALE = TFCLoot.lootCondition("is_male", (MapCodec<? extends LootItemCondition>)MapCodec.unit((Object)((Object)IsMaleCondition.INSTANCE)));
    public static final Id<LootItemConditionType> ALWAYS_TRUE = TFCLoot.lootCondition("always_true", (MapCodec<? extends LootItemCondition>)MapCodec.unit((Object)((Object)AlwaysTrueCondition.INSTANCE)));
    public static final Id<LootItemConditionType> NOT_PREDATED = TFCLoot.lootCondition("not_predated", (MapCodec<? extends LootItemCondition>)MapCodec.unit((Object)((Object)NotPredatedCondition.INSTANCE)));
    public static final Id<LootNumberProviderType> CROP_YIELD = TFCLoot.numberProvider("crop_yield_uniform", MinMaxProvider.codec(CropYieldProvider::new));
    public static final Id<LootNumberProviderType> ANIMAL_YIELD = TFCLoot.numberProvider("animal_yield", MinMaxProvider.codec(AnimalYieldProvider::new));
    public static final LootFunctionId<CopyFluidFunction> COPY_FLUID = TFCLoot.lootFunction("copy_fluid", CopyFluidFunction.CODEC);
    public static final LootFunctionId<RottenFunction> ROTTEN = TFCLoot.lootFunction("rotten", RottenFunction.CODEC);
    public static final LootFunctionId<ApplyStackSizeFunction> APPLY_STACK_SIZE = TFCLoot.lootFunction("apply_stack_size", ApplyStackSizeFunction.CODEC);

    private static <T extends LootItemFunction> LootFunctionId<T> lootFunction(String id, MapCodec<T> codec) {
        return new LootFunctionId(LOOT_FUNCTIONS.register(id, () -> new LootItemFunctionType(codec)));
    }

    private static Id<LootItemConditionType> lootCondition(String id, MapCodec<? extends LootItemCondition> codec) {
        return new Id<LootItemConditionType>(CONDITIONS.register(id, () -> new LootItemConditionType(codec)));
    }

    private static Id<LootNumberProviderType> numberProvider(String id, MapCodec<? extends NumberProvider> codec) {
        return new Id<LootNumberProviderType>(NUMBER_PROVIDERS.register(id, () -> new LootNumberProviderType(codec)));
    }

    public record LootFunctionId<T extends LootItemFunction>(DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<T>> holder) implements RegistryHolder<LootItemFunctionType<?>, LootItemFunctionType<T>>
    {
    }

    public record Id<T>(DeferredHolder<T, T> holder) implements RegistryHolder<T, T>
    {
    }
}

