/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.rotation;

import java.util.EnumSet;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class AxleNode
extends Node {
    private static final int MAX_AXLE_LENGTH = 5;

    public AxleNode(BlockPos pos, EnumSet<Direction> connections) {
        super(pos, connections);
    }

    @Override
    public Rotation rotation(Rotation sourceRotation, Direction sourceDirection, Direction exitDirection) {
        if (sourceRotation instanceof AxleRotation) {
            AxleRotation axleRotation = (AxleRotation)sourceRotation;
            return new AxleRotation(sourceRotation, axleRotation.length + 1);
        }
        return new AxleRotation(sourceRotation, 1);
    }

    @Override
    public boolean update(long networkId, Direction sourceDirection, Rotation sourceRotation) {
        if (sourceRotation instanceof AxleRotation) {
            AxleRotation axleRotation = (AxleRotation)sourceRotation;
            if (axleRotation.length == 5) {
                this.onInvalidConnection();
                return false;
            }
        }
        return super.update(networkId, sourceDirection, sourceRotation);
    }

    protected void onInvalidConnection() {
    }

    record AxleRotation(Rotation from, int length) implements Rotation
    {
        @Override
        public float angle(float partialTick) {
            return this.from.angle(partialTick);
        }

        @Override
        public float speed() {
            return this.from.speed();
        }

        @Override
        public Direction direction() {
            return this.from.direction();
        }
    }
}

