/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.rotation;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.RotationAccess;
import net.dries007.tfc.util.rotation.RotationNetwork;
import net.dries007.tfc.util.rotation.SourceNode;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class RotationNetworkManager
implements RotationAccess {
    private final Long2ObjectMap<RotationNetwork> networks = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<Node> nodes = new Long2ObjectOpenHashMap();
    private long nextNetworkId = 0L;

    public static RotationNetworkManager get(Level level) {
        return WorldTracker.get(level).getRotationManager();
    }

    public boolean performAction(Node node, NetworkAction action) {
        return switch (action) {
            default -> throw new MatchException(null, null);
            case NetworkAction.ADD -> this.add(node);
            case NetworkAction.ADD_SOURCE -> this.addSource((SourceNode)node);
            case NetworkAction.UPDATE -> this.update(node);
            case NetworkAction.REMOVE -> {
                this.remove(node);
                yield true;
            }
        };
    }

    public boolean addSource(SourceNode sourceToAdd) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction direction : sourceToAdd.connections()) {
            cursor.setWithOffset((Vec3i)sourceToAdd.pos(), direction);
            @Nullable Node adjacent = this.getNode((BlockPos)cursor);
            Direction inverseDirection = direction.getOpposite();
            if (adjacent == null || adjacent.network() == -1L || !adjacent.connections().contains(inverseDirection)) continue;
            return false;
        }
        RotationNetwork network = new RotationNetwork(this.nextNetworkId, sourceToAdd);
        sourceToAdd.updateSource(this.nextNetworkId);
        network.updateAfterAdd(sourceToAdd, this);
        this.networks.put(this.nextNetworkId, (Object)network);
        ++this.nextNetworkId;
        this.nodes.put(sourceToAdd.posKey(), (Object)sourceToAdd);
        return true;
    }

    public boolean add(Node toAdd) {
        @Nullable RotationNetwork addedNetwork = null;
        for (RotationNetwork network : this.networks.values()) {
            switch (network.updateOnAdd(toAdd)) {
                case SUCCESS: {
                    assert (addedNetwork == null);
                    addedNetwork = network;
                    break;
                }
                case FAIL_NO_CONNECTION: {
                    break;
                }
                case FAIL_CONNECTED_TO_OTHER_NETWORK: {
                    assert (addedNetwork != null);
                    addedNetwork.removeNode(toAdd);
                    return false;
                }
                case FAIL_INVALID_CONNECTION: {
                    return false;
                }
            }
        }
        if (addedNetwork != null) {
            addedNetwork.updateAfterAdd(toAdd, this);
        } else {
            toAdd.remove();
        }
        this.nodes.put(toAdd.posKey(), (Object)toAdd);
        return true;
    }

    public boolean update(Node toUpdate) {
        long networkId = toUpdate.network();
        if (networkId != -1L) {
            RotationNetwork originNetwork = this.getNetwork(networkId);
            for (RotationNetwork network : this.networks.values()) {
                switch (network.updateOnAdd(toUpdate)) {
                    case SUCCESS: {
                        assert (network.networkId() == networkId);
                        break;
                    }
                    case FAIL_NO_CONNECTION: {
                        break;
                    }
                    case FAIL_CONNECTED_TO_OTHER_NETWORK: 
                    case FAIL_INVALID_CONNECTION: {
                        originNetwork.removeNode(toUpdate);
                        originNetwork.updateNetwork();
                        return false;
                    }
                }
            }
            originNetwork.updateAfterAdd(toUpdate, this);
            originNetwork.updateNetwork();
            return true;
        }
        return this.add(toUpdate);
    }

    public void remove(Node toRemove) {
        RotationNetwork network;
        this.nodes.remove(toRemove.posKey());
        long networkId = toRemove.network();
        if (networkId != -1L && (network = (RotationNetwork)this.networks.get(networkId)) != null) {
            if (network.isSource(toRemove)) {
                network.removeNetwork();
                this.networks.remove(networkId);
            } else {
                network.removeNode(toRemove);
                network.updateNetwork();
            }
        }
    }

    public void clear() {
        this.nodes.clear();
        this.networks.clear();
        this.nextNetworkId = 0L;
    }

    @Override
    @Nullable
    public Node getNode(BlockPos pos) {
        return (Node)this.nodes.get(pos.asLong());
    }

    public String toString() {
        return this.networks.values().stream().sorted(Comparator.comparingLong(RotationNetwork::networkId)).map(Object::toString).collect(Collectors.joining("\n"));
    }

    private RotationNetwork getNetwork(long networkId) {
        RotationNetwork network = (RotationNetwork)this.networks.get(networkId);
        if (network == null) {
            throw new IllegalStateException("Missing network for networkId = " + networkId);
        }
        return network;
    }
}

