/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.tooltip;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.GenderedRenderAnimal;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.prey.TFCOcelot;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.entities.aquatic.TFCSquid;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.Gender;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.horse.HorseProperties;
import net.dries007.tfc.common.entities.livestock.horse.TFCChestedHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.common.entities.misc.TFCFishingHook;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.entities.prey.TFCFrog;
import net.dries007.tfc.common.entities.prey.TFCRabbit;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.tooltip.EntityTooltip;
import net.dries007.tfc.util.tooltip.RegisterCallback;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public final class EntityTooltips {
    public static final EntityTooltip FROG = (level, entity, tooltip) -> {
        if (entity instanceof TFCFrog) {
            TFCFrog frog = (TFCFrog)entity;
            tooltip.accept(Helpers.translateEnum(frog.isMale() ? Gender.MALE : Gender.FEMALE));
            float familiarity = Math.max(0.0f, Math.min(1.0f, frog.getFamiliarity()));
            String familiarityPercent = String.format("%.2f", Float.valueOf(familiarity * 100.0f));
            tooltip.accept(Component.translatable((String)"tfc.jade.familiarity", (Object[])new Object[]{familiarityPercent}));
        }
    };
    public static final EntityTooltip ANIMAL = (level, entity, tooltip) -> {
        MammalProperties mammal;
        GenderedRenderAnimal animal;
        if (entity instanceof WildAnimal) {
            animal = (WildAnimal)entity;
            if (((WildAnimal)animal).displayMaleCharacteristics()) {
                tooltip.accept(Helpers.translateEnum(Gender.MALE));
            } else if (((WildAnimal)animal).displayFemaleCharacteristics()) {
                tooltip.accept(Helpers.translateEnum(Gender.FEMALE));
            }
            if (((WildAnimal)animal).isBaby()) {
                tooltip.accept(Component.translatable((String)"tfc.jade.juvenile"));
            }
        }
        if (entity instanceof TFCAnimalProperties) {
            animal = (TFCAnimalProperties)entity;
            MutableComponent line1 = Helpers.translateEnum(animal.getGender());
            if (animal.isFertilized()) {
                line1.append(", ").append((Component)Component.translatable((String)"tfc.tooltip.fertilized"));
            }
            float familiarity = Math.max(0.0f, Math.min(1.0f, animal.getFamiliarity()));
            String familiarityPercent = String.format("%.2f", Float.valueOf(familiarity * 100.0f));
            Age age = animal.getAgeType();
            ChatFormatting familiarityStyle = ChatFormatting.GRAY;
            if (familiarity >= animal.getAdultFamiliarityCap() && age != Age.CHILD) {
                familiarityStyle = ChatFormatting.RED;
            } else if ((double)familiarity >= TFCConfig.SERVER.familiarityDecayLimit.get()) {
                familiarityStyle = ChatFormatting.WHITE;
            }
            line1.append(", ").append((Component)Component.translatable((String)"tfc.jade.familiarity", (Object[])new Object[]{familiarityPercent}).withStyle(familiarityStyle));
            tooltip.accept(line1);
            tooltip.accept(Component.translatable((String)"tfc.jade.animal_size", (Object[])new Object[]{animal.getGeneticSize()}));
            if (animal.isReadyForAnimalProduct()) {
                tooltip.accept(animal.getProductReadyName().withStyle(ChatFormatting.GREEN));
            }
            if (animal.isReadyToMate()) {
                tooltip.accept(Component.translatable((String)"tfc.jade.can_mate"));
            }
            double usageRatio = animal.getUses() >= animal.getUsesToElderly() ? 0.99 : (double)((float)animal.getUses() / (float)animal.getUsesToElderly());
            switch (age) {
                case CHILD: {
                    tooltip.accept(Component.translatable((String)"tfc.jade.adulthood_progress", (Object[])new Object[]{Calendars.get((LevelReader)level).getTimeDelta(24000L * (long)animal.getDaysToAdulthood() + animal.getBirthTick() - Calendars.get((LevelReader)level).getTicks())}));
                    break;
                }
                case ADULT: {
                    tooltip.accept(Component.translatable((String)"tfc.jade.animal_wear", (Object[])new Object[]{String.format("%d%%", Math.min(100L, Math.round(100.0 * usageRatio)))}));
                    break;
                }
                case OLD: {
                    tooltip.accept(Component.translatable((String)"tfc.jade.old_animal"));
                }
            }
        }
        if (entity instanceof MammalProperties && (mammal = (MammalProperties)entity).getPregnantTime() > 0L) {
            tooltip.accept(Component.translatable((String)"tfc.tooltip.animal.pregnant", (Object[])new Object[]{entity.getName().getString()}));
            ICalendar calendar = Calendars.get((LevelReader)level);
            tooltip.accept(Component.translatable((String)"tfc.jade.gestation_time_left", (Object[])new Object[]{calendar.getTimeDelta(24000L * (mammal.getGestationDays() + mammal.getPregnantTime() - Calendars.get((LevelReader)level).getTotalDays()))}));
        }
        if (entity instanceof HorseProperties) {
            TFCChestedHorse chested;
            HorseProperties horse = (HorseProperties)entity;
            if (horse.getFamiliarity() >= 0.15f) {
                tooltip.accept(Component.translatable((String)"tfc.jade.may_ride_horse"));
            }
            if (entity instanceof TFCHorse) {
                TFCHorse tfcHorse = (TFCHorse)entity;
                tooltip.accept(Component.translatable((String)"tfc.jade.variant_and_markings", (Object[])new Object[]{Helpers.translateEnum(tfcHorse.getVariant(), "horse_variant"), Helpers.translateEnum(tfcHorse.getMarkings())}));
            }
            if (entity instanceof TFCChestedHorse && !(chested = (TFCChestedHorse)entity).getChestItem().isEmpty()) {
                MutableComponent component = chested.getChestItem().getHoverName().copy();
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)chested.getChestItem().getCapability(Capabilities.FluidHandler.ITEM);
                if (fluidHandler != null && !fluidHandler.getFluidInTank(0).isEmpty()) {
                    component.append(", ").append((Component)Tooltips.fluidUnitsOf(fluidHandler.getFluidInTank(0)));
                }
                tooltip.accept(component);
            }
        }
    };
    public static final EntityTooltip PACK_PREDATOR = (level, entity, tooltip) -> {
        if (entity instanceof PackPredator) {
            PackPredator predator = (PackPredator)entity;
            tooltip.accept(Component.translatable((String)"tfc.jade.pack_respect", (Object[])new Object[]{predator.getRespect()}));
            if (predator.isTamable()) {
                String familiarityPercent = String.format("%.2f", Float.valueOf(predator.getFamiliarity() * 100.0f));
                tooltip.accept(Component.translatable((String)"tfc.jade.familiarity", (Object[])new Object[]{familiarityPercent}));
            }
        }
    };
    public static final EntityTooltip OCELOT = (level, entity, tooltip) -> {
        if (entity instanceof TFCOcelot) {
            TFCOcelot ocelot = (TFCOcelot)entity;
            String familiarityPercent = String.format("%.2f", Float.valueOf(ocelot.getFamiliarity() * 100.0f));
            tooltip.accept(Component.translatable((String)"tfc.jade.familiarity", (Object[])new Object[]{familiarityPercent}));
        }
    };
    public static final EntityTooltip SQUID = (level, entity, tooltip) -> {
        if (entity instanceof TFCSquid) {
            TFCSquid squid = (TFCSquid)entity;
            tooltip.accept(Component.translatable((String)"tfc.jade.squid_size", (Object[])new Object[]{squid.getSize()}));
        }
    };
    public static final EntityTooltip FISH = (level, entity, tooltip) -> {
        if (entity instanceof AquaticMob) {
            AquaticMob aquatic = (AquaticMob)entity;
            if (aquatic.canSpawnIn((Fluid)TFCFluids.SALT_WATER.getSource())) {
                tooltip.accept(Component.translatable((String)"tfc.jade.saltwater"));
            }
            if (aquatic.canSpawnIn((Fluid)Fluids.WATER)) {
                tooltip.accept(Component.translatable((String)"tfc.jade.freshwater"));
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.NEEDS_LARGE_FISHING_BAIT)) {
                tooltip.accept(Component.translatable((String)"tfc.jade.large_bait"));
            }
        }
    };
    public static final EntityTooltip PREDATOR = (level, entity, tooltip) -> {
        if (entity instanceof Predator) {
            Predator predator = (Predator)entity;
            tooltip.accept(predator.isDiurnal() ? Component.translatable((String)"tfc.jade.diurnal") : Component.translatable((String)"tfc.jade.nocturnal"));
        }
    };
    public static final EntityTooltip RABBIT = (level, entity, tooltip) -> {
        if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            tooltip.accept(Helpers.translateEnum(rabbit.getVariant(), "rabbit_variant"));
        }
    };
    public static final EntityTooltip HOOK = (level, entity, tooltip) -> {
        if (entity instanceof TFCFishingHook) {
            TFCFishingHook hook = (TFCFishingHook)entity;
            if (hook.getHookedIn() != null) {
                tooltip.accept(Component.translatable((String)"tfc.jade.hooked", (Object[])new Object[]{hook.getHookedIn().getName()}));
            }
            if (!hook.getBait().isEmpty()) {
                tooltip.accept(Component.translatable((String)"tfc.jade.bait", (Object[])new Object[]{hook.getBait().getHoverName()}));
            }
        }
    };

    public static void register(RegisterCallback<EntityTooltip, Entity> registry) {
        registry.register("animal", ANIMAL, TFCAnimal.class);
        registry.register("horse", ANIMAL, TFCHorse.class);
        registry.register("chested_horse", ANIMAL, TFCChestedHorse.class);
        registry.register("rabbit", ANIMAL, TFCRabbit.class);
        registry.register("wild_animal", ANIMAL, WildAnimal.class);
        registry.register("frog", FROG, TFCFrog.class);
        registry.register("squid", SQUID, TFCSquid.class);
        registry.register("fish", FISH, WaterAnimal.class);
        registry.register("predator", PREDATOR, Predator.class);
        registry.register("pack_predator", PACK_PREDATOR, PackPredator.class);
        registry.register("ocelot", OCELOT, TFCOcelot.class);
        registry.register("rabbit", RABBIT, Rabbit.class);
        registry.register("fishing_hook", HOOK, TFCFishingHook.class);
    }
}

