/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.tooltip;

import net.dries007.tfc.config.TFCConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class Tooltips {
    public static MutableComponent fluidUnits(double mB) {
        return mB < 1.0 ? Tooltips.lessThanOneFluidUnits() : Tooltips.fluidUnits((int)Math.round(mB));
    }

    public static MutableComponent fluidUnits(int mB) {
        return Component.translatable((String)"tfc.tooltip.fluid_units", (Object[])new Object[]{mB});
    }

    public static MutableComponent fluidUnitsOf(FluidStack fluid) {
        return Component.translatable((String)"tfc.tooltip.fluid_units_of", (Object[])new Object[]{fluid.getAmount(), fluid.getHoverName()});
    }

    public static MutableComponent fluidUnitsAndCapacityOf(FluidStack fluid, int capacity) {
        return Tooltips.fluidUnitsAndCapacityOf(fluid.getHoverName(), fluid.getAmount(), capacity);
    }

    public static MutableComponent fluidUnitsAndCapacityOf(Component fluid, int amount, int capacity) {
        return Component.translatable((String)"tfc.tooltip.fluid_units_and_capacity_of", (Object[])new Object[]{amount, capacity, fluid});
    }

    public static MutableComponent lessThanOneFluidUnits() {
        return Component.translatable((String)"tfc.tooltip.less_than_one_fluid_units");
    }

    public static MutableComponent moltenOrSolid(boolean molten) {
        return Component.translatable((String)(molten ? "tfc.tooltip.molten" : "tfc.tooltip.solid"));
    }

    @Nullable
    public static MutableComponent meltsInto(FluidStack stack, float atTemperature) {
        MutableComponent heat = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(atTemperature);
        return heat == null ? null : Component.translatable((String)"tfc.tooltip.melts_into", (Object[])new Object[]{Tooltips.fluidUnitsOf(stack), heat});
    }

    public static MutableComponent contents() {
        return Component.translatable((String)"tfc.tooltip.contents").withStyle(ChatFormatting.DARK_GREEN);
    }

    public static MutableComponent countOfItem(ItemStack stack) {
        return Tooltips.countOfItem(stack, stack.getCount());
    }

    public static MutableComponent countOfItem(ItemStack stack, int count) {
        return Component.literal((String)String.valueOf(count)).append(" x ").append(stack.getHoverName());
    }

    public static MutableComponent tier(int tier) {
        return Component.translatable((String)("tfc.tooltip.tier_" + tier));
    }

    @Contract(value="null, null -> fail")
    public static MutableComponent require(@Nullable Component min, @Nullable Component max) {
        if (min != null && max != null) {
            return Component.translatable((String)"tfc.tooltip.required_range", (Object[])new Object[]{min, max});
        }
        if (min != null) {
            return Component.translatable((String)"tfc.tooltip.required_greater_than", (Object[])new Object[]{min});
        }
        if (max != null) {
            return Component.translatable((String)"tfc.tooltip.required_less_than", (Object[])new Object[]{max});
        }
        throw new IllegalArgumentException("One of min or max must be non-null");
    }

    public static MutableComponent author(Component source, String author) {
        return Component.translatable((String)"tfc.tooltip.author", (Object[])new Object[]{source, author});
    }
}

