/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.tracker;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.TFCPoiTypes;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.IcePileBlock;
import net.dries007.tfc.common.blocks.IcicleBlock;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.ThinSpikeBlock;
import net.dries007.tfc.common.blocks.plant.KrummholzBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.accessor.PoiSectionAccessor;
import net.dries007.tfc.mixin.accessor.SectionStorageAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.tracker.WorldTracker;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public final class WeatherHelpers {
    private static final Holder<PoiType> CLIMATE = BuiltInRegistries.POINT_OF_INTEREST_TYPE.getHolderOrThrow((ResourceKey)TFCPoiTypes.CLIMATE.unwrapKey().orElseThrow());
    private static final int TICKS_PER_SNOW_ACCUMULATION = 80;
    private static final int TICKS_PER_SNOW_MELT_PER_SNOW_ACCUMULATION = 3;
    private static final int TICKS_PER_SNOW_MELT = 240;
    private static final int WIND_KMS_FACTOR = 115;
    private static final int WIND_MS_FACTOR = 32;
    private static final int UPDATES_PER_SNOW_MELT_SKIP = 17;
    private static final int UPDATES_PER_SNOW_ACCUMULATION_SKIP = 51;
    private static final int MAX_UPDATES_PER_TICK = TFCConfig.SERVER.snowMaxAccumulationOnUpdate.get();

    public static Biome.Precipitation getPrecipitationAt(Level level, BlockPos pos, Biome.Precipitation defaultValue) {
        float rainValue;
        WorldTracker tracker = WorldTracker.get(level);
        ClimateModel model = tracker.getClimateModel();
        if (!model.supportsRain()) {
            return defaultValue;
        }
        long calendarTicks = Calendars.get((LevelReader)level).getCalendarTicks();
        float rainIntensity = tracker.isWeatherEnabled() ? model.getRain(calendarTicks) : -1.0f;
        return WeatherHelpers.isPrecipitating(rainIntensity, rainValue = model.getRainfall((LevelReader)level, pos)) ? (model.getTemperature((LevelReader)level, pos) > 0.0f ? Biome.Precipitation.RAIN : Biome.Precipitation.SNOW) : Biome.Precipitation.NONE;
    }

    public static boolean isPrecipitating(float rainIntensity, float rainfall) {
        return WeatherHelpers.calculateRealRainIntensity(rainIntensity, rainfall) > 0.0f;
    }

    public static float calculateRealRainIntensity(float rainIntensity, float rainfall) {
        return rainIntensity - Mth.clampedMap((float)rainfall, (float)0.0f, (float)500.0f, (float)1.0f, (float)0.0f);
    }

    public static boolean advanceWeatherCycle(ServerLevel level) {
        WorldTracker tracker = WorldTracker.get((Level)level);
        ClimateModel model = tracker.getClimateModel();
        if (!model.supportsRain()) {
            return false;
        }
        long calendarTicks = Calendars.SERVER.getCalendarTicks();
        float rain = tracker.isWeatherEnabled() ? model.getRain(calendarTicks) : -1.0f;
        boolean thunder = tracker.isWeatherEnabled() && model.getThunder(calendarTicks);
        boolean wasRaining = level.isRaining();
        level.oRainLevel = level.rainLevel;
        level.rainLevel = Mth.clamp((float)(level.rainLevel + (rain >= 0.0f ? 0.01f : -0.01f)), (float)0.0f, (float)1.0f);
        level.oThunderLevel = level.thunderLevel;
        level.thunderLevel = Mth.clamp((float)(level.thunderLevel + (thunder ? 0.01f : -0.01f)), (float)0.0f, (float)1.0f);
        if (level.oRainLevel != level.rainLevel) {
            WeatherHelpers.sendToAllInDimension(level, ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, level.rainLevel);
        }
        if (level.oThunderLevel != level.thunderLevel) {
            WeatherHelpers.sendToAllInDimension(level, ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, level.thunderLevel);
        }
        if (wasRaining != level.isRaining()) {
            WeatherHelpers.sendToAllInDimension(level, wasRaining ? ClientboundGameEventPacket.STOP_RAINING : ClientboundGameEventPacket.START_RAINING, 0.0f);
            WeatherHelpers.sendToAllInDimension(level, ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, level.rainLevel);
            WeatherHelpers.sendToAllInDimension(level, ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, level.thunderLevel);
        }
        return true;
    }

    private static void sendToAllInDimension(ServerLevel level, ClientboundGameEventPacket.Type event, float value) {
        level.getServer().getPlayerList().broadcastAll((Packet)new ClientboundGameEventPacket(event, value), level.dimension());
    }

    public static void onTickChunk(ServerLevel level, ChunkAccess chunk) {
        WorldTracker tracker = WorldTracker.get((Level)level);
        if (!tracker.isWeatherEnabled()) {
            return;
        }
        ClimateModel model = tracker.getClimateModel();
        if (!model.supportsRain()) {
            return;
        }
        ChunkData data = ChunkData.get(chunk);
        long currentTick = Calendars.SERVER.getTicks();
        long currentCalendarTick = Calendars.SERVER.getCalendarTicks();
        long timeSinceTick = currentTick - data.getLastRandomTick();
        ChunkPos chunkPos = chunk.getPos();
        BlockPos surfacePos = WeatherHelpers.getSequentialSurfacePos(level, chunkPos, chunk, data, false);
        float rainfall = model.getRainfall((LevelReader)level, surfacePos, data.getLastRandomTick(), currentTick, Calendars.SERVER.getCalendarDaysInMonth());
        int daysInMonth = Calendars.SERVER.getCalendarDaysInMonth();
        if (timeSinceTick > 4000L) {
            long calendarTick = currentCalendarTick - Math.min(192000L, timeSinceTick);
            int netChangeInSnow = 0;
            while (calendarTick < currentCalendarTick) {
                float estimatedTemperature = model.getTemperature((LevelReader)level, surfacePos, calendarTick += 4000L, daysInMonth);
                if (estimatedTemperature > 2.0f) {
                    netChangeInSnow -= 17;
                    continue;
                }
                if (!(estimatedTemperature < -2.0f) || !WeatherHelpers.isPrecipitating(model.getRain(calendarTick), rainfall)) continue;
                float fuzz = Mth.clampedMap((float)estimatedTemperature, (float)-2.0f, (float)-12.0f, (float)0.5f, (float)1.0f);
                netChangeInSnow += (int)(51.0f * fuzz);
            }
            if (netChangeInSnow > 0) {
                netChangeInSnow = Math.min(MAX_UPDATES_PER_TICK, Math.min(256 - WeatherHelpers.countExistingSnowInChunk(level, chunkPos), netChangeInSnow));
                for (int i = 0; i < netChangeInSnow; ++i) {
                    WeatherHelpers.handleSnowAccumulation(level, WeatherHelpers.getSequentialSurfacePos(level, chunkPos, chunk, data, true));
                }
            } else if (netChangeInSnow < 0) {
                int meltFactor = (int)Math.max(timeSinceTick / 192000L, 1L);
                netChangeInSnow = Math.min(MAX_UPDATES_PER_TICK, -netChangeInSnow * meltFactor);
                WeatherHelpers.handleSnowMelting(level, chunkPos, netChangeInSnow);
            }
        } else if (level.random.nextInt(80) == 0) {
            float realTemperature = model.getTemperature((LevelReader)level, surfacePos);
            if (realTemperature > 2.0f && level.random.nextInt(3) == 0) {
                WeatherHelpers.handleSnowMelting(level, chunkPos, 1);
            } else if (realTemperature < -2.0f && WeatherHelpers.isPrecipitating(model.getRain(currentCalendarTick), rainfall)) {
                WeatherHelpers.handleSnowAccumulation(level, surfacePos);
                data.iterateSnowPos(chunk);
            }
        }
        data.setLastRandomTick(chunk, currentTick);
    }

    private static BlockPos getSequentialSurfacePos(ServerLevel level, ChunkPos chunkPos, ChunkAccess access, ChunkData data, boolean updateChunk) {
        BlockPos pos = data.getNextSnowPos(chunkPos);
        if (updateChunk) {
            data.iterateSnowPos(access);
        }
        return level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos);
    }

    private static int countExistingSnowInChunk(ServerLevel level, ChunkPos chunkPos) {
        int total = 0;
        SectionStorageAccessor<PoiSection> poi = WeatherHelpers.getPoiManager(level);
        for (int sectionY = level.getMaxSection() - 1; sectionY >= level.getMinSection(); --sectionY) {
            Set<PoiRecord> objects = WeatherHelpers.getPoiRecords(poi, chunkPos, sectionY);
            if (objects == null) continue;
            total += objects.size();
        }
        return total;
    }

    private static void handleSnowMelting(ServerLevel level, ChunkPos chunkPos, int amount) {
        SectionStorageAccessor<PoiSection> poi = WeatherHelpers.getPoiManager(level);
        for (int sectionY = level.getMinSection(); sectionY < level.getMaxSection(); ++sectionY) {
            Set<PoiRecord> entries = WeatherHelpers.getPoiRecords(poi, chunkPos, sectionY);
            if (entries == null || entries.isEmpty()) continue;
            ArrayList<PoiRecord> copyOfEntries = new ArrayList<PoiRecord>(entries);
            if (amount >= copyOfEntries.size()) {
                for (PoiRecord entry : copyOfEntries) {
                    WeatherHelpers.removeSnowAt(level, entry.getPos());
                }
                amount -= copyOfEntries.size();
            } else {
                List<PoiRecord> sampleOfEntries = Helpers.uniqueRandomSample(copyOfEntries, amount, level.random);
                for (PoiRecord entry : sampleOfEntries) {
                    WeatherHelpers.removeSnowAt(level, entry.getPos());
                }
                amount -= sampleOfEntries.size();
            }
            if (amount > 0) continue;
            return;
        }
    }

    private static SectionStorageAccessor<PoiSection> getPoiManager(ServerLevel level) {
        return (SectionStorageAccessor)level.getPoiManager();
    }

    @Nullable
    private static Set<PoiRecord> getPoiRecords(SectionStorageAccessor<PoiSection> poi, ChunkPos chunkPos, int sectionY) {
        long sectionKey = SectionPos.asLong((int)chunkPos.x, (int)sectionY, (int)chunkPos.z);
        Optional<PoiSection> section = poi.invoke$getOrLoad(sectionKey);
        return section.isPresent() ? ((PoiSectionAccessor)section.get()).accessor$byType().get(CLIMATE) : null;
    }

    private static void handleSnowAccumulation(ServerLevel level, BlockPos surfacePos) {
        BlockPos iciclePos;
        if (WeatherHelpers.placeSnowOrSnowPile(level, surfacePos)) {
            return;
        }
        BlockPos groundPos = surfacePos.below();
        if (WeatherHelpers.placeSnowOrSnowPile(level, groundPos)) {
            return;
        }
        BlockPos belowGroundPos = surfacePos.below(2);
        if (WeatherHelpers.placeSnowOrSnowPile(level, belowGroundPos)) {
            return;
        }
        BlockState groundState = level.getBlockState(groundPos);
        if (WeatherHelpers.isIce(groundState)) {
            return;
        }
        if (groundState.getFluidState().getType() != Fluids.WATER) {
            groundPos = belowGroundPos;
            groundState = level.getBlockState(groundPos);
        }
        IcePileBlock.placeIcePileOrIce((LevelAccessor)level, groundPos, groundState, false);
        if (level.random.nextInt(16) == 0 && (iciclePos = WeatherHelpers.findIcicleLocation(level, surfacePos)) != null) {
            BlockPos posAbove = iciclePos.above();
            BlockState stateAbove = level.getBlockState(posAbove);
            if (Helpers.isBlock(stateAbove, (TagKey<Block>)BlockTags.ICE)) {
                return;
            }
            if (Helpers.isBlock(stateAbove, (Block)TFCBlocks.ICICLE.get())) {
                level.setBlock(posAbove, (BlockState)stateAbove.setValue((Property)ThinSpikeBlock.TIP, (Comparable)Boolean.valueOf(false)), 19);
            }
            level.setBlock(iciclePos, (BlockState)((ThinSpikeBlock)TFCBlocks.ICICLE.get()).defaultBlockState().setValue((Property)ThinSpikeBlock.TIP, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private static boolean placeSnowOrSnowPile(ServerLevel level, BlockPos initialPos) {
        BlockPos pos = WeatherHelpers.findOptimalSnowLocation(level, initialPos, level.getBlockState(initialPos));
        BlockState state = level.getBlockState(pos);
        if (initialPos.equals((Object)pos) && !level.canSeeSky(pos)) {
            return false;
        }
        return WeatherHelpers.placeSnowOrSnowPileAt(level, pos, state);
    }

    private static boolean placeSnowOrSnowPileAt(ServerLevel level, BlockPos pos, BlockState state) {
        if (SnowPileBlock.canPlaceSnowPile((LevelAccessor)level, pos, state)) {
            SnowPileBlock.placeSnowPile((LevelAccessor)level, pos, state, false);
            return true;
        }
        if (state.getBlock() instanceof KrummholzBlock) {
            KrummholzBlock.updateFreezingInColumn((LevelAccessor)level, pos, true);
        } else {
            if (state.isAir() && Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)level, pos)) {
                level.setBlock(pos, Blocks.SNOW.defaultBlockState(), 3);
                return true;
            }
            state.getBlock().handlePrecipitation(state, (Level)level, pos, Biome.Precipitation.SNOW);
        }
        return false;
    }

    private static BlockPos findOptimalSnowLocation(ServerLevel level, BlockPos pos, BlockState state) {
        BlockPos targetPos = null;
        int found = 0;
        if (WeatherHelpers.isSnow(state)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos adjPos = pos.relative(direction);
                BlockState adjState = level.getBlockState(adjPos);
                if (!adjState.isAir() && !Helpers.isBlock(adjState.getBlock(), TFCTags.Blocks.CAN_BE_SNOW_PILED) || !Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)level, adjPos) || targetPos != null && level.random.nextInt(++found) != 0) continue;
                targetPos = adjPos;
            }
            if (targetPos != null) {
                return targetPos;
            }
        }
        return pos;
    }

    @Nullable
    private static BlockPos findIcicleLocation(ServerLevel level, BlockPos pos) {
        Direction side = Direction.Plane.HORIZONTAL.getRandomDirection(level.random);
        BlockPos adjacentPos = pos.relative(side);
        int adjacentHeight = level.getHeight(Heightmap.Types.MOTION_BLOCKING, adjacentPos.getX(), adjacentPos.getZ());
        BlockPos foundPos = null;
        int found = 0;
        for (int y = 0; y < adjacentHeight; ++y) {
            BlockState stateAt = level.getBlockState(adjacentPos);
            BlockPos posAbove = adjacentPos.above();
            BlockState stateAbove = level.getBlockState(posAbove);
            if (stateAt.isAir() && (stateAbove.getBlock() == TFCBlocks.ICICLE.get() || stateAbove.isFaceSturdy((BlockGetter)level, posAbove, Direction.DOWN)) && (foundPos == null || level.random.nextInt(++found) == 0)) {
                foundPos = adjacentPos;
            }
            adjacentPos = posAbove;
        }
        if (foundPos == null) {
            return null;
        }
        int maxLength = 1 + Helpers.hash(7189237951231L, pos.getX(), 0, pos.getZ()) % 3;
        if (level.getBlockState(foundPos.above(maxLength)).getBlock() == TFCBlocks.ICICLE.get()) {
            return null;
        }
        return foundPos;
    }

    private static void removeSnowAt(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (WeatherHelpers.isSnow(state)) {
            SnowPileBlock.removePileOrSnow((LevelAccessor)level, pos, state);
        } else if (state.getBlock() instanceof KrummholzBlock) {
            KrummholzBlock.updateFreezingInColumn((LevelAccessor)level, pos, false);
        } else if (WeatherHelpers.isIce(state)) {
            IcePileBlock.removeIcePileOrIce((LevelAccessor)level, pos, state);
        } else if (state.getBlock() == TFCBlocks.ICICLE.get()) {
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            cursor.setWithOffset((Vec3i)pos, Direction.DOWN);
            BlockState belowState = level.getBlockState((BlockPos)cursor);
            while (belowState.getBlock() == TFCBlocks.ICICLE.get()) {
                cursor.move(Direction.DOWN);
                belowState = level.getBlockState((BlockPos)cursor);
            }
            cursor.move(Direction.UP);
            level.removeBlock((BlockPos)cursor, false);
            cursor.move(Direction.UP);
            BlockState stateAbove = level.getBlockState((BlockPos)cursor);
            if (stateAbove.getBlock() == TFCBlocks.ICICLE.get()) {
                level.setBlock((BlockPos)cursor, (BlockState)stateAbove.setValue((Property)IcicleBlock.TIP, (Comparable)Boolean.valueOf(true)), 3);
            }
        }
    }

    public static boolean isSnow(BlockState state) {
        return state.getBlock() == Blocks.SNOW || state.getBlock() == TFCBlocks.SNOW_PILE.get();
    }

    public static boolean isIce(BlockState state) {
        return state.getBlock() == Blocks.ICE || state.getBlock() == TFCBlocks.ICE_PILE.get() || state.getBlock() == TFCBlocks.SEA_ICE.get();
    }

    public static float windMS(Vec2 wind) {
        return wind.length() * 32.0f;
    }

    public static float windMT(Vec2 wind) {
        return wind.length() * 32.0f / 20.0f;
    }

    public static float windKMH(Vec2 wind) {
        return wind.length() * 115.0f;
    }

    public static float wrappedPositiveAngle(float angleIn) {
        float angle = angleIn < 0.0f ? (angleIn = angleIn + (float)Math.PI * 2) : angleIn;
        if ((angle += 1.5707964f) > (float)Math.PI * 2) {
            angle -= (float)Math.PI * 2;
        }
        return angle;
    }

    public static Component windGranularCardinal(Vec2 wind) {
        float angle = WeatherHelpers.wrappedPositiveAngle((float)Mth.atan2((double)wind.y, (double)wind.x)) * 57.295776f;
        float m = 11.25f;
        MutableComponent direction = Component.empty();
        if (angle < 0.0f + m && angle > 0.0f - m) {
            direction = Helpers.translateEnum(Direction.NORTH);
        } else if ((double)angle < 22.5 + (double)m && (double)angle > 22.5 - (double)m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_granular", (Object[])new Object[]{Helpers.translateEnum(Direction.NORTH), Component.translatable((String)"tfc.direction.cardinal_northeast")});
        } else if (angle < 45.0f + m && angle > 45.0f - m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_northeast");
        } else if ((double)angle < 67.5 + (double)m && (double)angle > 67.5 - (double)m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_granular", (Object[])new Object[]{Helpers.translateEnum(Direction.EAST), Component.translatable((String)"tfc.direction.cardinal_northeast")});
        } else if (angle < 90.0f + m && angle > 90.0f - m) {
            direction = Helpers.translateEnum(Direction.EAST);
        } else if ((double)angle < 112.5 + (double)m && (double)angle > 112.5 - (double)m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_granular", (Object[])new Object[]{Helpers.translateEnum(Direction.EAST), Component.translatable((String)"tfc.direction.cardinal_southeast")});
        } else if (angle < 135.0f + m && angle > 135.0f - m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_southeast");
        } else if ((double)angle < 157.5 + (double)m && (double)angle > 157.5 - (double)m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_granular", (Object[])new Object[]{Helpers.translateEnum(Direction.SOUTH), Component.translatable((String)"tfc.direction.cardinal_southeast")});
        } else if (angle < 180.0f + m && angle > 180.0f - m) {
            direction = Helpers.translateEnum(Direction.SOUTH);
        } else if ((double)angle < 202.5 + (double)m && (double)angle > 202.5 - (double)m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_granular", (Object[])new Object[]{Helpers.translateEnum(Direction.SOUTH), Component.translatable((String)"tfc.direction.cardinal_southwest")});
        } else if (angle < 225.0f + m && angle > 225.0f - m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_southwest");
        } else if ((double)angle < 247.5 + (double)m && (double)angle > 247.5 - (double)m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_granular", (Object[])new Object[]{Helpers.translateEnum(Direction.WEST), Component.translatable((String)"tfc.direction.cardinal_southwest")});
        } else if (angle < 270.0f + m && angle > 270.0f - m) {
            direction = Helpers.translateEnum(Direction.WEST);
        } else if ((double)angle < 292.5 + (double)m && (double)angle > 292.5 - (double)m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_granular", (Object[])new Object[]{Helpers.translateEnum(Direction.WEST), Component.translatable((String)"tfc.direction.cardinal_northwest")});
        } else if (angle < 315.0f + m && angle > 315.0f - m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_northwest");
        } else if ((double)angle < 337.5 + (double)m && (double)angle > 337.5 - (double)m) {
            direction = Component.translatable((String)"tfc.direction.cardinal_granular", (Object[])new Object[]{Helpers.translateEnum(Direction.NORTH), Component.translatable((String)"tfc.direction.cardinal_northwest")});
        } else if (angle < 360.0f + m && angle > 360.0f - m) {
            direction = Helpers.translateEnum(Direction.NORTH);
        }
        return direction;
    }
}

