/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.tracker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCAttachments;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.misc.TFCFallingBlockEntity;
import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.common.recipes.LandslideRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.BiomeBasedClimateModel;
import net.dries007.tfc.util.climate.ClimateModel;
import net.dries007.tfc.util.collections.BufferedList;
import net.dries007.tfc.util.events.CollapseEvent;
import net.dries007.tfc.util.loot.TFCLoot;
import net.dries007.tfc.util.rotation.RotationNetworkManager;
import net.dries007.tfc.util.tracker.Collapse;
import net.dries007.tfc.util.tracker.TickEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public final class WorldTracker {
    private final Level level;
    private final RandomSource random;
    private final BufferedList<TickEntry> landslideTicks = new BufferedList();
    private final BufferedList<BlockPos> isolatedPositions = new BufferedList();
    private final List<Collapse> collapsesInProgress = new ArrayList<Collapse>();
    private final RotationNetworkManager rotationManager = new RotationNetworkManager();
    private ClimateModel climateModel = BiomeBasedClimateModel.INSTANCE;
    private boolean weatherEnabled = true;

    public static WorldTracker get(Level level) {
        return (WorldTracker)level.getData(TFCAttachments.WORLD_TRACKER);
    }

    public WorldTracker(Level level) {
        this.level = level;
        this.random = new XoroshiroRandomSource(RandomSupport.generateUniqueSeed());
    }

    public void addLandslidePos(BlockPos pos) {
        this.landslideTicks.add(new TickEntry(pos, 2));
    }

    public void addIsolatedPos(BlockPos pos) {
        this.isolatedPositions.add(pos);
    }

    public void addCollapseData(Collapse collapse) {
        this.collapsesInProgress.add(collapse);
        NeoForge.EVENT_BUS.post((Event)new CollapseEvent(this.level, collapse.centerPos, collapse.nextPositions, collapse.radiusSquared, false));
    }

    public void setClimateModel(ClimateModel climateModel) {
        this.climateModel = climateModel;
    }

    public ClimateModel getClimateModel() {
        return this.climateModel;
    }

    public void addCollapsePositions(BlockPos centerPos, Collection<BlockPos> positions) {
        ArrayList<BlockPos> collapsePositions = new ArrayList<BlockPos>();
        double maxRadiusSquared = 0.0;
        for (BlockPos pos : positions) {
            double distSquared = pos.distSqr((Vec3i)centerPos);
            if (distSquared > maxRadiusSquared) {
                maxRadiusSquared = distSquared;
            }
            if (!((double)this.random.nextFloat() < TFCConfig.SERVER.collapseExplosionPropagateChance.get())) continue;
            collapsePositions.add(pos.above());
        }
        this.addCollapseData(new Collapse(centerPos, collapsePositions, maxRadiusSquared));
    }

    public boolean isWeatherEnabled() {
        return this.weatherEnabled;
    }

    public void setWeatherEnabled(boolean weatherEnabled) {
        this.weatherEnabled = weatherEnabled;
    }

    public RotationNetworkManager getRotationManager() {
        return this.rotationManager;
    }

    public void tick() {
        if (!this.collapsesInProgress.isEmpty() && this.random.nextInt(10) == 0) {
            for (Collapse collapse2 : this.collapsesInProgress) {
                HashSet<BlockPos> updatedPositions = new HashSet<BlockPos>();
                for (BlockPos posAt : collapse2.nextPositions) {
                    BlockState stateAt = this.level.getBlockState(posAt);
                    if (!CollapseRecipe.canCollapse(stateAt) || !TFCFallingBlockEntity.canFallInDirection((BlockGetter)this.level, posAt, Direction.DOWN) || !(posAt.distSqr((Vec3i)collapse2.centerPos) < collapse2.radiusSquared) || !((double)this.random.nextFloat() < TFCConfig.SERVER.collapsePropagateChance.get()) || !CollapseRecipe.collapseBlock(this.level, posAt, stateAt)) continue;
                    updatedPositions.add(posAt.above());
                }
                collapse2.nextPositions.clear();
                if (updatedPositions.isEmpty()) continue;
                this.level.playSound(null, collapse2.centerPos, (SoundEvent)TFCSounds.ROCK_SLIDE_SHORT.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
                collapse2.nextPositions.addAll(updatedPositions);
                collapse2.radiusSquared *= 0.8;
            }
            this.collapsesInProgress.removeIf(collapse -> collapse.nextPositions.isEmpty());
        }
        this.landslideTicks.flush();
        ListIterator tickIterator = this.landslideTicks.listIterator();
        while (tickIterator.hasNext()) {
            TickEntry entry = (TickEntry)tickIterator.next();
            if (!entry.tick()) continue;
            BlockState currentState = this.level.getBlockState(entry.getPos());
            LandslideRecipe.tryLandslide(this.level, entry.getPos(), currentState);
            tickIterator.remove();
        }
        this.isolatedPositions.flush();
        ListIterator isolatedIterator = this.isolatedPositions.listIterator();
        while (isolatedIterator.hasNext()) {
            BlockPos pos = (BlockPos)isolatedIterator.next();
            BlockState currentState = this.level.getBlockState(pos);
            if (Helpers.isBlock(currentState.getBlock(), TFCTags.Blocks.BREAKS_WHEN_ISOLATED) && this.isIsolated((LevelAccessor)this.level, pos)) {
                Helpers.destroyBlockAndDropBlocksManually((ServerLevel)this.level, pos, ctx -> ctx.withParameter(TFCLoot.ISOLATED, (Object)true));
            }
            isolatedIterator.remove();
        }
    }

    public CompoundTag serializeNBT() {
        this.landslideTicks.flush();
        this.isolatedPositions.flush();
        CompoundTag nbt = new CompoundTag();
        ListTag landslideNbt = new ListTag();
        for (TickEntry entry : this.landslideTicks) {
            landslideNbt.add((Object)entry.serializeNBT());
        }
        nbt.put("landslideTicks", (Tag)landslideNbt);
        LongArrayTag isolatedNbt = new LongArrayTag(this.isolatedPositions.stream().mapToLong(BlockPos::asLong).toArray());
        nbt.put("isolatedPositions", (Tag)isolatedNbt);
        ListTag collapseNbt = new ListTag();
        for (Collapse collapse : this.collapsesInProgress) {
            collapseNbt.add((Object)collapse.serializeNBT());
        }
        nbt.put("collapsesInProgress", (Tag)collapseNbt);
        nbt.putBoolean("weatherEnabled", this.weatherEnabled);
        return nbt;
    }

    public void deserializeNBT(@Nullable CompoundTag nbt) {
        if (nbt != null) {
            this.landslideTicks.clear();
            this.collapsesInProgress.clear();
            this.isolatedPositions.clear();
            ListTag landslideNbt = nbt.getList("landslideTicks", 10);
            for (int i = 0; i < landslideNbt.size(); ++i) {
                this.landslideTicks.add(new TickEntry(landslideNbt.getCompound(i)));
            }
            long[] isolatedNbt = nbt.getLongArray("isolatedPositions");
            Arrays.stream(isolatedNbt).mapToObj(BlockPos::of).forEach(this.isolatedPositions::add);
            ListTag collapseNbt = nbt.getList("collapsesInProgress", 10);
            for (int i = 0; i < collapseNbt.size(); ++i) {
                this.collapsesInProgress.add(new Collapse(collapseNbt.getCompound(i)));
            }
            this.weatherEnabled = nbt.getBoolean("weatherEnabled");
        }
    }

    private boolean isIsolated(LevelAccessor level, BlockPos pos) {
        for (Direction direction : Helpers.DIRECTIONS) {
            BlockState state = level.getBlockState(pos.relative(direction));
            if (state.getCollisionShape((BlockGetter)level, pos).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

