/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.noise.Noise2D;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.Nullable;

public interface BiomeNoiseSampler {
    public static final double SOLID = 0.0;
    public static final double AIR_THRESHOLD = 0.4;

    public static BiomeNoiseSampler fromHeightNoise(final Noise2D heightNoise) {
        return new BiomeNoiseSampler(){
            private float height;

            @Override
            public void setColumn(int x, int z) {
                this.height = (float)heightNoise.noise(x, z);
            }

            @Override
            public double height() {
                return this.height;
            }

            @Override
            public double noise(int y) {
                return 0.0;
            }
        };
    }

    default public void prepare(ChunkGeneratorExtension generator, @Nullable ChunkAccess chunk) {
    }

    public void setColumn(int var1, int var2);

    public double height();

    public double noise(int var1);
}

