/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public class FastConcurrentCache<T> {
    private final StampedLock lock = new StampedLock();
    private final long[] keys;
    private final T[] values;
    private final int mask;

    public FastConcurrentCache(int size) {
        size = Mth.smallestEncompassingPowerOfTwo((int)size);
        this.mask = size - 1;
        this.keys = new long[size];
        this.values = new Object[size];
        Arrays.fill(this.keys, Long.MIN_VALUE);
    }

    @Nullable
    public T getIfPresent(int x, int z) {
        long key = ChunkPos.asLong((int)x, (int)z);
        int index = (int)HashCommon.mix((long)key) & this.mask;
        long stamp = this.lock.readLock();
        T t = null;
        if (this.keys[index] == key) {
            t = this.values[index];
        }
        this.lock.unlockRead(stamp);
        return t;
    }

    public void set(int x, int z, T value) {
        long key = ChunkPos.asLong((int)x, (int)z);
        int index = (int)HashCommon.mix((long)key) & this.mask;
        long stamp = this.lock.writeLock();
        this.keys[index] = key;
        this.values[index] = value;
        this.lock.unlockWrite(stamp);
    }
}

