/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongFunction;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.AquiferLookahead;
import net.dries007.tfc.world.biome.BiomeBlendType;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.BiomeNoise;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.shore.ShoreBlendType;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.dries007.tfc.world.surface.builder.TuffRingsSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.TuyasSurfaceBuilder;
import net.dries007.tfc.world.surface.builder.VolcanoesSurfaceBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class BiomeBuilder {
    @Nullable
    private Function<Seed, Noise2D> heightNoiseFactory;
    @Nullable
    private Function<Seed, BiomeNoiseSampler> noiseFactory;
    @Nullable
    private SurfaceBuilderFactory surfaceBuilderFactory;
    private AquiferLookahead aquiferSurfaceHeight = (sampler, x, z) -> {
        sampler.setColumn(x, z);
        return sampler.height();
    };
    private BiomeBlendType biomeBlendType = BiomeBlendType.LAND;
    private RiverBlendType riverBlendType = RiverBlendType.NONE;
    private ShoreBlendType shoreBlendType = ShoreBlendType.NONE;
    private boolean salty = false;
    private boolean volcanic = false;
    private boolean hasTuyas = false;
    private boolean hasTuffRings = false;
    private int volcanoFrequency = 0;
    private int volcanoBasaltHeight = 0;
    private int tuffRingFrequency = 0;
    private int tuyaFrequency = 0;
    private boolean spawnable = false;
    private boolean rivers = true;
    private boolean shore = false;
    private int shoreBaseHeight = 63;
    private boolean sandyRiverShores = true;

    public static BiomeBuilder builder() {
        return new BiomeBuilder();
    }

    private BiomeBuilder() {
    }

    public BiomeBuilder heightmap(LongFunction<Noise2D> heightNoiseFactory) {
        this.heightNoiseFactory = seed -> (Noise2D)heightNoiseFactory.apply(seed.seed());
        this.noiseFactory = seed -> BiomeNoiseSampler.fromHeightNoise((Noise2D)heightNoiseFactory.apply(seed.seed()));
        return this;
    }

    public BiomeBuilder surface(SurfaceBuilderFactory surfaceBuilderFactory) {
        this.surfaceBuilderFactory = surfaceBuilderFactory;
        return this;
    }

    public BiomeBuilder carving(BiFunction<Long, Noise2D, BiomeNoiseSampler> carvingNoiseFactory) {
        Objects.requireNonNull(this.heightNoiseFactory, "Height noise must not be null");
        Function<Seed, Noise2D> baseHeightNoiseFactory = this.heightNoiseFactory;
        this.noiseFactory = seed -> (BiomeNoiseSampler)carvingNoiseFactory.apply(seed.seed(), (Noise2D)baseHeightNoiseFactory.apply((Seed)seed));
        this.aquiferSurfaceHeight = (sampler, x, z) -> 47.0;
        return this;
    }

    public BiomeBuilder noise(LongFunction<BiomeNoiseSampler> noiseFactory) {
        this.noiseFactory = seed -> (BiomeNoiseSampler)noiseFactory.apply(seed.seed());
        return this;
    }

    public BiomeBuilder aquiferHeightOffset(double delta) {
        return this.aquiferHeight((sampler, x, z) -> {
            sampler.setColumn(x, z);
            return sampler.height() + delta;
        });
    }

    public BiomeBuilder aquiferHeight(AquiferLookahead aquiferSurfaceHeight) {
        this.aquiferSurfaceHeight = aquiferSurfaceHeight;
        return this;
    }

    public BiomeBuilder type(BiomeBlendType type) {
        this.biomeBlendType = type;
        return this;
    }

    public BiomeBuilder type(RiverBlendType type) {
        this.riverBlendType = type;
        if (type == RiverBlendType.CAVE) {
            this.sandyRiverShores = false;
        }
        return this;
    }

    public BiomeBuilder type(ShoreBlendType type) {
        this.shoreBlendType = type;
        return this;
    }

    public BiomeBuilder salty() {
        this.salty = true;
        return this;
    }

    public BiomeBuilder spawnable() {
        this.spawnable = true;
        return this;
    }

    public BiomeBuilder noRivers() {
        this.rivers = false;
        this.sandyRiverShores = false;
        return this;
    }

    public BiomeBuilder noSandyRiverShores() {
        this.sandyRiverShores = false;
        return this;
    }

    public BiomeBuilder setShoreBaseHeight(int shoreBaseHeight) {
        this.shoreBaseHeight = 63 + shoreBaseHeight;
        return this;
    }

    public BiomeBuilder shore() {
        this.shore = true;
        return this;
    }

    public BiomeBuilder volcanoes(int frequency, int baseHeight, int scaleHeight, int volcanoBasaltHeight) {
        return this.volcanoes(frequency, baseHeight, scaleHeight, volcanoBasaltHeight, false);
    }

    public BiomeBuilder volcanoes(int frequency, int baseHeight, int scaleHeight, int volcanoBasaltHeight, boolean additive) {
        this.volcanic = true;
        this.volcanoFrequency = frequency;
        this.volcanoBasaltHeight = 63 + volcanoBasaltHeight;
        assert (this.heightNoiseFactory != null) : "volcanoes must be called after setting a heightmap";
        assert (this.surfaceBuilderFactory != null) : "volcanoes must be called after setting a surface builder";
        Function<Seed, Noise2D> baseHeightNoiseFactory = this.heightNoiseFactory;
        this.heightNoiseFactory = seed -> BiomeNoise.addVolcanoes(seed, (Noise2D)baseHeightNoiseFactory.apply((Seed)seed), frequency, baseHeight, scaleHeight, additive);
        this.noiseFactory = seed -> BiomeNoiseSampler.fromHeightNoise(this.heightNoiseFactory.apply((Seed)seed));
        this.surfaceBuilderFactory = VolcanoesSurfaceBuilder.create(this.surfaceBuilderFactory);
        return this;
    }

    public BiomeBuilder tuffRings(int frequency, int baseHeight, int scaleHeight) {
        this.hasTuffRings = true;
        this.tuffRingFrequency = frequency;
        assert (this.heightNoiseFactory != null) : "tuff rings must be called after setting a heightmap";
        assert (this.surfaceBuilderFactory != null) : "volcanoes must be called after setting a surface builder";
        Function<Seed, Noise2D> baseHeightNoiseFactory = this.heightNoiseFactory;
        this.heightNoiseFactory = seed -> BiomeNoise.addTuffRings(seed, (Noise2D)baseHeightNoiseFactory.apply((Seed)seed), frequency, baseHeight, scaleHeight);
        this.noiseFactory = seed -> BiomeNoiseSampler.fromHeightNoise(this.heightNoiseFactory.apply((Seed)seed));
        this.surfaceBuilderFactory = TuffRingsSurfaceBuilder.create(this.surfaceBuilderFactory);
        return this;
    }

    public BiomeBuilder tuyas(int frequency, int baseHeight, int scaleHeight, int volcanoBasaltHeight, boolean icy) {
        this.hasTuyas = true;
        this.tuyaFrequency = frequency;
        this.volcanoBasaltHeight = 63 + volcanoBasaltHeight;
        assert (this.heightNoiseFactory != null) : "volcanoes must be called after setting a heightmap";
        assert (this.surfaceBuilderFactory != null) : "volcanoes must be called after setting a surface builder";
        Function<Seed, Noise2D> baseHeightNoiseFactory = this.heightNoiseFactory;
        this.heightNoiseFactory = seed -> BiomeNoise.addTuyas(seed, (Noise2D)baseHeightNoiseFactory.apply((Seed)seed), frequency, baseHeight, scaleHeight, icy);
        this.noiseFactory = seed -> BiomeNoiseSampler.fromHeightNoise(this.heightNoiseFactory.apply((Seed)seed));
        this.surfaceBuilderFactory = TuyasSurfaceBuilder.create(this.surfaceBuilderFactory);
        return this;
    }

    public BiomeExtension build(ResourceKey<Biome> key) {
        assert (this.surfaceBuilderFactory != null) : "missing surface builder";
        return new BiomeExtension(key, this.noiseFactory, this.surfaceBuilderFactory, this.aquiferSurfaceHeight, this.biomeBlendType, this.riverBlendType, this.shoreBlendType, this.salty, this.volcanic, this.hasTuffRings, this.hasTuyas, this.volcanoFrequency, this.volcanoBasaltHeight, this.tuffRingFrequency, this.tuyaFrequency, this.spawnable, this.rivers, this.shore, this.shoreBaseHeight, this.sandyRiverShores);
    }
}

