/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.AquiferLookahead;
import net.dries007.tfc.world.biome.BiomeBlendType;
import net.dries007.tfc.world.river.RiverBlendType;
import net.dries007.tfc.world.shore.ShoreBlendType;
import net.dries007.tfc.world.surface.builder.SurfaceBuilder;
import net.dries007.tfc.world.surface.builder.SurfaceBuilderFactory;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.Nullable;

public final class BiomeExtension {
    private final ResourceKey<Biome> key;
    @Nullable
    private final Function<Seed, BiomeNoiseSampler> noiseFactory;
    private final AquiferLookahead aquiferSurfaceHeight;
    private final SurfaceBuilderFactory surfaceBuilderFactory;
    private final BiomeBlendType biomeBlendType;
    private final RiverBlendType riverBlendType;
    private final ShoreBlendType shoreBlendType;
    private final boolean salty;
    private final boolean volcanic;
    private final boolean hasTuffCones;
    private final boolean hasTuyas;
    private final int volcanoRarity;
    private final int tuffRingRarity;
    private final int tuyaRarity;
    private final int volcanoBasaltHeight;
    private final boolean spawnable;
    private final boolean rivers;
    private final boolean shore;
    private final int shoreBaseHeight;
    private final boolean sandyRiverShores;
    @Nullable
    private List<HolderSet<PlacedFeature>> flattenedFeatures;
    @Nullable
    private Set<PlacedFeature> flattenedFeatureSet;
    @Nullable
    private Biome prevBiome;

    BiomeExtension(ResourceKey<Biome> key, @Nullable Function<Seed, BiomeNoiseSampler> noiseFactory, SurfaceBuilderFactory surfaceBuilderFactory, AquiferLookahead aquiferSurfaceHeight, BiomeBlendType biomeBlendType, RiverBlendType riverBlendType, ShoreBlendType shoreBlendType, boolean salty, boolean volcanic, boolean hasTuffCones, boolean hasTuyas, int volcanoRarity, int volcanoBasaltHeight, int tuffRingRarity, int tuyaRarity, boolean spawnable, boolean rivers, boolean shore, int shoreBaseHeight, boolean sandyRiverShores) {
        this.key = key;
        this.noiseFactory = noiseFactory;
        this.surfaceBuilderFactory = surfaceBuilderFactory;
        this.aquiferSurfaceHeight = aquiferSurfaceHeight;
        this.biomeBlendType = biomeBlendType;
        this.riverBlendType = riverBlendType;
        this.shoreBlendType = shoreBlendType;
        this.salty = salty;
        this.volcanic = volcanic;
        this.hasTuffCones = hasTuffCones;
        this.hasTuyas = hasTuyas;
        this.volcanoRarity = volcanoRarity;
        this.volcanoBasaltHeight = volcanoBasaltHeight;
        this.tuffRingRarity = tuffRingRarity;
        this.tuyaRarity = tuyaRarity;
        this.spawnable = spawnable;
        this.rivers = rivers;
        this.shore = shore;
        this.shoreBaseHeight = shoreBaseHeight;
        this.sandyRiverShores = sandyRiverShores;
    }

    public ResourceKey<Biome> key() {
        return this.key;
    }

    public BiomeBlendType biomeBlendType() {
        return this.biomeBlendType;
    }

    public RiverBlendType riverBlendType() {
        return this.riverBlendType;
    }

    public ShoreBlendType shoreBlendType() {
        return this.shoreBlendType;
    }

    public boolean hasSandyRiverShores() {
        return this.sandyRiverShores;
    }

    public boolean isSalty() {
        return this.salty;
    }

    public boolean isVolcanic() {
        return this.volcanic;
    }

    public boolean hasTuffRings() {
        return this.hasTuffCones;
    }

    public boolean hasTuyas() {
        return this.hasTuyas;
    }

    public boolean isSpawnable() {
        return this.spawnable;
    }

    public boolean hasRivers() {
        return this.rivers;
    }

    public boolean isShore() {
        return this.shore;
    }

    public int getShoreBaseHeight() {
        return this.shoreBaseHeight;
    }

    public int getVolcanoRarity() {
        return this.volcanoRarity;
    }

    public int getTuffRingRarity() {
        return this.tuffRingRarity;
    }

    public int getTuyaRarity() {
        return this.tuyaRarity;
    }

    public int getVolcanoBasaltHeight() {
        return this.volcanoBasaltHeight;
    }

    public double getAquiferSurfaceHeight(BiomeNoiseSampler sampler, int x, int z) {
        return this.aquiferSurfaceHeight.getHeight(sampler, x, z);
    }

    @Nullable
    public BiomeNoiseSampler createNoiseSampler(Seed seed) {
        return this.noiseFactory != null ? this.noiseFactory.apply(seed) : null;
    }

    public SurfaceBuilder createSurfaceBuilder(Seed seed) {
        return this.surfaceBuilderFactory.apply(seed);
    }

    public List<HolderSet<PlacedFeature>> getFlattenedFeatures(Biome biome) {
        if (biome != this.prevBiome) {
            this.prevBiome = biome;
            this.flattenedFeatures = null;
        }
        if (this.flattenedFeatures == null) {
            this.flattenedFeatures = biome.getGenerationSettings().features();
            this.flattenedFeatureSet = this.flattenedFeatures.stream().flatMap(HolderSet::stream).map(Holder::value).collect(Collectors.toSet());
        }
        return this.flattenedFeatures;
    }

    public Set<PlacedFeature> getFlattenedFeatureSet(Biome biome) {
        this.getFlattenedFeatures(biome);
        return Objects.requireNonNull(this.flattenedFeatureSet);
    }
}

