/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import java.util.Random;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.BiomeNoiseSampler;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.TuffRingNoise;
import net.dries007.tfc.world.biome.TuyaNoise;
import net.dries007.tfc.world.biome.VolcanoNoise;
import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.Noise3D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.noise.OpenSimplex3D;
import net.minecraft.util.Mth;

public final class BiomeNoise {
    public static Noise2D connectedValleyBaseNoise(long seed) {
        return new OpenSimplex2D(seed).spread(0.0025);
    }

    public static Noise2D connectedValleyNoise(long seed) {
        return BiomeNoise.connectedValleyBaseNoise(seed).abs();
    }

    public static Noise2D badlands(long seed, int height, float depth) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.025f).scaled(63 + height, 63 + height + 10).add(new OpenSimplex2D(seed + 1L).octaves(4).spread(0.04f).ridged().map(x -> (double)1.3f * -(x > 0.0 ? x * x * x : 0.5 * x)).scaled(-1.0, 0.3f, -1.0, 1.0).terraces(15).scaled(-depth, 0.0)).map(x -> x < 63.0 ? 63.0 - (double)0.3f * (63.0 - x) : x);
    }

    public static Noise2D bryceCanyon(long seed) {
        Random generator = new Random(seed);
        Noise2D noise = new OpenSimplex2D(generator.nextLong()).octaves(4).spread(0.1f).scaled(65.0, 77.0);
        for (int layer = 0; layer < 3; ++layer) {
            float threshold = 0.25f;
            float delta = 0.015f;
            noise = noise.add(new OpenSimplex2D(generator.nextLong()).octaves(3).spread(0.02f + 0.01f * (float)layer).abs().affine(1.0, -0.05f * (float)layer).map(t -> Mth.clampedMap((double)t, (double)0.25, (double)0.265f, (double)0.0, (double)1.0)).lazyProduct(new OpenSimplex2D(generator.nextLong()).octaves(4).spread(0.1f).scaled(5.0, 11.0)));
        }
        return noise;
    }

    public static Noise2D canyons(long seed, int minHeight, int maxHeight) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(4).spread(0.03f).scaled(-100.0, 100.0);
        return new OpenSimplex2D(seed + 1L).octaves(4).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, 63 + minHeight, 63 + maxHeight);
    }

    public static Noise2D hills(long seed, int minHeight, int maxHeight) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.05f).scaled(63 + minHeight, 63 + maxHeight);
    }

    public static Noise2D constant(int height) {
        return (x, z) -> 63 + height;
    }

    public static Noise2D sharpHills(long seed, float minMeight, float maxHeight) {
        OpenSimplex2D base = new OpenSimplex2D(seed).octaves(4).spread(0.08f);
        Noise2D lerp = new OpenSimplex2D(seed + 7198234123L).spread(0.013f).scaled(-0.3f, 1.6f).clamped(0.0, 1.0);
        Noise2D lerpMapped = (x, z) -> {
            double in = base.noise(x, z);
            return Mth.lerp((double)lerp.noise(x, z), (double)in, (double)BiomeNoise.sharpHillsMap(in));
        };
        OpenSimplex2D variance = new OpenSimplex2D(seed + 67981832123L).octaves(3).spread(0.06f).scaled(-0.2f, 0.2f);
        return lerpMapped.add(variance).scaled(-0.75, 0.7f, 63.0f - minMeight, 63.0f + maxHeight);
    }

    public static Noise2D glacialSurfaceTexture(long seed) {
        OpenSimplex2D warp = new OpenSimplex2D(seed + 413L).spread(0.02).scaled(-12.0, 12.0);
        return (x, z) -> {
            double yOfX = Math.min(Helpers.triangle(25.0, 18.0, 0.035, x + warp.noise(x, z)), 0.0);
            double yOfZ = Math.min(Helpers.triangle(40.0, 30.0, 0.025, z + warp.noise(z, x)), 0.0);
            return Math.min(yOfX, yOfZ);
        };
    }

    public static Noise2D glacialBase(long seed) {
        return BiomeNoise.knobAndKettle(seed).addConstant(1.5);
    }

    public static Noise2D glacialOceanicBase(long seed) {
        return (x, z) -> 59.0;
    }

    public static Noise2D iceSheetSurfaceHeight(long seed) {
        return BiomeNoise.hills(seed, 23, 38);
    }

    public static Noise2D montaneIceSheetSurfaceHeight(long seed) {
        return BiomeNoise.hills(seed, 40, 48);
    }

    public static Noise2D oceanicIceSheetSurfaceHeight(long seed) {
        return BiomeNoise.hills(seed, 18, 26);
    }

    public static Noise2D glacialCirquesIceSurfaceHeight(long seed) {
        return BiomeNoise.connectedValleyNoise(seed).map(y -> y < 0.38 ? -100.0 : (y < 0.43 ? Mth.map((double)y, (double)0.38, (double)0.43, (double)-50.0, (double)0.0) : Mth.map((double)y, (double)0.43, (double)1.0, (double)0.0, (double)32.0))).add(BiomeNoise.hills(seed, 15, 23).add(BiomeNoise.glacialCirquesCliffsScale(seed)));
    }

    public static Noise2D glacialCirquesCliffsStartHeight(long seed) {
        return BiomeNoise.connectedValleyNoise(seed).map(y -> y < 0.43 ? Mth.map((double)y, (double)0.0, (double)0.43, (double)32.0, (double)0.0) : Mth.map((double)y, (double)0.43, (double)1.0, (double)0.0, (double)32.0)).add(BiomeNoise.hills(seed, 18, 26));
    }

    public static Noise2D glacialCirquesCliffsScale(long seed) {
        return new OpenSimplex2D(seed + 78267L).spread(0.015).add(BiomeNoise.glacialValleyShapeNoise(seed)).scaled(-10.0, 8.0).clamped(0.0, 7.0);
    }

    public static Noise2D glacialValleyShapeNoise(long seed) {
        return BiomeNoise.connectedValleyBaseNoise(seed).map(y -> Math.min(6.0 * y * y, 0.75 + 0.25 * y)).add(new OpenSimplex2D(seed + 5287L).octaves(4).spread(0.06).scaled(-0.2, 0.2));
    }

    public static Noise2D glacialCirques(long seed) {
        Noise2D shape = BiomeNoise.glacialValleyShapeNoise(seed);
        Noise2D shapeMap = BiomeNoise.connectedValleyNoise(seed);
        double cellScale = 0.01;
        Cellular2D cells = new Cellular2D(seed, 2).spread(0.01);
        Noise2D warp = new OpenSimplex2D(seed).spread(0.02).add(shapeMap).scaled(-1.0, 2.0, -0.25, 0.2);
        OpenSimplex2D roughPeaks = new OpenSimplex2D(seed).octaves(3).spread(0.08).scaled(0.6, 1.6);
        Noise2D cliffScale = new OpenSimplex2D(seed + 785267L).spread(0.01).scaled(-12.0, 15.0).clamped(0.0, 10.0);
        Noise2D cliffStartHeight = BiomeNoise.oceanicIceSheetSurfaceHeight(seed).addConstant(-8.0);
        Noise2D cirques = (x, z) -> {
            Cellular2D.Cell cell = cells.cell(x, z);
            double f1 = cell.f1();
            double f2 = cell.f2();
            double f2f1 = f1 > 0.0 ? f2 - f1 : 1.0;
            double shapeAtCenter = shapeMap.noise((double)cell.cx() / 0.01, (double)cell.cy() / 0.01);
            if (shapeAtCenter > 0.6) {
                double y = f2f1 + warp.noise(x, z);
                double rough = roughPeaks.noise(x, z);
                double scale = Math.min(Helpers.lerp(2.0 * y, 1.0, rough), rough);
                y = 1.0 + scale * y;
                return y;
            }
            double y = 1.0 - (f2f1 - warp.noise(x, z));
            y = 0.5 * (1.0 + y * y);
            double shapeAtPoint = shapeMap.noise(x, z);
            double valleyCloseness = Math.min(shapeAtPoint - shapeAtCenter, 0.0);
            return y + Mth.clampedMap((double)f2f1, (double)0.0, (double)0.1, (double)0.0, (double)valleyCloseness);
        };
        return cirques.scaled(0.0, 1.0, 12.0, 64.0).lazyProduct(shape).addConstant(48.0).cliffMap(cliffStartHeight, cliffScale).cliffMap(BiomeNoise.glacialCirquesCliffsStartHeight(seed), BiomeNoise.glacialCirquesCliffsScale(seed));
    }

    public static Noise2D patternedGround(long seed) {
        Cellular2D cells = new Cellular2D(seed, 0.25f, 1).spread(0.05);
        return (x, z) -> {
            Cellular2D.Cell cell = cells.cell(x, z);
            return cell.f2() - cell.f1() < 0.12 ? -1.0 : 0.0;
        };
    }

    public static Noise2D invertedPatternedGround(long seed) {
        Noise2D base = BiomeNoise.hills(seed, -4, 3);
        Cellular2D cells = new Cellular2D(seed, 0.25f, 1).spread(0.05);
        return (x, z) -> {
            double height = base.noise(x, z);
            Cellular2D.Cell cell = cells.cell(x, z);
            double f2f1 = cell.f2() - cell.f1();
            if (height >= 63.0) {
                return height + (double)(f2f1 < 0.12 ? 1 : 0);
            }
            return f2f1 < 0.12 ? 62.0 : (f2f1 < 0.22 ? 61.0 : 60.0);
        };
    }

    public static Noise2D seaIceNoise(long seed) {
        Cellular2D cells = new Cellular2D(seed, 0.21f, 1).spread(0.03);
        OpenSimplex2D wiggle = new OpenSimplex2D(seed).scaled(-0.04, 0.04).spread(0.12);
        return (x, z) -> {
            Cellular2D.Cell cell = cells.cell(x, z);
            return cell.f2() - cell.f1() + wiggle.noise(x, z);
        };
    }

    public static Noise2D stoneCircles(long seed) {
        Cellular2D cells = new Cellular2D(seed, 0.26f, 1).spread(0.09);
        return (x, z) -> {
            Cellular2D.Cell cell = cells.cell(x, z);
            double f1 = cell.f1();
            return f1 > 0.06 && f1 < 0.13 ? 1.0 : 0.0;
        };
    }

    public static Noise2D knobAndKettle(long seed) {
        return new OpenSimplex2D(seed).octaves(2).spread(0.03f).map(y -> y > 0.3 ? y - 0.3 : (y < -0.3 ? y + 0.3 : 0.0)).scaled(-12.0, 10.0).add(BiomeNoise.hills(seed, -3, 3));
    }

    public static Noise2D drumlins(long seed) {
        return new OpenSimplex2D(seed).octaves(3).spread(0.04f).scaled(47.0, 95.0).stretchZ(2.5);
    }

    public static Noise2D burren(long seed, Noise2D baseTerrainNoise, double scale) {
        int minHeight = 65;
        Noise2D crevices = BiomeNoise.burrenCrevices(seed).map(y -> y < 0.15 ? -scale : (y < 0.4 ? (y - 0.4) * scale : 0.0));
        return crevices.add(baseTerrainNoise).map(y -> Math.max(y, 65.0));
    }

    public static Noise2D burrenCrevices(long seed) {
        return new OpenSimplex2D(seed + 398767567L).octaves(2).spread(0.08f).abs();
    }

    public static Noise2D shilin(long seed, Noise2D baseTerrainNoise, double scale) {
        int minHeight = 65;
        Noise2D ridges = BiomeNoise.shilinRidges(seed);
        OpenSimplex2D bumps = new OpenSimplex2D(seed + 83436545633L).spread(0.16).scaled(0.6, 1.0);
        return ridges.lazyProduct(bumps).scaled(63.0, 63.0 + scale).max(baseTerrainNoise).map(y -> Math.max(y, 65.0));
    }

    public static Noise2D shilinRidges(long seed) {
        double widthTop = 0.1;
        double widthBot = 0.2;
        Noise2D ridges = new OpenSimplex2D(seed + 398767567L).octaves(2).spread(0.06f).map(y -> (y = Math.abs(y)) < 0.1 ? 1.0 : (y < 0.2 ? 1.0 + 0.67 * (y - 0.1) / -0.1 : 0.0));
        Noise2D cuts = new OpenSimplex2D(seed + 45764379L).octaves(2).spread(0.03f).map(y -> {
            y = (y = Math.abs(y)) < 0.065 ? 1.0 : (y < 0.24 ? 1.0 + (y - 0.065) / -0.175 : 0.0);
            return 1.0 - y;
        });
        return ridges.lazyProduct(cuts);
    }

    public static Noise2D fengcong(long seed, Noise2D baseTerrainNoise) {
        double scale = 37.0;
        Noise2D cones = new OpenSimplex2D(seed).octaves(3).spread(0.06).map(y -> {
            y = -0.5 * Math.cos(Math.PI * Math.abs(y)) + 0.5;
            y = (Math.max(y, 0.25) - 0.25) / 0.75;
            y = 37.0 * y;
            return y;
        });
        return baseTerrainNoise.add(cones);
    }

    public static Noise2D fenglin(long seed, Noise2D baseTerrainNoise, double scale) {
        OpenSimplex2D cliffScale = new OpenSimplex2D(seed + 78535267L).spread(0.06).scaled(0.0, 0.25);
        OpenSimplex2D cliffStartHeight = new OpenSimplex2D(seed + 390798L).spread(0.06).scaled(0.0, 0.7);
        Noise2D cliffBase = new OpenSimplex2D(seed).octaves(2).spread(0.05).map(y -> {
            y = (y = Math.abs(y) - 0.45) > 0.0 ? Math.sqrt(y / 0.55) : 0.0;
            return y;
        });
        Noise2D towers = BiomeNoise.fenglinCliffMap(cliffBase, cliffStartHeight, cliffScale).map(y -> scale * y);
        return baseTerrainNoise.add(towers);
    }

    public static Noise2D bowlDolines(long seed, Noise2D baseTerrainNoise, double scale) {
        Noise2D bowls = new OpenSimplex2D(seed).octaves(3).spread(0.72 / scale).map(x -> {
            x = -0.5 * Math.cos(Math.PI * x) + 0.5;
            x = Math.max(x, 0.1) - 0.1;
            x = -scale * x;
            return x;
        });
        return baseTerrainNoise.add(bowls);
    }

    public static Noise2D cenotes(long seed, Noise2D baseTerrainNoise, double vertScale, double horizScale) {
        OpenSimplex2D cliffScale = new OpenSimplex2D(seed + 78535267L).spread(0.72 / horizScale).scaled(0.0, 0.4);
        OpenSimplex2D cliffStartHeight = new OpenSimplex2D(seed + 390798L).spread(0.72 / horizScale).scaled(0.0, 0.7);
        Noise2D cliffBase = new OpenSimplex2D(seed).octaves(2).spread(0.6 / horizScale).map(y -> {
            y = (y = Math.abs(y) - 0.45) > 0.0 ? Math.sqrt(y / 0.55) : 0.0;
            return y;
        });
        Noise2D cenotes = BiomeNoise.fenglinCliffMap(cliffBase, cliffStartHeight, cliffScale).map(y -> -vertScale * y);
        return baseTerrainNoise.add(cenotes);
    }

    public static Noise2D tiankeng(long seed, Noise2D baseTerrainNoise) {
        OpenSimplex2D cliffScale = new OpenSimplex2D(seed + 78535267L).spread(0.04).scaled(0.0, 0.04);
        OpenSimplex2D cliffStartHeight = new OpenSimplex2D(seed + 390798L).spread(0.04).scaled(0.0, 0.7);
        Noise2D wideCliffBase = new OpenSimplex2D(seed).octaves(2).spread(0.02).map(y -> {
            y = (y = Math.abs(y) - 0.3) > 0.0 ? Math.sqrt(y / 0.7) : 0.0;
            return y;
        });
        Noise2D deepCliffBase = new OpenSimplex2D(seed).octaves(2).spread(0.02).map(y -> {
            y = (y = Math.abs(y) - 0.65) > 0.0 ? Math.sqrt(y / 0.35) : 0.0;
            return y;
        });
        return (x, z) -> {
            double compare = cliffStartHeight.noise(x, z);
            double addend = cliffScale.noise(x, z);
            double wideBase = wideCliffBase.noise(x, z);
            double deepBase = deepCliffBase.noise(x, z);
            return baseTerrainNoise.noise(x, z) + -22.0 * (wideBase > compare ? wideBase * (1.0 - addend) + addend : wideBase) + -24.0 * (deepBase > compare ? deepBase * (1.0 - addend) + addend : deepBase);
        };
    }

    public static Noise2D fenglinCliffMap(Noise2D baseNoise, Noise2D compareNoise, Noise2D addendNoise) {
        return (x, z) -> {
            double base = baseNoise.noise(x, z);
            if (base > compareNoise.noise(x, z)) {
                double addend = addendNoise.noise(x, z);
                return base * (1.0 - addend) + addend;
            }
            return base;
        };
    }

    public static double sharpHillsMap(double in) {
        double in0 = 1.0;
        double in1 = 0.67f;
        double in2 = 0.15f;
        double in3 = -0.15f;
        double in4 = -0.67f;
        double in5 = -1.0;
        double out0 = 1.0;
        double out1 = 0.7f;
        double out2 = 0.5;
        double out3 = -0.5;
        double out4 = -0.7f;
        double out5 = -1.0;
        if (in > (double)0.67f) {
            return Mth.map((double)in, (double)0.67f, (double)1.0, (double)0.7f, (double)1.0);
        }
        if (in > (double)0.15f) {
            return Mth.map((double)in, (double)0.15f, (double)0.67f, (double)0.5, (double)0.7f);
        }
        if (in > (double)-0.15f) {
            return Mth.map((double)in, (double)-0.15f, (double)0.15f, (double)-0.5, (double)0.5);
        }
        if (in > (double)-0.67f) {
            return Mth.map((double)in, (double)-0.67f, (double)-0.15f, (double)-0.7f, (double)-0.5);
        }
        return Mth.map((double)in, (double)-1.0, (double)-0.67f, (double)-1.0, (double)-0.7f);
    }

    public static Noise2D lake(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.15f).scaled(51.0, 65.0).add(new OpenSimplex2D(seed + 1L).octaves(5).spread(0.1f).map(val -> val * val * val * val).scaled(-2.0, 2.0).clamped(0.0, 2.0));
    }

    public static Noise2D lowlands(long seed) {
        return BiomeNoise.hills(seed, -3, -2).add(new OpenSimplex2D(seed + 1L).octaves(6).spread(0.55f).scaled(-2.0, 2.0).clamped(-2.0, 1.0));
    }

    public static Noise2D flats(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.03f).scaled(51.0, 71.0).clamped(63.0, 65.0);
    }

    public static Noise2D saltFlats(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.05f).scaled(47.0, 73.0).clamped(61.0, 63.0);
    }

    public static Noise2D dunes(long seed, int minHeight, int maxHeight) {
        return new OpenSimplex2D(seed).spread(0.02).scaled(-3.0, 3.0).add((x, z) -> x / 6.0 + 20.0 * Math.sin(z / 240.0)).map(value -> 1.3 * (Math.abs(value % 5.0 - 1.0) * (value % 5.0 - value % 1.0 > 0.0 ? 0.5 : 2.0) - 1.0)).clamped(-1.0, 1.0).lazyProduct(new OpenSimplex2D(seed).octaves(4).spread(0.1).scaled(-1.0, 2.0).clamped(0.4, 1.0)).scaled(63 + minHeight, 63 + maxHeight);
    }

    public static Noise2D stairCanyons(long seed) {
        int minHeight = 67;
        int plateauHeight = 85;
        return BiomeNoise.stairStepCliffs(seed, BiomeNoise.canyonBaseNoise(seed, 67, 85, 0.05)).add(new OpenSimplex2D(seed).octaves(3).spread(0.08).scaled(-5.0, 5.0));
    }

    public static Noise2D mesas(long seed) {
        int minHeight = 67;
        int plateauHeight = 85;
        return BiomeNoise.stairStepCliffs(seed, BiomeNoise.canyonBaseNoise(seed, 67, 85, 0.12)).add(new OpenSimplex2D(seed).octaves(3).spread(0.08).scaled(-5.0, 5.0));
    }

    public static Noise2D buttes(long seed) {
        int minHeight = 67;
        int plateauHeight = 85;
        return BiomeNoise.stairStepCliffs(seed, BiomeNoise.canyonBaseNoise(seed, 67, 85, 0.18)).add(new OpenSimplex2D(seed).octaves(3).spread(0.08).scaled(-5.0, 5.0));
    }

    public static Noise2D hoodoos(long seed) {
        int minHeight = 67;
        int maxHeight = 85;
        Noise2D maxBaseNoise = BiomeNoise.canyonBaseNoise(seed, 67, 85, 0.03);
        Noise2D minBaseNoise = BiomeNoise.canyonBaseNoise(seed, 67, 85, 0.2);
        Noise2D hoodooNoise = new OpenSimplex2D(seed + 1L).octaves(3).spread(0.12f).abs().clampedScaled(0.2, 0.6, 67.0, 85.0);
        return BiomeNoise.stairStepCliffs(seed, maxBaseNoise.min(hoodooNoise).max(minBaseNoise), 5, 8, 7).add(new OpenSimplex2D(seed).octaves(3).spread(0.08).scaled(-3.0, 3.0));
    }

    public static Noise2D tableMountains(long seed) {
        int minHeight = 79;
        int plateauHeight = 111;
        return BiomeNoise.stairStepCliffs(seed, BiomeNoise.canyonBaseNoise(seed, 79, 111, 0.1), 20, 30, 10);
    }

    public static Noise2D canyonBaseNoise(long seed, int minHeight, int maxHeight, double valleyWidth) {
        double valleyEdge = valleyWidth + 0.28;
        return new OpenSimplex2D(seed + 1L).octaves(4).spread(0.03f).abs().clampedScaled(valleyWidth, valleyEdge, minHeight, maxHeight);
    }

    public static Noise2D stairStepCliffs(long seed, Noise2D input) {
        return BiomeNoise.stairStepCliffs(seed, input, 5, 12, 7);
    }

    public static Noise2D stairStepCliffs(long seed, Noise2D input, int minCliffStart, int maxCliffStart, int cliffHeight) {
        OpenSimplex2D cliffStartHeightNoise = new OpenSimplex2D(seed + 3L).octaves(2).spread(0.008f).scaled(63 + minCliffStart, 63 + maxCliffStart);
        Noise2D cliffNoise = new OpenSimplex2D(seed + 7L).spread(0.003f).scaled(-cliffHeight, 2 * cliffHeight).clamped(0.0, cliffHeight);
        Noise2D doubleCliffNoise = cliffNoise.add(cliffNoise);
        Noise2D secondCliffStartHeightNoise = cliffStartHeightNoise.add(doubleCliffNoise);
        Noise2D secondCliffNoise = new OpenSimplex2D(seed + 19L).spread(0.003f).scaled(-cliffHeight, 2 * cliffHeight).clamped(0.0, cliffHeight);
        Noise2D thirdCliffStartHeightNoise = secondCliffStartHeightNoise.add(doubleCliffNoise);
        Noise2D thirdCliffNoise = new OpenSimplex2D(seed + 25L).spread(0.003f).scaled(-cliffHeight, 2 * cliffHeight).clamped(0.0, cliffHeight);
        OpenSimplex2D slopeNoise = new OpenSimplex2D(seed + 33L).spread(0.008).scaled(-2.0, 2.0);
        return input.slopedCliffMap(cliffStartHeightNoise, cliffNoise, cliffNoise.scaled(0.0, 7.0, 3.0, 6.0).add(slopeNoise)).slopedCliffMap(secondCliffStartHeightNoise, secondCliffNoise, cliffNoise.scaled(0.0, 7.0, 3.0, 6.0).add(slopeNoise)).slopedCliffMap(thirdCliffStartHeightNoise, thirdCliffNoise, cliffNoise.scaled(0.0, 7.0, 3.0, 6.0).add(slopeNoise));
    }

    public static Noise2D mountains(long seed, int baseHeight, int scaleHeight) {
        Noise2D baseNoise = new OpenSimplex2D(seed).octaves(6).spread(0.14f).add(new OpenSimplex2D(seed + 1L).octaves(4).spread(0.02f).scaled(-0.7f, 0.7f).ridged()).map(x -> {
            double x0 = 0.125 * (x + 1.0) * (x + 1.0) * (x + 1.0);
            return (double)(63 + baseHeight) + (double)scaleHeight * x0;
        });
        Noise2D cliffNoise = new OpenSimplex2D(seed + 2L).octaves(2).spread(0.01f).scaled(-25.0, 25.0).map(x -> x > 0.0 ? x : 0.0);
        OpenSimplex2D cliffHeightNoise = new OpenSimplex2D(seed + 3L).octaves(2).spread(0.01f).scaled(120.0, 160.0);
        return (x, z) -> {
            double cliffHeight;
            double height = baseNoise.noise(x, z);
            if (height > 120.0 && (cliffHeight = cliffHeightNoise.noise(x, z) - height) < 0.0) {
                double mappedCliffHeight = Mth.clampedMap((double)cliffHeight, (double)0.0, (double)-1.0, (double)0.0, (double)1.0);
                height += mappedCliffHeight * cliffNoise.noise(x, z);
            }
            return height;
        };
    }

    public static Noise2D rockyIslands(long seed) {
        Noise2D baseNoise = new OpenSimplex2D(seed).octaves(4).spread(0.14f).map(x -> {
            double x0 = 0.125 * (x + 1.0) * (x + 1.0) * (x + 1.0);
            return 48.0 + 50.0 * x0;
        });
        Noise2D cliffNoise = new OpenSimplex2D(seed + 2L).octaves(2).spread(0.01f).scaled(-10.0, 18.0).map(x -> x > 0.0 ? x : 0.0);
        OpenSimplex2D cliffHeightNoise = new OpenSimplex2D(seed + 3L).octaves(2).spread(0.01f).scaled(58.0, 68.0);
        return (x, z) -> {
            double cliffHeight;
            double height = baseNoise.noise(x, z);
            if (height > 53.0 && (cliffHeight = cliffHeightNoise.noise(x, z) - height) < 0.0) {
                double mappedCliffHeight = Mth.clampedMap((double)cliffHeight, (double)0.0, (double)-1.0, (double)0.0, (double)1.0);
                height += mappedCliffHeight * cliffNoise.noise(x, z);
            }
            return height;
        };
    }

    public static Noise2D ocean(long seed, int depthMin, int depthMax) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(2).spread(0.015f).scaled(-30.0, 30.0);
        return new OpenSimplex2D(seed + 1L).octaves(4).spread(0.11f).scaled(63 + depthMin, 63 + depthMax).warped(warp);
    }

    public static Noise2D oceanRidge(long seed, int depthMin, int depthMax) {
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(2).spread(0.015f).scaled(-30.0, 30.0);
        Noise2D ridgeNoise = new OpenSimplex2D(seed + 1L).octaves(4).spread(0.015f).ridged().map(x -> {
            if (x > (double)-0.3f) {
                x = (x + (double)0.3f) / (double)1.3f;
                x = x * x * x;
                return -16.0 * x;
            }
            return 0.0;
        });
        return new OpenSimplex2D(seed + 2L).octaves(4).spread(0.11f).scaled(63 + depthMin, 63 + depthMax).add(ridgeNoise).warped(warp);
    }

    public static Noise2D shore(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.17f).scaled(63.0, 68.0);
    }

    public static Noise2D tidalFlats(long seed) {
        return new OpenSimplex2D(seed).octaves(4).spread(0.17f).scaled(63.0, 64.8f);
    }

    public static Noise2D activeShieldVolcano(long seed, Noise2D hotspot) {
        double edgeElev = 64.0;
        double calderaEdgeElev = 178.0;
        double cliffEdgeElev = 153.0;
        double calderaCenterElev = 123.0;
        Noise2D volcano = hotspot.map(y -> y < 0.75 ? Mth.map((double)y, (double)0.0, (double)0.75, (double)64.0, (double)178.0) : (y < 0.78 ? Mth.map((double)y, (double)0.75, (double)0.78, (double)178.0, (double)153.0) : Mth.map((double)y, (double)0.78, (double)1.0, (double)153.0, (double)123.0)));
        Noise2D flows = BiomeNoise.lavaFlow(seed).map(y -> y < 0.45 ? 0.0 : 1.0);
        OpenSimplex2D warp = new OpenSimplex2D(seed).octaves(4).spread(0.03f).scaled(-100.0, 100.0);
        Noise2D surface = new OpenSimplex2D(seed + 1L).octaves(4).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, -8.0, 8.0);
        return volcano.add(flows).add(surface);
    }

    public static Noise2D dormantShieldVolcano(long seed, Noise2D hotspot) {
        double seaElev = 72.0;
        double mtnBaseElev = 103.0;
        double calderaEdgeElev = 133.0;
        double cliffEdgeElev = 113.0;
        double calderaCenterElev = 78.0;
        Noise2D volcano = hotspot.map(y -> y < 0.45 ? Mth.map((double)y, (double)0.0, (double)0.45, (double)72.0, (double)103.0) : (y < 0.7 ? Mth.map((double)y, (double)0.45, (double)0.7, (double)103.0, (double)133.0) : (y < 0.73 ? Mth.map((double)y, (double)0.7, (double)0.73, (double)133.0, (double)113.0) : (y < 0.85 ? Mth.map((double)y, (double)0.73, (double)0.85, (double)113.0, (double)78.0) : 78.0))));
        OpenSimplex2D warp = new OpenSimplex2D(seed + 43L).octaves(4).spread(0.03f).scaled(-100.0, 100.0);
        Noise2D surface = new OpenSimplex2D(seed + 44L).octaves(4).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, -12.0, 12.0);
        return volcano.add(surface);
    }

    public static Noise2D extinctShieldVolcano(long seed, Noise2D hotspot) {
        double seaElev = 69.0;
        double mtnBaseElev = 88.0;
        double calderaEdgeElev = 118.0;
        double cliffEdgeElev = 88.0;
        double calderaCenterElev = 53.0;
        Noise2D volcano = hotspot.map(y -> y < 0.4 ? Mth.map((double)y, (double)0.0, (double)0.4, (double)69.0, (double)88.0) : (y < 0.6 ? Mth.map((double)y, (double)0.4, (double)0.6, (double)88.0, (double)118.0) : (y < 0.62 ? Mth.map((double)y, (double)0.6, (double)0.62, (double)118.0, (double)88.0) : (y < 0.75 ? Mth.map((double)y, (double)0.62, (double)0.75, (double)88.0, (double)53.0) : 53.0))));
        OpenSimplex2D warp = new OpenSimplex2D(seed + 43L).octaves(4).spread(0.03f).scaled(-100.0, 100.0);
        Noise2D surface = new OpenSimplex2D(seed + 44L).octaves(4).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, -9.0, 9.0);
        return volcano.add(surface);
    }

    public static Noise2D glaciatedShieldVolcano(long seed, Noise2D hotspot) {
        double seaElev = 78.0;
        double mtnBaseElev = 133.0;
        double calderaEdgeElev = 163.0;
        double cliffEdgeElev = 123.0;
        double calderaCenterElev = 113.0;
        Noise2D volcano = hotspot.map(y -> y < 0.45 ? Mth.map((double)y, (double)0.0, (double)0.45, (double)78.0, (double)133.0) : (y < 0.72 ? Mth.map((double)y, (double)0.45, (double)0.72, (double)133.0, (double)163.0) : (y < 0.74 ? Mth.map((double)y, (double)0.72, (double)0.74, (double)163.0, (double)123.0) : (y < 0.85 ? Mth.map((double)y, (double)0.74, (double)0.85, (double)123.0, (double)113.0) : 113.0))));
        OpenSimplex2D warp = new OpenSimplex2D(seed + 43L).octaves(4).spread(0.03f).scaled(-100.0, 100.0);
        Noise2D surface = new OpenSimplex2D(seed + 44L).octaves(4).spread(0.02f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, -48.0, 32.0);
        return volcano.add(surface);
    }

    public static Noise2D shieldVolcanoIceSheetSurface(long seed, Noise2D hotspot) {
        double edgeElev = 0.0;
        double calderaCenterElev = 51.0;
        return hotspot.map(y -> y < 0.9 ? Mth.map((double)y, (double)0.0, (double)0.9, (double)0.0, (double)51.0) : 51.0).add(BiomeNoise.iceSheetSurfaceHeight(seed));
    }

    public static Noise2D shieldVolcanoGlacierSurface(long seed, Noise2D hotspot) {
        OpenSimplex2D base = new OpenSimplex2D(seed).octaves(3).spread(0.05f).scaled(-5.0, 5.0);
        double lowElev = 3.0;
        double edgeElev = 138.0;
        double calderaRimElev = 155.0;
        double calderaCenterElev = 161.0;
        return hotspot.map(y -> y < 0.4 ? 3.0 : (y < 0.58 ? Mth.map((double)y, (double)0.4, (double)0.58, (double)3.0, (double)138.0) : (y < 0.72 ? Mth.map((double)y, (double)0.58, (double)0.72, (double)138.0, (double)155.0) : (y < 0.9 ? Mth.map((double)y, (double)0.72, (double)0.9, (double)155.0, (double)161.0) : 161.0)))).add(base);
    }

    public static Noise2D sunkenShieldVolcano(long seed, Noise2D hotspot) {
        Noise2D volcano = hotspot.map(y -> y < 0.25 ? 50.0 : (y < 0.45 ? Mth.map((double)y, (double)0.25, (double)0.45, (double)50.0, (double)63.0) : (y < 0.6 ? Mth.map((double)y, (double)0.45, (double)0.6, (double)63.0, (double)95.0) : (y < 0.62 ? Mth.map((double)y, (double)0.6, (double)0.62, (double)94.0, (double)80.0) : (y < 0.75 ? Mth.map((double)y, (double)0.62, (double)0.75, (double)80.0, (double)52.0) : 52.0)))));
        OpenSimplex2D warp = new OpenSimplex2D(seed + 43L).octaves(4).spread(0.03f).scaled(-100.0, 100.0);
        Noise2D surface = new OpenSimplex2D(seed + 44L).octaves(4).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, -6.0, 6.0);
        OpenSimplex2D scale = new OpenSimplex2D(seed + 789913L).octaves(2).spread(0.008f).scaled(0.45, 1.0);
        return volcano.lazyProduct(scale).add(surface);
    }

    public static Noise2D ancientShieldVolcano(long seed, double minElev, double maxElev, Noise2D hotspot) {
        Noise2D volcano = hotspot.map(y -> y < 0.15 ? 90.0 : (y < 0.6 ? Mth.map((double)y, (double)0.15, (double)0.6, (double)90.0, (double)130.0) : (y < 0.63 ? Mth.map((double)y, (double)0.6, (double)0.63, (double)129.0, (double)108.0) : (y < 0.7 ? Mth.map((double)y, (double)0.63, (double)0.7, (double)108.0, (double)90.0) : 90.0))));
        OpenSimplex2D warp = new OpenSimplex2D(seed + 43L).octaves(4).spread(0.03f).scaled(-100.0, 100.0);
        Noise2D surface = new OpenSimplex2D(seed + 44L).octaves(4).spread(0.06f).warped(warp).map(x -> x > 0.4 ? x - (double)0.8f : -x).scaled(-0.4f, 0.8f, -20.0, 0.0);
        Noise2D valleys = new OpenSimplex2D(seed + 90183L).spread(0.01).ridged().octaves(3).scaled(maxElev * 2.2, minElev);
        OpenSimplex2D scale = new OpenSimplex2D(seed + 789913L).octaves(2).spread(0.008f).scaled(0.6, 1.0);
        return volcano.lazyProduct(scale).min(valleys).add(surface);
    }

    public static Noise2D lavaFlow(long seed) {
        return new OpenSimplex2D(seed + 23891L).ridged().spread(0.01);
    }

    public static Noise2D lavaFlowMaterial(long seed) {
        return new OpenSimplex2D(seed).octaves(2).spread(0.25);
    }

    public static Noise2D activeHotSpots(long seed) {
        double horizontalScale = 0.003;
        double cutoff = 0.75;
        double rescale = 7.2;
        Noise2D hotspots = new OpenSimplex2D(seed).map(y -> {
            y = y > 0.75 ? y - 0.75 : 0.0;
            return y *= 7.2;
        }).octaves(3).spread(0.003);
        return hotspots;
    }

    public static Noise2D dormantHotSpots(long seed) {
        return BiomeNoise.hotSpotWarp(BiomeNoise.activeHotSpots(seed), BiomeNoise.plateRegions(seed), 1024, 0.0).map(y -> Math.max(y - 0.1, 0.0) * 1.111);
    }

    public static Noise2D extinctHotSpots(long seed) {
        return BiomeNoise.hotSpotWarp(BiomeNoise.activeHotSpots(seed), BiomeNoise.plateRegions(seed), 2048, 0.25).map(y -> Math.max(y - 0.2, 0.0) * 1.25);
    }

    public static Noise2D ancientHotSpots(long seed) {
        return BiomeNoise.hotSpotWarp(BiomeNoise.activeHotSpots(seed), BiomeNoise.plateRegions(seed), 3072, 0.5).map(y -> Math.max(y - 0.3, 0.0) * 1.4286);
    }

    public static Noise2D hotSpotIntensity(long seed) {
        return BiomeNoise.activeHotSpots(seed).max(BiomeNoise.dormantHotSpots(seed)).max(BiomeNoise.extinctHotSpots(seed)).max(BiomeNoise.ancientHotSpots(seed));
    }

    public static Noise2D hotSpotWarp(Noise2D noiseToWarp, Noise2D warp, int velocityScale, double accelScale) {
        return (x, z) -> {
            double ux = warp.noise(x, z);
            double uz = (double)(Math.abs(ux * 16.0) % 1.0 > 0.5 ? 1 : -1) * (ux * 256.0) % 1.0;
            int sx = ux > 0.0 ? 1 : -1;
            int sz = uz > 0.0 ? 1 : -1;
            double vx = (ux + (double)sx) * (double)velocityScale;
            double vz = (uz + (double)sz) * (double)velocityScale;
            double ax = -vz * accelScale;
            double az = vx * accelScale;
            return noiseToWarp.noise(x + vx + ax, z + vz + az);
        };
    }

    public static Noise2D hotSpotAge(long seed) {
        Noise2D active = BiomeNoise.activeHotSpots(seed);
        Noise2D dormant = BiomeNoise.dormantHotSpots(seed);
        Noise2D extinct = BiomeNoise.extinctHotSpots(seed);
        Noise2D ancient = BiomeNoise.ancientHotSpots(seed);
        return BiomeNoise.mapAges(active, dormant, extinct, ancient);
    }

    public static Noise2D mapAges(Noise2D activeNoise, Noise2D youngNoise, Noise2D oldNoise, Noise2D oldestNoise) {
        return (x, z) -> {
            double active = activeNoise.noise(x, z);
            double young = youngNoise.noise(x, z);
            double old = oldNoise.noise(x, z);
            double oldest = oldestNoise.noise(x, z);
            if (Math.max(Math.max(active, young), Math.max(old, oldest)) <= -0.8) {
                return 0.0;
            }
            if (active > young && active > old && active > oldest) {
                return 1.0;
            }
            if (young > active && young > old && young > oldest) {
                return 2.0;
            }
            if (old > young && old > oldest && old > active) {
                return 3.0;
            }
            if (oldest > young && oldest > old && oldest > active) {
                return 4.0;
            }
            return 0.0;
        };
    }

    public static Cellular2D plateRegions(long seed) {
        return new Cellular2D(seed).spread(6.152343848953024E-5);
    }

    public static Noise2D addVolcanoes(Seed seed, Noise2D baseNoise, int rarity, int baseVolcanoHeight, int scaleVolcanoHeight, boolean onShieldVolcano) {
        VolcanoNoise volcanoes = new VolcanoNoise(seed);
        return (x, z) -> onShieldVolcano ? volcanoes.modifyShieldVolcanoHeight(x, z, baseNoise.noise(x, z), rarity, baseVolcanoHeight, scaleVolcanoHeight) : volcanoes.modifyHeight(x, z, baseNoise.noise(x, z), rarity, baseVolcanoHeight, scaleVolcanoHeight);
    }

    public static Noise2D addTuffRings(Seed seed, Noise2D baseNoise, int rarity, int baseRingHeight, int scaleRingHeight) {
        TuffRingNoise rings = new TuffRingNoise(seed);
        return (x, z) -> rings.modifyHeight(x, z, baseNoise, rarity, baseRingHeight, scaleRingHeight, seed.seed());
    }

    public static Noise2D addTuyas(Seed seed, Noise2D baseNoise, int rarity, int baseVolcanoHeight, int scaleVolcanoHeight, boolean icy) {
        TuyaNoise tuyas = new TuyaNoise(seed);
        return (x, z) -> tuyas.modifyHeight(x, z, baseNoise.noise(x, z), rarity, baseVolcanoHeight, scaleVolcanoHeight, icy);
    }

    public static Noise3D cliffNoise(Seed seed) {
        return new OpenSimplex3D(seed.seed()).octaves(2).spread(0.1f);
    }

    public static Noise2D lowerTerraceNoise(Seed seed) {
        return BiomeNoise.hills(seed.seed(), 7, 15);
    }

    public static Noise2D upperTerraceNoise(Seed seed) {
        return BiomeNoise.hills(seed.seed(), 18, 30);
    }

    public static Noise2D shoreTideLevelNoise(Seed seed) {
        return new OpenSimplex2D(seed.seed()).octaves(3).spread(0.005f).scaled(57.0, 69.0).clamped(63.0, 67.0).add(new OpenSimplex2D(seed.seed()).spread(0.03));
    }

    public static BiomeNoiseSampler undergroundLakes(long seed, final Noise2D heightNoise) {
        final Noise2D blobsNoise = new OpenSimplex2D(seed + 1L).spread(0.04f).abs();
        final OpenSimplex2D depthNoise = new OpenSimplex2D(seed + 2L).octaves(4).scaled(2.0, 18.0).spread(0.2f);
        final OpenSimplex2D centerNoise = new OpenSimplex2D(seed + 3L).octaves(2).spread(0.06f).scaled(59.0, 67.0);
        return new BiomeNoiseSampler(){
            private double surfaceHeight;
            private double center;
            private double height;

            @Override
            public void setColumn(int x, int z) {
                double h0 = Mth.clamp((double)(((double)0.7f - blobsNoise.noise(x, z)) * 3.3333332538604736), (double)0.0, (double)1.0);
                double h1 = depthNoise.noise(x, z);
                this.surfaceHeight = heightNoise.noise(x, z);
                this.center = centerNoise.noise(x, z);
                this.height = h0 * h1;
            }

            @Override
            public double height() {
                return this.surfaceHeight;
            }

            @Override
            public double noise(int y) {
                double delta = Math.abs(this.center - (double)y);
                return Mth.clamp((double)((double)0.4f + (double)0.05f * (this.height - delta)), (double)0.0, (double)1.0);
            }
        };
    }
}

