/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.CenterOrDistanceNoise;
import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public final class TuffRingNoise
implements CenterOrDistanceNoise {
    private final Cellular2D cellNoise;
    private final Noise2D jitterNoise;

    private static float calculateEasing(float f1) {
        return Mth.map((float)f1, (float)0.0f, (float)0.23f, (float)1.0f, (float)0.0f);
    }

    private static float calculateClampedEasing(float f1) {
        return Mth.clamp((float)TuffRingNoise.calculateEasing(f1), (float)0.0f, (float)1.0f);
    }

    private static float calculateShape(float t) {
        return t < 0.03f ? 0.0f : (t < 0.1f ? t * 7.0f - 0.21f : (t < 0.15f ? t * 6.6667f : (t < 0.2f ? 1.0f - (t - 0.15f) * 6.6667f : 1.5f - 5.0f * t)));
    }

    public TuffRingNoise(Seed seed) {
        this.cellNoise = new Cellular2D(seed.seed()).spread(0.003f);
        this.jitterNoise = new OpenSimplex2D(seed.seed() + 1234123L).octaves(2).scaled(-0.032f, 0.032f).spread(0.064f);
    }

    public double modifyHeight(double x, double z, Noise2D baseNoise, int rarity, int baseVolcanoHeight, int scaleHeight, long seed) {
        Cellular2D.Cell cell = this.sampleCell(x, z, rarity);
        double baseHeight = baseNoise.noise(x, z);
        if (cell != null) {
            float f1 = (float)cell.f1();
            float easing = Mth.clamp((float)(TuffRingNoise.calculateEasing(f1) + (float)this.jitterNoise.noise(x, z)), (float)0.0f, (float)1.0f);
            float shape = TuffRingNoise.calculateShape(1.0f - easing);
            float ringAdditionalHeight = shape * (float)scaleHeight + ((double)shape > 0.5 ? this.addNoise(seed, x, z) : 0.0f);
            float ringHeight = (float)(63 + baseVolcanoHeight) + ringAdditionalHeight;
            return Mth.lerp((double)(50.0 * Mth.clamp((double)(cell.f2() - (double)f1), (double)0.0, (double)0.02)), (double)baseHeight, (double)Math.max((double)ringHeight, baseHeight));
        }
        return baseHeight;
    }

    public float addNoise(long seed, double x, double z) {
        return (float)new OpenSimplex2D(seed).octaves(2).spread(0.1).scaled(-2.0, 8.0).noise(x, z);
    }

    @Override
    public float calculateEasing(int x, int z, int rarity) {
        Cellular2D.Cell cell = this.sampleCell(x, z, rarity);
        if (cell != null) {
            return TuffRingNoise.calculateClampedEasing((float)cell.f1());
        }
        return 0.0f;
    }

    @Override
    @Nullable
    public BlockPos calculateCenter(int x, int y, int z, int rarity) {
        Cellular2D.Cell cell = this.sampleCell(x, z, rarity);
        if (cell != null) {
            return new BlockPos((int)cell.x(), y, (int)cell.y());
        }
        return null;
    }

    @Nullable
    private Cellular2D.Cell sampleCell(double x, double z, int rarity) {
        Cellular2D.Cell cell = this.cellNoise.cell(x, z);
        if (Math.abs(cell.noise()) <= (double)(1.0f / (float)rarity)) {
            return cell;
        }
        return null;
    }

    @Override
    public boolean isValidBiome(BiomeExtension biome) {
        return biome.hasTuffRings();
    }

    @Override
    public int getRarity(BiomeExtension biome) {
        return biome.getTuffRingRarity();
    }
}

