/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.biome;

import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.dries007.tfc.world.biome.CenterOrDistanceNoise;
import net.dries007.tfc.world.noise.Cellular2D;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public final class TuyaNoise
implements CenterOrDistanceNoise {
    private final Cellular2D cellNoise;
    private final Noise2D jitterNoise;
    private final Seed seed;

    private static float calculateEasing(float f1) {
        return Mth.map((float)f1, (float)0.0f, (float)0.23f, (float)1.0f, (float)0.0f);
    }

    private static float calculateClampedEasing(float f1) {
        return Mth.clamp((float)TuyaNoise.calculateEasing(f1), (float)0.0f, (float)1.0f);
    }

    private static float calculateShape(float t) {
        return t < 0.015f ? Mth.map((float)t, (float)0.0f, (float)0.015f, (float)0.8f, (float)1.0f) : (t < 0.125f ? Mth.map((float)t, (float)0.025f, (float)0.125f, (float)1.0f, (float)0.75f) : Mth.clampedMap((float)t, (float)0.125f, (float)0.16f, (float)0.75f, (float)0.0f));
    }

    private static float calculateIcyShape(float t) {
        return t < 0.015f ? Mth.map((float)t, (float)0.0f, (float)0.015f, (float)0.8f, (float)1.0f) : (t < 0.125f ? Mth.map((float)t, (float)0.025f, (float)0.125f, (float)1.0f, (float)0.75f) : ((double)t < 0.16 ? Mth.map((float)t, (float)0.125f, (float)0.16f, (float)0.75f, (float)0.0f) : Mth.clampedMap((float)t, (float)0.16f, (float)0.19f, (float)0.0f, (float)0.5f)));
    }

    public TuyaNoise(Seed seed) {
        this.seed = seed;
        this.cellNoise = new Cellular2D(seed.seed(), 0.21f, 1).spread(0.0033f);
        this.jitterNoise = new OpenSimplex2D(seed.seed() + 1234123L).octaves(2).scaled(-0.016f, 0.016f).spread(0.128f);
    }

    public double modifyHeight(double x, double z, double baseHeight, int rarity, int baseVolcanoHeight, int scaleHeight, boolean icy) {
        Cellular2D.Cell cell = this.sampleCell(x, z, rarity);
        if (cell != null) {
            float easing = Mth.clamp((float)(TuyaNoise.calculateEasing((float)cell.f1()) + (float)this.jitterNoise.noise(x, z)), (float)0.0f, (float)1.0f);
            float shape = icy ? TuyaNoise.calculateIcyShape(1.0f - easing) : TuyaNoise.calculateShape(1.0f - easing);
            float additionalHeight = shape * (float)scaleHeight + this.addNoise(this.seed.seed(), x, z);
            float tuyaHeight = (float)(63 + baseVolcanoHeight) + additionalHeight;
            return Mth.lerp((double)easing, (double)baseHeight, (double)(0.5 * ((double)tuyaHeight + Math.max((double)tuyaHeight, baseHeight + (double)(0.4f * additionalHeight)))));
        }
        return baseHeight;
    }

    public float addNoise(long seed, double x, double z) {
        return (float)new OpenSimplex2D(seed).octaves(2).spread(0.1).scaled(-2.0, 3.0).noise(x, z);
    }

    @Override
    public boolean isValidBiome(BiomeExtension biome) {
        return biome.hasTuyas();
    }

    @Override
    public int getRarity(BiomeExtension biome) {
        return biome.getTuyaRarity();
    }

    @Override
    public float calculateEasing(int x, int z, int rarity) {
        Cellular2D.Cell cell = this.sampleCell(x, z, rarity);
        if (cell != null) {
            return TuyaNoise.calculateClampedEasing((float)cell.f1());
        }
        return 0.0f;
    }

    @Override
    @Nullable
    public BlockPos calculateCenter(int x, int y, int z, int rarity) {
        Cellular2D.Cell cell = this.sampleCell(x, z, rarity);
        if (cell != null) {
            return new BlockPos((int)cell.x(), y, (int)cell.y());
        }
        return null;
    }

    @Nullable
    private Cellular2D.Cell sampleCell(double x, double z, int rarity) {
        Cellular2D.Cell cell = this.cellNoise.cell(x, z);
        if (Math.abs(cell.noise()) <= (double)(1.0f / (float)rarity)) {
            return cell;
        }
        return null;
    }
}

