/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.carver;

import java.util.function.BiPredicate;
import net.dries007.tfc.common.blocks.soil.IDirtBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public final class CarverHelpers {
    public static final BlockState AIR = Blocks.CAVE_AIR.defaultBlockState();
    public static final FluidState WATER = Fluids.WATER.defaultFluidState();
    public static final FluidState LAVA = Fluids.LAVA.defaultFluidState();

    public static <C extends CarverConfiguration> boolean carveBlock(CarvingContext context, C config, ChunkAccess chunk, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos checkPos, Aquifer aquifer, MutableBoolean reachedSurface, BiPredicate<C, BlockState> canReplaceBlock) {
        BlockState carvingState;
        BlockState stateAt = chunk.getBlockState((BlockPos)pos);
        if ((canReplaceBlock.test(config, stateAt) || CarverHelpers.isDebugEnabled(config)) && (carvingState = CarverHelpers.getCarveState(context, config, (BlockPos)pos, aquifer)) != null) {
            chunk.setBlockState((BlockPos)pos, carvingState, false);
            if (reachedSurface.isTrue()) {
                checkPos.setWithOffset((Vec3i)pos, Direction.DOWN);
                Block block = chunk.getBlockState((BlockPos)checkPos).getBlock();
                if (block instanceof IDirtBlock) {
                    IDirtBlock dirt = (IDirtBlock)block;
                    chunk.setBlockState((BlockPos)checkPos, dirt.getGrass(), false);
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static <C extends CarverConfiguration> BlockState getCarveState(CarvingContext context, C config, BlockPos pos, Aquifer aquifer) {
        if (pos.getY() <= config.lavaLevel.resolveY((WorldGenerationContext)context)) {
            return LAVA.createLegacyBlock();
        }
        BlockState carveState = aquifer.computeSubstance((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()), 0.0);
        if (carveState == null) {
            return CarverHelpers.isDebugEnabled(config) ? config.debugSettings.getBarrierState() : null;
        }
        return CarverHelpers.isDebugEnabled(config) ? CarverHelpers.getDebugState(config, carveState) : carveState;
    }

    public static BlockState getDebugState(CarverConfiguration config, BlockState state) {
        if (Helpers.isBlock(state, Blocks.AIR)) {
            return config.debugSettings.getAirState();
        }
        if (Helpers.isBlock(state, Blocks.WATER)) {
            BlockState debugState = config.debugSettings.getWaterState();
            return debugState.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)debugState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : debugState;
        }
        return Helpers.isBlock(state, Blocks.LAVA) ? config.debugSettings.getLavaState() : state;
    }

    public static boolean isDebugEnabled(CarverConfiguration config) {
        return config.debugSettings.isDebugMode();
    }
}

