/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.world.region.Units;
import net.minecraft.world.level.ChunkPos;

public record ChunkRockDataCache(ChunkPos pos, List<float[]> layerHeight, List<float[]> layerSkew) {
    public ChunkRockDataCache(ChunkPos pos) {
        this(pos, new ArrayList<float[]>(8), new ArrayList<float[]>(8));
    }

    public int layers() {
        return this.layerHeight.size();
    }

    public void addLayer(float[] layerHeight, float[] layerSkew) {
        assert (layerHeight.length == 256);
        assert (layerSkew.length == 512);
        this.layerHeight.add(layerHeight);
        this.layerSkew.add(layerSkew);
    }

    public float getLayerHeight(int layer, int x, int z) {
        return this.layerHeight.get(layer)[Units.index(x, z)];
    }

    public float getLayerSkewX(int layer, int x, int z) {
        return this.layerSkew.get(layer)[Units.index(x, z) << 1];
    }

    public float getLayerSkewZ(int layer, int x, int z) {
        return this.layerSkew.get(layer)[Units.index(x, z) << 1 | 1];
    }
}

