/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.world.chunkdata;

import java.util.List;
import net.dries007.tfc.util.IArtist;
import net.dries007.tfc.world.Seed;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataGenerator;
import net.dries007.tfc.world.chunkdata.ChunkRockDataCache;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.LerpFloatLayer;
import net.dries007.tfc.world.layer.TFCLayers;
import net.dries007.tfc.world.layer.framework.Area;
import net.dries007.tfc.world.layer.framework.ConcurrentArea;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.dries007.tfc.world.region.Region;
import net.dries007.tfc.world.region.RegionGenerator;
import net.dries007.tfc.world.region.RiverEdge;
import net.dries007.tfc.world.region.Units;
import net.dries007.tfc.world.river.MidpointFractal;
import net.dries007.tfc.world.settings.RockLayerSettings;
import net.dries007.tfc.world.settings.RockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.jetbrains.annotations.Nullable;

public final class RegionChunkDataGenerator
implements ChunkDataGenerator {
    private static final int LAYER_OFFSET_BITS = 3;
    private static final int LAYER_OFFSET_MASK = 7;
    private static final int[] LAYER_OFFSETS = new int[16];
    private static final float DELTA_Y_OFFSET = 12.0f;
    private static final int MIN_RIVER_WIDTH = 12;
    private static final float RIVER_INFLUENCE;
    private static final float RIVER_INFLUENCE_SQ;
    private final RegionGenerator regionGenerator;
    private final RockLayerSettings rockLayerSettings;
    private final ConcurrentArea<ForestType> forestTypeLayer;
    private final ThreadLocal<Area> rockLayerArea;
    private final Noise2D layerHeightNoise;
    private final Noise2D layerSkewXNoise;
    private final Noise2D layerSkewZNoise;

    private static int getOffsetX(int layer) {
        return LAYER_OFFSETS[(layer & 7) << 1];
    }

    private static int getOffsetZ(int layer) {
        return LAYER_OFFSETS[(layer & 7) << 1 | 1];
    }

    public RegionChunkDataGenerator(RegionGenerator regionGenerator, RockLayerSettings rockLayerSettings, Seed seed) {
        this.regionGenerator = regionGenerator;
        this.rockLayerSettings = rockLayerSettings;
        this.rockLayerArea = ThreadLocal.withInitial(TFCLayers.createOverworldRockLayer(regionGenerator, seed.next()));
        this.layerHeightNoise = new OpenSimplex2D(seed.next()).octaves(3).scaled(43.0, 63.0).spread(0.014f);
        this.layerSkewXNoise = new OpenSimplex2D(seed.next()).octaves(2).scaled(-1.8f, 1.8f).spread(0.01f);
        this.layerSkewZNoise = new OpenSimplex2D(seed.next()).octaves(2).scaled(-1.8f, 1.8f).spread(0.01f);
        this.forestTypeLayer = new ConcurrentArea<ForestType>(TFCLayers.createOverworldForestLayer(seed.next(), IArtist.nope()), ForestType::valueOf);
    }

    @Override
    public ChunkData generate(ChunkData data) {
        switch (data.status()) {
            case EMPTY: {
                break;
            }
            case PARTIAL: 
            case FULL: {
                return data;
            }
            case CLIENT: 
            case INVALID: {
                throw new IllegalStateException("generate() called on chunk data with status " + String.valueOf((Object)data.status()));
            }
        }
        ChunkPos pos = data.getPos();
        int blockX = pos.getMinBlockX();
        int blockZ = pos.getMinBlockZ();
        int gridX = Units.blockToGrid(blockX);
        int gridZ = Units.blockToGrid(blockZ);
        Region.Point point00 = this.regionGenerator.getOrCreateRegionPoint(gridX, gridZ);
        Region.Point point01 = this.regionGenerator.getOrCreateRegionPoint(gridX, gridZ + 1);
        Region.Point point10 = this.regionGenerator.getOrCreateRegionPoint(gridX + 1, gridZ);
        Region.Point point11 = this.regionGenerator.getOrCreateRegionPoint(gridX + 1, gridZ + 1);
        LerpFloatLayer rainfallGridLayer = new LerpFloatLayer(point00.rainfall, point01.rainfall, point10.rainfall, point11.rainfall);
        LerpFloatLayer rainfallVarianceGridLayer = new LerpFloatLayer(point00.rainfallVariance, point01.rainfallVariance, point10.rainfallVariance, point11.rainfallVariance);
        LerpFloatLayer temperatureGridLayer = new LerpFloatLayer(point00.temperature, point01.temperature, point10.temperature, point11.temperature);
        double exactGridX = Units.blockToGridExact(blockX);
        double exactGridZ = Units.blockToGridExact(blockZ);
        float deltaX = (float)(exactGridX - (double)gridX);
        float deltaZ = (float)(exactGridZ - (double)gridZ);
        float dG = (float)Units.blockToGridExact(16.0);
        LerpFloatLayer rainfallLayer = rainfallGridLayer.scaled(deltaX, deltaZ, dG);
        LerpFloatLayer rainfallVarianceLayer = rainfallVarianceGridLayer.scaled(deltaX, deltaZ, dG);
        LerpFloatLayer temperatureLayer = temperatureGridLayer.scaled(deltaX, deltaZ, dG);
        float groundwater00 = 0.0f;
        float groundwater01 = 0.0f;
        float groundwater10 = 0.0f;
        float groundwater11 = 0.0f;
        for (RiverEdge edge : this.regionGenerator.getOrCreatePartitionPoint(gridX, gridZ).rivers()) {
            MidpointFractal fractal = edge.fractal();
            if (edge.width < 12 || !fractal.maybeIntersect(exactGridX, exactGridZ, RIVER_INFLUENCE)) continue;
            float widthInfluence = Mth.map((float)edge.width, (float)12.0f, (float)24.0f, (float)0.0f, (float)1.0f);
            groundwater00 = this.adjustGroundwaterNearRiver(groundwater00, widthInfluence, fractal, exactGridX, exactGridZ);
            groundwater01 = this.adjustGroundwaterNearRiver(groundwater01, widthInfluence, fractal, exactGridX, exactGridZ + (double)dG);
            groundwater10 = this.adjustGroundwaterNearRiver(groundwater10, widthInfluence, fractal, exactGridX + (double)dG, exactGridZ);
            groundwater11 = this.adjustGroundwaterNearRiver(groundwater11, widthInfluence, fractal, exactGridX + (double)dG, exactGridZ + (double)dG);
        }
        LerpFloatLayer baseGroundwaterLayer = new LerpFloatLayer(groundwater00, groundwater01, groundwater10, groundwater11).apply(value -> Mth.clamp((float)value, (float)0.0f, (float)500.0f));
        ForestType forestType = this.forestTypeLayer.get(blockX >> 4, blockZ >> 4);
        data.generatePartial(rainfallLayer, rainfallVarianceLayer, baseGroundwaterLayer, temperatureLayer, forestType);
        return data;
    }

    private float adjustGroundwaterNearRiver(float currentValue, float widthInfluence, MidpointFractal fractal, double gridX, double gridZ) {
        float distance = (float)fractal.intersectDistance(gridX, gridZ);
        float distanceInfluence = Mth.clampedMap((float)distance, (float)0.0f, (float)RIVER_INFLUENCE_SQ, (float)1.0f, (float)0.0f);
        return Math.max(currentValue, distanceInfluence * widthInfluence * 300.0f);
    }

    @Override
    public RockSettings generateRock(int x, int y, int z, int surfaceY, @Nullable ChunkRockDataCache cache) {
        return this.generateRock(x, y, z, surfaceY, cache, null);
    }

    @Override
    public void displayDebugInfo(List<String> tooltip, BlockPos pos, int surfaceY) {
        this.generateRock(pos.getX(), pos.getY(), pos.getZ(), surfaceY, null, tooltip);
    }

    private RockSettings generateRock(int x, int y, int z, int surfaceY, @Nullable ChunkRockDataCache cache, @Nullable List<String> tooltip) {
        float skewNoiseZ;
        float skewNoiseX;
        int offsetX;
        int offsetZ;
        float layerHeight;
        float adjustedSurfaceY = surfaceY;
        if (adjustedSurfaceY > 125.0f) {
            adjustedSurfaceY = 125.0f + 0.3f * (float)(surfaceY - 125);
        }
        int layer = 0;
        float deltaY = adjustedSurfaceY - (float)y;
        do {
            if (cache != null) {
                this.populateLayerInCache(cache, layer);
                layerHeight = cache.getLayerHeight(layer, x, z);
            } else {
                int layerX = x + RegionChunkDataGenerator.getOffsetX(layer);
                int layerZ = z + RegionChunkDataGenerator.getOffsetZ(layer);
                layerHeight = (float)this.layerHeightNoise.noise(layerX, layerZ);
            }
            if (deltaY <= layerHeight) break;
            ++layer;
        } while ((deltaY -= layerHeight) > 0.0f);
        if (cache != null) {
            offsetZ = 0;
            offsetX = 0;
            skewNoiseX = cache.getLayerSkewX(layer, x, z);
            skewNoiseZ = cache.getLayerSkewZ(layer, x, z);
        } else {
            offsetX = x + RegionChunkDataGenerator.getOffsetX(layer);
            offsetZ = z + RegionChunkDataGenerator.getOffsetZ(layer);
            skewNoiseX = (float)this.layerSkewXNoise.noise(offsetX, offsetZ);
            skewNoiseZ = (float)this.layerSkewZNoise.noise(offsetX, offsetZ);
        }
        int skewX = x + (int)(skewNoiseX * (deltaY + 12.0f));
        int skewZ = z + (int)(skewNoiseZ * (deltaY + 12.0f));
        int point = this.rockLayerArea.get().get(skewX, skewZ);
        RockSettings rock = this.rockLayerSettings.sampleAtLayer(point, layer);
        if (tooltip != null) {
            tooltip.add("Pos: %d, %d, %d S: %d dY: %.1f Layer: %d LayerH: %.1f".formatted(x, y, z, surfaceY, Float.valueOf(deltaY), layer, Float.valueOf(layerHeight)));
            tooltip.add("Offset: %d, %d Skew: %.1f, %.1f / %d, %d Seed: %d Type: %d".formatted(offsetX, offsetZ, Float.valueOf(skewNoiseX), Float.valueOf(skewNoiseZ), skewX, skewZ, point >> 2, point & 3));
            tooltip.add("Rock: %s".formatted(BuiltInRegistries.BLOCK.getKey((Object)rock.raw())));
        }
        return rock;
    }

    private void populateLayerInCache(ChunkRockDataCache cache, int layer) {
        if (cache.layers() <= layer) {
            int chunkX = cache.pos().getMinBlockX();
            int chunkZ = cache.pos().getMinBlockZ();
            for (int populateLayer = cache.layers(); populateLayer <= layer; ++populateLayer) {
                float[] populatedLayerHeight = new float[256];
                float[] populatedLayerSkew = new float[512];
                int layerX = chunkX + RegionChunkDataGenerator.getOffsetX(layer);
                int layerZ = chunkZ + RegionChunkDataGenerator.getOffsetZ(layer);
                for (int dx = 0; dx < 16; ++dx) {
                    for (int dz = 0; dz < 16; ++dz) {
                        int offsetX = layerX + dx;
                        int offsetZ = layerZ + dz;
                        int i = Units.index(dx, dz);
                        populatedLayerHeight[i] = (float)this.layerHeightNoise.noise(offsetX, offsetZ);
                        populatedLayerSkew[i << 1] = (float)this.layerSkewXNoise.noise(offsetX, offsetZ);
                        populatedLayerSkew[i << 1 | 1] = (float)this.layerSkewZNoise.noise(offsetX, offsetZ);
                    }
                }
                cache.addLayer(populatedLayerHeight, populatedLayerSkew);
            }
        }
    }

    static {
        XoroshiroRandomSource random = new XoroshiroRandomSource(1923874192341L);
        for (int i = 0; i < LAYER_OFFSETS.length; ++i) {
            RegionChunkDataGenerator.LAYER_OFFSETS[i] = random.nextInt(0, 100000);
        }
        RIVER_INFLUENCE = (float)Units.blockToGridExact(40.0);
        RIVER_INFLUENCE_SQ = RIVER_INFLUENCE * RIVER_INFLUENCE;
    }
}

